/*
   This file is part of TALER
   Copyright (C) 2024 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file exchangedb/pg_lookup_h_payto_by_access_token.h
 * @brief implementation of the lookup_h_payto_by_access_token function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_LOOKUP_H_PAYTO_BY_ACCESS_TOKEN_H
#define PG_LOOKUP_H_PAYTO_BY_ACCESS_TOKEN_H

#include "taler_util.h"
#include "taler_json_lib.h"
#include "taler_exchangedb_plugin.h"


/**
 * Lookup @a h_payto based on an @a access_token.
 *
 * @param cls closure
 * @param access_token
 *    set to token for access control
 * @param[out] h_payto set to the the hash of the
 *    payto URI of the account (if found)
 * @param[out] is_wallet set to true if @a h_payto
 *    is for a wallet
 * @return database transaction status
 */
enum GNUNET_DB_QueryStatus
TEH_PG_lookup_h_payto_by_access_token (
  void *cls,
  const struct TALER_AccountAccessTokenP *access_token,
  struct TALER_NormalizedPaytoHashP *h_payto,
  bool *is_wallet);

#endif
