import  unittest

class Path(tuple):
    def first(self):
        v = list(self)
        v[-1] = 0
        return Path(v)
    def next(self):
        v = list(self)
        v[-1] += 1
        return Path(v)
    def prev(self):
        v = list(self)
        v[-1] -= 1
        return Path(v)
    def child(self):
        v = list(self)
        v.append(0)
        return Path(v)
    def parent(self):
        v = list(self)
        v = v[:-1]
        return Path(v)

class TestPath(unittest.TestCase):
    def test_next(self):
        p = Path((1, 2, 3))
        self.assert_(p.next(), (1, 2, 4))
    def test_prev(self):
        p = Path((1, 2, 3))
        self.assert_(p.prev(), (1, 2, 2))
    def test_child(self):
        p = Path((1, 2, 3))
        self.assert_(p.child(), (1, 2, 3, 0))
    def test_parent(self):
        p = Path((1, 2, 3))
        self.assert_(p.parent(), (1, 2))


if __name__ == '__main__':
    unittest.main()
