# GNU Solfege - ear training for GNOME
# Copyright (C) 2004, 2005  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin ST, Fifth Floor, Boston, MA  02110-1301  USA

import gobject
import gtk
import gu
import abstract
import lessonfile
import dataparser
import mpd
import utils
import const
import soundcard

class Teacher(abstract.LessonbasedTeacher):
    OK = 1
    ERR_NO_QUESTION = 2
    def __init__(self, exname, app):
        abstract.LessonbasedTeacher.__init__(self, exname, app)
        self.lessonfileclass = lessonfile.SingAnswerLessonfile
    def new_question(self):
        # TODO This function is very similar to the one in src/idbyname.py
        self.q_status = const.QSTATUS_NO
        assert self.m_P
        try:
            self.m_P.select_random_question()
            self.q_status = const.QSTATUS_NEW
            return self.OK
        except lessonfile.NoQuestionConfiguredException:
            return self.ERR_NO_QUESTION

class Gui(abstract.LessonbasedGui):
    def __init__(self, teacher, window):
        abstract.Gui.__init__(self, teacher, window)
        self.g_music_displayer = mpd.musicdisplayer.MusicDisplayer(utils.play_tone)
        self.practise_box.pack_start(self.g_music_displayer)
        self.g_flashbar = gu.FlashBar()
        self.practise_box.pack_start(self.g_flashbar)
        self.g_music_displayer.clear()
        self.g_new = gu.bButton(self.action_area, _("_New"), self.new_question)
        self.g_repeat = gu.bButton(self.action_area, _("_Repeat"), self.repeat_question)
        self.g_repeat_arpeggio = gu.bButton(self.action_area, _("Repeat _arpeggio"), self.repeat_question_arpeggio)
        self.g_play_answer = gu.bButton(self.action_area, 
                    _("_Play answer"), self.hear_answer)
        ##############
        # config_box #
        ##############
        self.add_random_transpose_gui()
        self.practise_box.show_all()
    def new_question(self, widget):
        def exception_cleanup():
            soundcard.synth.stop()
            self.g_music_displayer.clear()
            self.g_repeat.set_sensitive(False)
            self.g_repeat_arpeggio.set_sensitive(False)
            self.g_play_answer.set_sensitive(False)
        if self.m_t.m_P.header.have_music_displayer:
            self.g_music_displayer.clear()
        try:
            g = self.m_t.new_question()
            self.g_music_displayer.display(self.m_t.m_P.get_music(), 20)
            self.g_flashbar.push(self.m_t.m_P.get_question()['question_text'])
            self.m_t.m_P.play_question()
            self.g_repeat.set_sensitive(True)
            self.g_repeat_arpeggio.set_sensitive(True)
            self.g_play_answer.set_sensitive(True)
            self.g_play_answer.grab_focus()
        except lessonfile.LessonfileException, e:
            exception_cleanup()
            self.g_win.display_exception_message(e, __file__)
        except mpd.MpdException, e:
            # Invalid key variable or music code goes here.
            exception_cleanup()
            self.g_win.display_question_music_error_message(
                self.m_t.m_P._idx, self.m_t.m_lessonfile, e, __file__)
    def repeat_question(self, widget):
        self.m_t.m_P.play_question()
    def repeat_question_arpeggio(self, widget):
        self.m_t.m_P.play_question_arpeggio()
    def hear_answer(self, widget):
        try:
            mpd.play_music(self.m_t.m_P.prepare_music_from_string(self.m_t.m_P.get_question(), 'answer'), 120, 0, 100)
        except lessonfile.LessonfileException, e:
            soundcard.synth.stop()
            self.g_win.display_exception_message(e, __file__)
        except mpd.MpdException, e:
            # Invalid key variable or music code goes here.
            soundcard.synth.stop()
            self.g_win.display_question_music_error_message(
                self.m_t.m_P._idx, self.m_t.m_lessonfile, e, __file__)
        self.g_new.grab_focus()
    def update_gui_after_lessonfile_change(self):
        self.g_random_transpose.set_text(str(self.m_t.m_P.header.random_transpose))
        if self.m_t.m_P.header.have_repeat_arpeggio_button:
            self.g_repeat_arpeggio.show()
        else:
            self.g_repeat_arpeggio.hide()
        if self.m_t.m_P.header.have_music_displayer:
            self.g_music_displayer.show()
        else:
            self.g_music_displayer.hide()
        self.g_repeat.set_sensitive(False)
        self.g_repeat_arpeggio.set_sensitive(False)
        self.g_play_answer.set_sensitive(False)
        self.g_flashbar.clear()
        self.g_new.set_sensitive(bool(self.m_t.m_P))
    def on_start_practise(self):
        self.update_gui_after_lessonfile_change()
        self.g_new.grab_focus()
        gobject.timeout_add(const.SHORT_WAIT, lambda self=self:
            self.g_flashbar.flash(_("Click 'New' to begin.")))
        self.g_flashbar.require_size(
            [q['question_text'] for q in self.m_t.m_P.m_questions]
            + [_("Click 'New' to begin.")])
