/*   This file contains the C language interface to the sound archive library
     software for Sather.  */

/*   First include the library header files */

#include "config.h"
#include "arch.h"
#include "/opt/Sather/System/header.h"


INT reading(void){
          return OPEN_READ ;
          }
          
EXT_OB sa_open_arch(char *name, int mode)
     {
     int loc_res = open_archive(name,mode) ;

     if (loc_res < 0)
          return (void *)0 ;
     else
          return (void *)loc_res ;
     }
     
BOOL sa_close_arch(EXT_OB archive_handle)
     {
     int loc_res = close_archive((int)archive_handle) ;
     return (loc_res == 0) ;
     }

INT sa_first_index(INT* archive_handle, INT* entry_ptr)
     {
     archive_index_entry_type *loc_res =
                                     malloc(sizeof(archive_index_entry_type)) ;
     int res = get_first_index((int)archive_handle,loc_res) ;

     if (res < 0)
          return 0 ;
     else {
          *(int **)entry_ptr = (int *) loc_res ;
          return res ;
          }
     }
     
INT sa_next_index(EXT_OB archive_handle, EXT_OB *entry_ptr)
     {
     archive_index_entry_type *loc_res =
                                     malloc(sizeof(archive_index_entry_type)) ;
     int res = get_next_index((int)archive_handle,loc_res) ;

     if (res < 0)
          return 0 ;
     else {
          *(int **)entry_ptr = (int *) loc_res ;
          return res ;
          }
     }
     
BOOL sa_insert(EXT_OB archive_handle,
               char *entry_name,
               char *signature,              /* really 'signature_type' */
               int kind,
               EXT_OB data_ptr,
               int data_size)
     {
     int loc_res = insert_entry((int)archive_handle, entry_name,
                        signature, kind, data_ptr, data_size) ;

     return (loc_res == 0) ;
     } ;

BOOL sa_delete(EXT_OB handle, INT entry)
     {
     int loc_res = delete_entry((int)handle,entry) ;
     return (loc_res == 0) ;
     }
          
INT sa_get(EXT_OB handle, INT entry, EXT_OB buff,int size)
     {
     int loc_res = get_entry_data((int)handle,entry,buff,size) ;
     return loc_res ;
     }
     

BOOL sa_modify(EXT_OB handle, EXT_OB entry, EXT_OB index_entry)
     {
     int loc_res = modify_entry((int)handle, (int)entry,
                       (archive_index_entry_type *)index_entry) ;
     return (loc_res == 0) ;
     }
     
