/*  Motti -- a strategy game
    Copyright (C) 1999-2010 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
// otti.cpp: dfinit le point d'entre pour l'application console.
//
#include <vector>
#include "StdAfx.h"

#include <iostream>
#ifdef WIN32
#include <windows.h>
#endif 
#include "MapManager.h"
#include "GameManager.h"
#include "StringDrawer.h"
#include "MapGenerator.h"
#ifndef WIN32
#include <time.h>
#include <config.h>
#include <cstdlib>
#include <cstdio>
#include <stdio.h>
#include <string.h>
#endif

std::string getVersion(){
	std::string  mess="";
	mess+=" e88~~\\  888b    | 888   |        e    e                 d8     d8   ,e,\n";
	mess+="d888     |Y88b   | 888   |       d8b  d8b      e88~-_  _d88__ _d88__  \" \n";
	mess+="8888 __  | Y88b  | 888   |      d888bdY88b    d888   i  888    888   888\n";
	mess+="8888   | |  Y88b | 888   |     / Y88Y Y888b   8888   |  888    888   888\n";
	mess+="Y888   | |   Y88b| Y88   |    /   YY   Y888b  Y888   '  888    888   888\n";
 	mess+=" \"88__/  |    Y888  \"8__/    /          Y888b  \"88_-~   \"88_/  \"88_/ 888\n";
	mess+="GNU Motti (GNU game) "+std::string(PACKAGE_VERSION)+"\n";
	mess+="Copyright (C) 2010 Free Software Foundation, Inc.\n";
	mess+="This is free software.  You may redistribute copies of it under the terms of \n";
	mess+="the GNU General Public License <http://www.gnu.org/licenses/gpl.html>.\n";
	mess+="There is NO WARRANTY, to the extent permitted by law.\n";
	mess+="Written by Kari Pahulam,Sebastien DIAZ and Claudio Fontana.\n";

	return mess;
}

std::string getHelp(){
std::string  mess=getVersion();
mess+="\nUsage: /bin/motti \n";
mess+="Mandatory arguments to long options are mandatory for short options too. \n";
mess+="      -h --help     display this help and exit \n";
mess+="      -v --version  output version information and exit \n";
mess+="\n\nExit status is 0 if OK, 1 if minor problems, 2 if serious trouble.\n";
mess+="\nReport bugs to http://savannah.gnu.org/projects/motti.\n";
	return mess;
}

void verifyVersionHelp(int argc, char *argv[]){
	int i=0;
	for (i=0;i<argc;i++)
	{
		if (strcmp(argv[i],"-v")==0 || (strcmp(argv[i],"--version")==0))
		{
			
			std::cout <<getVersion();
			exit(0);
		}
		if (strcmp(argv[i],"-h")==0 || (strcmp(argv[i],"--help")==0))
		{
			
			std::cout <<getHelp();
			exit(0);
		}
	}
}


void launchTest();
void  gameLoop();
#ifdef WIN32
int _tmain(int argc, _TCHAR* argv[])
{
	//launchTest();
	gameLoop();
	return 0;
}
#else
int main(int argc, char *argv[])
{
	//launchTest();
	verifyVersionHelp (argc,argv);
	gameLoop();
	return 0;
}	
#endif
#ifdef WIN32
int CALLBACK WinMain( HINSTANCE hInstance,  HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow
){
	gameLoop();
	return 0;

}
#endif


void gameLoop()
{
	
	int sum = 0;
	std::string x;
	
	std::string myMap="width 72\n";
	myMap+="height 6\n";
	myMap+="warped 0\n";
	myMap+="players 3\n";
	myMap+="active_players 7\n";
	myMap+="remaining_players 7\n";
	myMap+="turn 1\n";
	myMap+="n_att 0\n";

	std::string cleMap;
	cleMap+=" e88~~\\  888b    | 888   |        e    e                 d8     d8   ,e,\n";
	cleMap+="d888     |Y88b   | 888   |       d8b  d8b      e88~-_  _d88__ _d88__  \" \n";
	cleMap+="8888 __  | Y88b  | 888   |      d888bdY88b    d888   i  888    888   888\n";
	cleMap+="8888   | |  Y88b | 888   |     / Y88Y Y888b   8888   |  888    888   888\n";
	cleMap+="Y888   | |   Y88b| Y88   |    /   YY   Y888b  Y888   '  888    888   888\n";
 	cleMap+=" \"88__/  |    Y888  \"8__/    /          Y888b  \"88_-~   \"88_/  \"88_/ 888";

	

    unsigned int oi=0;
	std::string rewrited;
	int countHeight=0;
	int countWidth=0;
	for (oi=0;oi<cleMap.size();oi++)
	{
		if (cleMap.at(oi)!='\n')
		{
			rewrited+=cleMap.at(oi);
			rewrited+=" ";
			
			countWidth++;
		}
		else{
			countWidth=0;
			countHeight++;
			rewrited+=cleMap.at(oi);
		}
		
	}
	myMap+=rewrited;
	std::cout <<"\033["<<1<<";"<<1<<"H";
        //Board bBoard=MapManager::loadFileMap("..\\fin-swe.map");
	Board bBoard=MapManager::loadStringMap(myMap);
	MapGenerator mm;
	//Case *replace=mm.generateMap(5,72,6);
	//bBoard.setCases(replace);
	StringDrawer str(bBoard);
	GameManager gameM(&str,&bBoard);
	gameM.init();
	//str.setCursor(1,1);
	str.draw();
	
	gameM.manageGame();
	while (1) {
		
	
		gameM.manageGame();
#ifdef WIN32
		Sleep(50);
#else
		int milliseconds=50;

		struct timespec tmReq;
		
		 tmReq.tv_sec = (time_t)(milliseconds / 1000);
		tmReq.tv_nsec = (milliseconds % 1000) * 1000 * 1000;

		nanosleep(&tmReq,(timespec *)NULL);

#endif


	}

		
	
	

}



