/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.CompiledExpression;
import gnu.jel.ExpressionBits;
import gnu.jel.IntegerStack;
import gnu.jel.PatchableByteArrayOutputStream;
import gnu.jel.debug.Tester;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class ExpressionImage {
    public static final int BI_PL = 0;
    public static final int BI_MI = 1;
    public static final int BI_MU = 2;
    public static final int BI_DI = 3;
    public static final int BI_RE = 4;
    public static final int BI_AN = 5;
    public static final int BI_OR = 6;
    public static final int BI_XO = 7;
    public static final int BI_EQ = 8;
    public static final int BI_NE = 9;
    public static final int BI_LT = 10;
    public static final int BI_GE = 11;
    public static final int BI_GT = 12;
    public static final int BI_LE = 13;
    public static final int BI_LS = 14;
    public static final int BI_RSS = 15;
    public static final int BI_RUS = 16;
    public static final String[] binaryNames = new String[]{"add", "substract", "multiply", "divide", "remainder", "bitwise and", "bitwise or", "bitwise xor", "equal", "not equal", "less", "greater or equal", "greater", "less or equal", "left shift", "signed right shift", "unsigned right shift"};
    public static final String[] binarySymbols = new String[]{"+", "-", "*", "/", "%", "&", "|", "^", "==", "!=", "<", ">=", ">", "<=", "<<", ">>", ">>>"};
    public static final int LOG_AN = 0;
    public static final int LOG_OR = 1;
    public static final int LOG_NO = 2;
    public static final String[] logicalNames = new String[]{"logical and", "logical or", "logical not"};
    public static final String[] logicalSymbols = new String[]{"&&", "||", "!"};
    public static final int UN_NE = 0;
    public static final int UN_NO = 1;
    public static final String[] unaryNames = new String[]{"negate", "bitwise complement"};
    public static final String[] unarySymbols = new String[]{"-", "~"};
    private static final byte[] prologue;
    private int poolEntries = 1;
    private static final byte[] cp_middle;
    private static final byte[] intermezzo1;
    private byte thetype = (byte)99;
    private static final byte[] intermezzo2;
    short nameIdx = (short)9999;
    short signIdx = (short)9999;
    private static final byte[] intermezzo3;
    int max_stack = 2;
    int max_locals = 2;
    private static final byte[] konetc;
    public static final Class[] primitiveTypes;
    private static final char[] primitiveCodes;
    public static final String[] primitiveTypeNames;
    private static Class sb_class;
    private static Class tsb_class;
    private static Class string_class;
    private static Constructor sb_constructor;
    private static Method[] sb_append_primitive;
    private static Method sb_append_String;
    private static Method sb_append_Object;
    private static Method sb_toString;
    private static final byte[] returns;
    private static final byte[] cvt_wide;
    private static final int[][] cvt1;
    private static final int[][] cvt2;
    private static final byte[] stkoccup;
    private static final int[] load_ints;
    private static final int[] load_long_ints1;
    private static final int[] load_long_ints2;
    private static final int[][] binary_promotions;
    private static final int[] unary_promotions;
    private static final int[][][] ops;
    private static final boolean[] is_promotion_binary;
    private static final int[][] openjumps;
    private static final int[] norm;
    private static final int[][][] una;
    private static final int[][] una_excess_stack;
    private static final byte[] stor;
    private static final byte[] load;
    private static final byte[] sladdr;
    private static final byte CONSTANT_Class = 7;
    private static final byte CONSTANT_Fieldref = 9;
    private static final byte CONSTANT_Methodref = 10;
    private static final byte CONSTANT_InterfaceMethodref = 11;
    private static final byte CONSTANT_String = 8;
    private static final byte CONSTANT_Integer = 3;
    private static final byte CONSTANT_Float = 4;
    private static final byte CONSTANT_Long = 5;
    private static final byte CONSTANT_Double = 6;
    private static final byte CONSTANT_NameAndType = 12;
    private static final byte CONSTANT_Utf8 = 1;
    private ByteArrayOutputStream constPool;
    private DataOutputStream constPoolData;
    private Hashtable Items = new Hashtable();
    private Hashtable UTFs = new Hashtable();
    private PatchableByteArrayOutputStream methodText;
    private DataOutputStream methodTextData;
    private boolean classFinished = false;
    private int currSSW = 0;
    private Vector objectPool = new Vector();
    private Stack typesStk = new Stack();
    int jump_progress = 0;
    private Stack functionParams = new Stack();
    private Stack functionINTS = new Stack();
    private Stack functionRet = new Stack();
    private IntegerStack jumps0 = new IntegerStack();
    private IntegerStack jumps1 = new IntegerStack();
    private IntegerStack jumps = new IntegerStack();
    private IntegerStack blocks0 = new IntegerStack();
    private IntegerStack blocks1 = new IntegerStack();
    private IntegerStack branchStack = new IntegerStack();
    private boolean invert_next_jump = false;

    static {
        byte[] byArray = new byte[8];
        byArray[0] = -54;
        byArray[1] = -2;
        byArray[2] = -70;
        byArray[3] = -66;
        byArray[5] = 3;
        byArray[7] = 45;
        prologue = byArray;
        byte[] byArray2 = new byte[182];
        byArray2[0] = 7;
        byArray2[2] = 1;
        byArray2[3] = 1;
        byArray2[5] = 26;
        byArray2[6] = 103;
        byArray2[7] = 110;
        byArray2[8] = 117;
        byArray2[9] = 47;
        byArray2[10] = 106;
        byArray2[11] = 101;
        byArray2[12] = 108;
        byArray2[13] = 47;
        byArray2[14] = 67;
        byArray2[15] = 111;
        byArray2[16] = 109;
        byArray2[17] = 112;
        byArray2[18] = 105;
        byArray2[19] = 108;
        byArray2[20] = 101;
        byArray2[21] = 100;
        byArray2[22] = 69;
        byArray2[23] = 120;
        byArray2[24] = 112;
        byArray2[25] = 114;
        byArray2[26] = 101;
        byArray2[27] = 115;
        byArray2[28] = 115;
        byArray2[29] = 105;
        byArray2[30] = 111;
        byArray2[31] = 110;
        byArray2[32] = 7;
        byArray2[34] = 3;
        byArray2[35] = 1;
        byArray2[37] = 1;
        byArray2[38] = 101;
        byArray2[39] = 1;
        byArray2[41] = 19;
        byArray2[42] = 91;
        byArray2[43] = 76;
        byArray2[44] = 106;
        byArray2[45] = 97;
        byArray2[46] = 118;
        byArray2[47] = 97;
        byArray2[48] = 47;
        byArray2[49] = 108;
        byArray2[50] = 97;
        byArray2[51] = 110;
        byArray2[52] = 103;
        byArray2[53] = 47;
        byArray2[54] = 79;
        byArray2[55] = 98;
        byArray2[56] = 106;
        byArray2[57] = 101;
        byArray2[58] = 99;
        byArray2[59] = 116;
        byArray2[60] = 59;
        byArray2[61] = 1;
        byArray2[63] = 6;
        byArray2[64] = 60;
        byArray2[65] = 105;
        byArray2[66] = 110;
        byArray2[67] = 105;
        byArray2[68] = 116;
        byArray2[69] = 62;
        byArray2[70] = 1;
        byArray2[72] = 22;
        byArray2[73] = 40;
        byArray2[74] = 91;
        byArray2[75] = 76;
        byArray2[76] = 106;
        byArray2[77] = 97;
        byArray2[78] = 118;
        byArray2[79] = 97;
        byArray2[80] = 47;
        byArray2[81] = 108;
        byArray2[82] = 97;
        byArray2[83] = 110;
        byArray2[84] = 103;
        byArray2[85] = 47;
        byArray2[86] = 79;
        byArray2[87] = 98;
        byArray2[88] = 106;
        byArray2[89] = 101;
        byArray2[90] = 99;
        byArray2[91] = 116;
        byArray2[92] = 59;
        byArray2[93] = 41;
        byArray2[94] = 86;
        byArray2[95] = 1;
        byArray2[97] = 10;
        byArray2[98] = 69;
        byArray2[99] = 120;
        byArray2[100] = 99;
        byArray2[101] = 101;
        byArray2[102] = 112;
        byArray2[103] = 116;
        byArray2[104] = 105;
        byArray2[105] = 111;
        byArray2[106] = 110;
        byArray2[107] = 115;
        byArray2[108] = 1;
        byArray2[110] = 4;
        byArray2[111] = 67;
        byArray2[112] = 111;
        byArray2[113] = 100;
        byArray2[114] = 101;
        byArray2[115] = 1;
        byArray2[117] = 3;
        byArray2[118] = 40;
        byArray2[119] = 41;
        byArray2[120] = 86;
        byArray2[121] = 12;
        byArray2[123] = 7;
        byArray2[125] = 11;
        byArray2[126] = 10;
        byArray2[128] = 4;
        byArray2[130] = 12;
        byArray2[131] = 12;
        byArray2[133] = 5;
        byArray2[135] = 6;
        byArray2[136] = 9;
        byArray2[138] = 2;
        byArray2[140] = 14;
        byArray2[141] = 1;
        byArray2[143] = 7;
        byArray2[144] = 103;
        byArray2[145] = 101;
        byArray2[146] = 116;
        byArray2[147] = 84;
        byArray2[148] = 121;
        byArray2[149] = 112;
        byArray2[150] = 101;
        byArray2[151] = 1;
        byArray2[153] = 3;
        byArray2[154] = 40;
        byArray2[155] = 41;
        byArray2[156] = 73;
        byArray2[157] = 1;
        byArray2[159] = 19;
        byArray2[160] = 106;
        byArray2[161] = 97;
        byArray2[162] = 118;
        byArray2[163] = 97;
        byArray2[164] = 47;
        byArray2[165] = 108;
        byArray2[166] = 97;
        byArray2[167] = 110;
        byArray2[168] = 103;
        byArray2[169] = 47;
        byArray2[170] = 84;
        byArray2[171] = 104;
        byArray2[172] = 114;
        byArray2[173] = 111;
        byArray2[174] = 119;
        byArray2[175] = 97;
        byArray2[176] = 98;
        byArray2[177] = 108;
        byArray2[178] = 101;
        byArray2[179] = 7;
        byArray2[181] = 18;
        cp_middle = byArray2;
        byte[] byArray3 = new byte[95];
        byArray3[1] = 33;
        byArray3[3] = 2;
        byArray3[5] = 4;
        byArray3[9] = 1;
        byArray3[11] = 2;
        byArray3[13] = 5;
        byArray3[15] = 6;
        byArray3[19] = 3;
        byArray3[21] = 1;
        byArray3[23] = 7;
        byArray3[25] = 8;
        byArray3[27] = 2;
        byArray3[29] = 9;
        byArray3[33] = 2;
        byArray3[37] = 10;
        byArray3[41] = 22;
        byArray3[43] = 2;
        byArray3[45] = 2;
        byArray3[49] = 10;
        byArray3[50] = 42;
        byArray3[51] = -73;
        byArray3[53] = 13;
        byArray3[54] = 42;
        byArray3[55] = 43;
        byArray3[56] = -75;
        byArray3[58] = 15;
        byArray3[59] = -79;
        byArray3[65] = 1;
        byArray3[67] = 16;
        byArray3[69] = 17;
        byArray3[71] = 2;
        byArray3[73] = 9;
        byArray3[77] = 2;
        byArray3[81] = 10;
        byArray3[85] = 15;
        byArray3[87] = 1;
        byArray3[89] = 1;
        byArray3[93] = 3;
        byArray3[94] = 16;
        intermezzo1 = byArray3;
        byte[] byArray4 = new byte[7];
        byArray4[0] = -84;
        byArray4[6] = 1;
        intermezzo2 = byArray4;
        byte[] byArray5 = new byte[14];
        byArray5[1] = 2;
        byArray5[3] = 9;
        byArray5[7] = 4;
        byArray5[9] = 1;
        byArray5[11] = 19;
        byArray5[13] = 10;
        intermezzo3 = byArray5;
        konetc = new byte[6];
        primitiveTypes = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE};
        primitiveCodes = new char[]{'Z', 'B', 'C', 'S', 'I', 'J', 'F', 'D', 'V'};
        primitiveTypeNames = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"};
        sb_class = null;
        tsb_class = null;
        string_class = null;
        sb_constructor = null;
        sb_append_primitive = new Method[primitiveTypes.length - 1];
        sb_append_String = null;
        sb_append_Object = null;
        sb_toString = null;
        try {
            sb_class = Class.forName("java.lang.StringBuffer");
            tsb_class = Class.forName("gnu.jel.TempStringBuffer");
            string_class = Class.forName("java.lang.String");
            Class[] classArray = new Class[]{};
            sb_toString = sb_class.getMethod("toString", classArray);
            classArray = new Class[]{string_class};
            sb_constructor = sb_class.getConstructor(classArray);
            sb_append_String = sb_class.getMethod("append", classArray);
            classArray[0] = Class.forName("java.lang.Object");
            sb_append_Object = sb_class.getMethod("append", classArray);
            int n = 0;
            while (n < primitiveTypes.length - 1) {
                classArray[0] = primitiveTypes[n == 1 ? 4 : (n == 3 ? 4 : n)];
                ExpressionImage.sb_append_primitive[n] = sb_class.getMethod("append", classArray);
                ++n;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {}
        returns = new byte[]{-84, -84, -84, -84, -84, -83, -82, -81};
        cvt_wide = new byte[]{-128, 64, 96, 80, 120, 92, 94, 95};
        int[][] nArrayArray = new int[8][];
        int[] nArray = new int[8];
        nArray[1] = 255;
        nArray[2] = 255;
        nArray[3] = 255;
        nArray[4] = 255;
        nArray[5] = 255;
        nArray[6] = 255;
        nArray[7] = 255;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 145;
        nArray2[2] = 145;
        nArray2[3] = 145;
        nArray2[4] = 145;
        nArray2[5] = 136;
        nArray2[6] = 139;
        nArray2[7] = 142;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[8];
        nArray3[0] = 146;
        nArray3[1] = 146;
        nArray3[3] = 146;
        nArray3[4] = 146;
        nArray3[5] = 136;
        nArray3[6] = 139;
        nArray3[7] = 142;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[8];
        nArray4[0] = 147;
        nArray4[1] = 147;
        nArray4[2] = 147;
        nArray4[4] = 147;
        nArray4[5] = 136;
        nArray4[6] = 139;
        nArray4[7] = 142;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[8];
        nArray5[5] = 136;
        nArray5[6] = 139;
        nArray5[7] = 142;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[8];
        nArray6[0] = 133;
        nArray6[1] = 133;
        nArray6[2] = 133;
        nArray6[3] = 133;
        nArray6[4] = 133;
        nArray6[6] = 140;
        nArray6[7] = 143;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[8];
        nArray7[0] = 134;
        nArray7[1] = 134;
        nArray7[2] = 134;
        nArray7[3] = 134;
        nArray7[4] = 134;
        nArray7[5] = 137;
        nArray7[7] = 144;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[8];
        nArray8[0] = 135;
        nArray8[1] = 135;
        nArray8[2] = 135;
        nArray8[3] = 135;
        nArray8[4] = 135;
        nArray8[5] = 138;
        nArray8[6] = 141;
        nArrayArray[7] = nArray8;
        cvt1 = nArrayArray;
        int[][] nArrayArray2 = new int[8][];
        nArrayArray2[0] = new int[8];
        int[] nArray9 = new int[8];
        nArray9[5] = 145;
        nArray9[6] = 145;
        nArray9[7] = 145;
        nArrayArray2[1] = nArray9;
        int[] nArray10 = new int[8];
        nArray10[5] = 146;
        nArray10[6] = 146;
        nArray10[7] = 146;
        nArrayArray2[2] = nArray10;
        int[] nArray11 = new int[8];
        nArray11[5] = 147;
        nArray11[6] = 147;
        nArray11[7] = 147;
        nArrayArray2[3] = nArray11;
        nArrayArray2[4] = new int[8];
        nArrayArray2[5] = new int[8];
        nArrayArray2[6] = new int[8];
        nArrayArray2[7] = new int[8];
        cvt2 = nArrayArray2;
        stkoccup = new byte[]{1, 1, 1, 1, 1, 2, 1, 2};
        load_ints = new int[]{2, 3, 4, 5, 6, 7, 8};
        load_long_ints1 = new int[]{2, 9, 10, 5, 6, 7, 8};
        int[] nArray12 = new int[7];
        nArray12[0] = 133;
        nArray12[3] = 133;
        nArray12[4] = 133;
        nArray12[5] = 133;
        nArray12[6] = 133;
        load_long_ints2 = nArray12;
        int[][] nArrayArray3 = new int[8][];
        int[] nArray13 = new int[8];
        nArray13[1] = 255;
        nArray13[2] = 255;
        nArray13[3] = 255;
        nArray13[4] = 255;
        nArray13[5] = 255;
        nArray13[6] = 255;
        nArray13[7] = 255;
        nArrayArray3[0] = nArray13;
        nArrayArray3[1] = new int[]{255, 4, 4, 4, 4, 5, 6, 7};
        nArrayArray3[2] = new int[]{255, 4, 4, 4, 4, 5, 6, 7};
        nArrayArray3[3] = new int[]{255, 4, 4, 4, 4, 5, 6, 7};
        nArrayArray3[4] = new int[]{255, 4, 4, 4, 4, 5, 6, 7};
        nArrayArray3[5] = new int[]{255, 5, 5, 5, 5, 5, 6, 7};
        nArrayArray3[6] = new int[]{255, 6, 6, 6, 6, 6, 6, 7};
        nArrayArray3[7] = new int[]{255, 7, 7, 7, 7, 7, 7, 7};
        binary_promotions = nArrayArray3;
        unary_promotions = new int[]{255, 4, 4, 4, 4, 5, 6, 7};
        int[][][] nArrayArray4 = new int[1][][];
        int[][] nArrayArray5 = new int[17][];
        nArrayArray5[0] = new int[]{255, 96, 255, 96, 96, 97, 98, 99};
        nArrayArray5[1] = new int[]{255, 100, 255, 100, 100, 101, 102, 103};
        nArrayArray5[2] = new int[]{255, 104, 255, 104, 104, 105, 106, 107};
        nArrayArray5[3] = new int[]{255, 108, 255, 108, 108, 109, 110, 111};
        nArrayArray5[4] = new int[]{255, 112, 255, 112, 112, 113, 114, 115};
        nArrayArray5[5] = new int[]{126, 126, 255, 126, 126, 127, 255, 255};
        nArrayArray5[6] = new int[]{128, 128, 255, 128, 128, 129, 255, 255};
        nArrayArray5[7] = new int[]{130, 130, 255, 130, 130, 131, 255, 255};
        int[] nArray14 = new int[8];
        nArray14[5] = 148;
        nArray14[6] = 150;
        nArray14[7] = 152;
        nArrayArray5[8] = nArray14;
        int[] nArray15 = new int[8];
        nArray15[5] = 148;
        nArray15[6] = 150;
        nArray15[7] = 152;
        nArrayArray5[9] = nArray15;
        int[] nArray16 = new int[8];
        nArray16[5] = 148;
        nArray16[6] = 150;
        nArray16[7] = 152;
        nArrayArray5[10] = nArray16;
        int[] nArray17 = new int[8];
        nArray17[5] = 148;
        nArray17[6] = 149;
        nArray17[7] = 151;
        nArrayArray5[11] = nArray17;
        int[] nArray18 = new int[8];
        nArray18[5] = 148;
        nArray18[6] = 149;
        nArray18[7] = 151;
        nArrayArray5[12] = nArray18;
        int[] nArray19 = new int[8];
        nArray19[5] = 148;
        nArray19[6] = 150;
        nArray19[7] = 152;
        nArrayArray5[13] = nArray19;
        nArrayArray5[14] = new int[]{120, 120, 120, 120, 120, 121, 255, 255};
        nArrayArray5[15] = new int[]{122, 122, 122, 122, 122, 123, 255, 255};
        nArrayArray5[16] = new int[]{124, 124, 124, 124, 124, 125, 255, 255};
        nArrayArray4[0] = nArrayArray5;
        ops = nArrayArray4;
        boolean[] blArray = new boolean[17];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[8] = true;
        blArray[9] = true;
        blArray[10] = true;
        blArray[11] = true;
        blArray[12] = true;
        blArray[13] = true;
        is_promotion_binary = blArray;
        openjumps = new int[][]{new int[8], new int[8], new int[8], new int[8], new int[8], new int[8], new int[8], new int[8], {159, 159, 159, 159, 159, 153, 153, 153}, {160, 160, 160, 160, 160, 154, 154, 154}, {161, 161, 161, 161, 161, 155, 155, 155}, {162, 162, 162, 162, 162, 156, 156, 156}, {163, 163, 163, 163, 163, 157, 157, 157}, {164, 164, 164, 164, 164, 158, 158, 158}, new int[8], new int[8], new int[8]};
        int[] nArray20 = new int[8];
        nArray20[1] = 145;
        nArray20[2] = 146;
        nArray20[3] = 147;
        norm = nArray20;
        int[][][] nArrayArray6 = new int[3][][];
        nArrayArray6[0] = new int[][]{{116, 116, 255, 116, 116, 117, 118, 119}, {255, 2, 2, 2, 2, 2, 255, 255}};
        int[][] nArrayArray7 = new int[2][];
        nArrayArray7[0] = new int[8];
        int[] nArray21 = new int[8];
        nArray21[1] = 130;
        nArray21[2] = 130;
        nArray21[3] = 130;
        nArray21[4] = 130;
        nArray21[5] = 133;
        nArrayArray7[1] = nArray21;
        nArrayArray6[1] = nArrayArray7;
        int[][] nArrayArray8 = new int[2][];
        nArrayArray8[0] = new int[8];
        int[] nArray22 = new int[8];
        nArray22[5] = 131;
        nArrayArray8[1] = nArray22;
        nArrayArray6[2] = nArrayArray8;
        una = nArrayArray6;
        int[][] nArrayArray9 = new int[2][];
        nArrayArray9[0] = new int[8];
        int[] nArray23 = new int[8];
        nArray23[1] = 1;
        nArray23[2] = 1;
        nArray23[3] = 1;
        nArray23[4] = 1;
        nArray23[5] = 2;
        nArrayArray9[1] = nArray23;
        una_excess_stack = nArrayArray9;
        stor = new byte[]{54, 54, 54, 54, 54, 55, 56, 57, 58};
        load = new byte[]{21, 21, 21, 21, 21, 22, 23, 24, 25};
        sladdr = new byte[]{4, 4, 4, 4, 4, 5, 7, 8, 10};
    }

    public ExpressionImage() {
        this.constPool = new ByteArrayOutputStream();
        this.constPoolData = new DataOutputStream(this.constPool);
        this.methodText = new PatchableByteArrayOutputStream();
        this.methodTextData = new DataOutputStream(this.methodText);
        ++this.poolEntries;
        try {
            this.constPoolData.write(cp_middle);
            this.poolEntries += 18;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void appendParametersSignature(StringBuffer stringBuffer, Class[] classArray) {
        stringBuffer.append('(');
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(ExpressionImage.getSignature(classArray[n]));
            ++n;
        }
        stringBuffer.append(')');
    }

    public void asm_binary(int n) {
        this.ensure_value();
        Class clazz = (Class)this.typesStk.peek();
        Object e = this.typesStk.pop();
        Class clazz2 = (Class)this.typesStk.peek();
        this.typesStk.push(e);
        if (n == 0 && clazz2 == tsb_class) {
            this.codeOP(182);
            if (clazz.isPrimitive()) {
                this.codeINDEX(this.getMethodIndex(sb_append_primitive[ExpressionImage.primitiveID(clazz)]));
            } else if (clazz == string_class) {
                this.codeINDEX(this.getMethodIndex(sb_append_String));
            } else {
                this.codeINDEX(this.getMethodIndex(sb_append_Object));
            }
            this.typesStk.pop();
            this.currSSW -= ExpressionImage.stackSpace(clazz);
            return;
        }
        if (!clazz2.isPrimitive() || !clazz.isPrimitive()) {
            return;
        }
        int n2 = ExpressionImage.primitiveID(clazz2);
        int n3 = ExpressionImage.primitiveID(clazz);
        int n4 = n2;
        if (is_promotion_binary[n] && n2 != n3) {
            return;
        }
        if (!is_promotion_binary[n]) {
            n4 = unary_promotions[n2];
            this.asm_convert(Integer.TYPE);
            clazz = (Class)this.typesStk.peek();
            n3 = ExpressionImage.primitiveID(clazz);
        }
        if (ops[0][n][n4] == 255) {
            return;
        }
        this.typesStk.pop();
        this.currSSW -= stkoccup[n3];
        this.typesStk.pop();
        this.currSSW -= stkoccup[n2];
        int n5 = 0;
        while (n5 < ops.length) {
            int n6 = ops[n5][n][n4];
            if (n6 > 0) {
                this.codeOP(n6);
            }
            ++n5;
        }
        this.jump_progress = openjumps[n][n4];
        if (this.jump_progress == 0) {
            this.typesStk.push(primitiveTypes[n4]);
            this.currSSW += stkoccup[n4];
        }
    }

    public void asm_binary_param(int n) {
        this.ensure_value();
        if (n == 0 && this.typesStk.peek() == string_class) {
            this.codeOP(187);
            this.codeINDEX(this.getClassIndex(sb_class));
            this.codeOP(90);
            this.codeOP(90);
            this.codeOP(87);
            this.codeOP(183);
            this.codeINDEX(this.getMethodIndex(sb_constructor));
            this.typesStk.pop();
            this.typesStk.push(tsb_class);
            this.currSSW += 3;
            this.ensureStack();
            this.currSSW -= 3;
        }
    }

    public void asm_branch_end() {
        this.ensure_value();
        this.landLabel(this.jumps);
    }

    public void asm_branch_start_false() {
        this.ensure_value();
        this.unblockLabels(this.jumps0, this.blocks0);
        int n = this.branchStack.pop();
        while (n < this.typesStk.size()) {
            this.currSSW -= ExpressionImage.stackSpace((Class)this.typesStk.pop());
        }
        this.codeOP(167);
        this.mkLabel(this.jumps);
        this.landLabels(this.jumps0, this.blocks0);
    }

    public void asm_branch_start_true() {
        this.ensure_jump();
        if (!this.invert_next_jump) {
            this.jump_progress = ExpressionImage.invert_jump_bytecode(this.jump_progress);
        }
        this.invert_next_jump = false;
        this.codeOP(this.jump_progress);
        this.jump_progress = 0;
        this.mkLabel(this.jumps0);
        this.landLabels(this.jumps1, this.blocks1);
        this.blockLabels(this.jumps0, this.blocks0);
        this.branchStack.push(this.typesStk.size());
    }

    public boolean asm_convert(Class clazz) {
        Class clazz2 = (Class)this.typesStk.peek();
        if (clazz == clazz2) {
            return true;
        }
        boolean bl = clazz2.isPrimitive();
        boolean bl2 = clazz.isPrimitive();
        if (bl && bl2) {
            int n = ExpressionImage.primitiveID(clazz2);
            int n2 = ExpressionImage.primitiveID(clazz);
            int n3 = cvt1[n2][n];
            int n4 = cvt2[n2][n];
            if (n3 == 255) {
                return false;
            }
            this.currSSW = this.currSSW + stkoccup[n2] - stkoccup[n];
            this.ensureStack();
            if (n3 != 0) {
                this.codeOP(n3);
            }
            if (n4 != 0) {
                this.codeOP(n4);
            }
            this.typesStk.pop();
            this.typesStk.push(clazz);
            return true;
        }
        if (bl ^ bl2) {
            return false;
        }
        this.typesStk.pop();
        this.typesStk.push(clazz);
        return true;
    }

    public void asm_func_call() {
        this.asm_logical_unblock();
        Class[] classArray = (Class[])this.functionParams.pop();
        int[] nArray = (int[])this.functionINTS.pop();
        Class clazz = (Class)this.functionRet.pop();
        int n = nArray[3];
        if (n != nArray[2]) {
            return;
        }
        boolean bl = nArray[1] == 1;
        int n2 = bl ? 0 : 1;
        this.checkAlter();
        if (bl) {
            this.codeOP(184);
        } else {
            this.codeOP(182);
        }
        this.codeINDEX(nArray[0]);
        int n3 = 0;
        while (n3 < classArray.length) {
            n2 += ExpressionImage.stackSpace(classArray[n3]);
            this.typesStk.pop();
            ++n3;
        }
        this.currSSW -= n2;
        this.typesStk.push(clazz);
        this.currSSW += ExpressionImage.stackSpace(clazz);
        this.ensureStack();
    }

    public void asm_func_param() {
        this.ensure_value();
        this.asm_logical_unblock();
        this.normalize_tsb();
        Class[] classArray = (Class[])this.functionParams.peek();
        int[] nArray = (int[])this.functionINTS.peek();
        int n = nArray[3];
        boolean bl = this.asm_convert(classArray[n]);
        if (!bl) {
            return;
        }
        nArray[4] = this.currSSW;
        nArray[3] = nArray[3] + 1;
        this.asm_logical_block();
    }

    public void asm_func_start(Method method, int n) {
        Class<?>[] classArray = method.getParameterTypes();
        this.functionParams.push(classArray);
        boolean bl = Modifier.isStatic(method.getModifiers());
        int[] nArray = new int[5];
        nArray[0] = this.getMethodIndex(method);
        nArray[1] = bl ? 1 : 0;
        nArray[2] = classArray.length;
        nArray[4] = this.currSSW;
        int[] nArray2 = nArray;
        this.functionINTS.push(nArray2);
        this.functionRet.push(method.getReturnType());
        if (!bl) {
            int n2;
            this.checkAlter();
            this.currSSW += 2;
            this.ensureStack();
            this.codeOP(43);
            if (n < 255) {
                this.codeOP(16);
                this.codeOP(n);
            } else {
                n2 = this.getIntIndex(new Integer(n));
                this.codeOP(19);
                this.codeINDEX(n2);
            }
            this.codeOP(50);
            n2 = this.getClassIndex(method.getDeclaringClass());
            this.codeOP(192);
            this.codeINDEX(n2);
            nArray2[4] = --this.currSSW;
        }
        this.asm_logical_block();
    }

    public void asm_load_object(Object object) {
        if (object == null) {
            this.typesStk.push(null);
            this.codeOP(1);
            ++this.currSSW;
            this.ensureStack();
        } else if (object instanceof String) {
            this.typesStk.push(string_class);
            int n = this.getStringIndex((String)object);
            if (n < 255) {
                this.codeOP(18);
                this.codeOP(n);
            } else {
                this.codeOP(19);
                this.codeINDEX(n);
            }
            ++this.currSSW;
            this.ensureStack();
        } else {
            int n;
            int n2 = this.objectPool.indexOf(object);
            if (n2 == -1) {
                this.objectPool.addElement(object);
                n2 = this.objectPool.size() - 1;
            }
            this.typesStk.push(object.getClass());
            this.currSSW += 2;
            this.ensureStack();
            this.codeOP(42);
            this.codeOP(180);
            this.codeINDEX(15);
            if (n2 < 255) {
                this.codeOP(16);
                this.codeOP(n2);
            } else {
                n = this.getIntIndex(new Integer(n2));
                this.codeOP(19);
                this.codeINDEX(n);
            }
            this.codeOP(50);
            n = this.getClassIndex(object.getClass());
            this.codeOP(192);
            this.codeINDEX(n);
            --this.currSSW;
        }
    }

    public void asm_load_primitive(Object object) {
        this.checkAlter();
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        if (object instanceof Double) {
            Double d = (Double)object;
            double d2 = d;
            if (d2 == 0.0) {
                n = 14;
            } else if (d2 == 1.0) {
                n = 15;
            } else {
                n3 = this.getDoubleIndex(d);
            }
            n4 = 7;
        } else if (object instanceof Long) {
            Long l = (Long)object;
            long l2 = l;
            if (l2 >= -1L && l2 <= 5L) {
                n = load_long_ints1[(int)l2 + 1];
                n2 = load_long_ints2[(int)l2 + 1];
            } else {
                n3 = this.getLongIndex(l);
            }
            n4 = 5;
        } else if (object instanceof Float) {
            Float f = (Float)object;
            float f2 = f.floatValue();
            if ((double)f2 == 0.0) {
                n = 11;
            } else if ((double)f2 == 1.0) {
                n = 12;
            } else if ((double)f2 == 2.0) {
                n = 13;
            }
            n3 = this.getFloatIndex(f);
            n4 = 6;
        } else if (object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Character) {
            n4 = 4;
            if (object instanceof Short) {
                n4 = 3;
            } else if (object instanceof Character) {
                n4 = 2;
            } else if (object instanceof Byte) {
                n4 = 1;
            }
            int n5 = n4 != 2 ? ((Number)object).intValue() : (int)((Character)object).charValue();
            if (n5 >= -1 && n5 <= 5) {
                n = load_ints[n5 + 1];
            } else {
                n3 = n4 == 4 ? this.getIntIndex((Integer)object) : this.getIntIndex(new Integer(n5));
            }
        } else if (object instanceof Boolean) {
            n4 = 0;
            n = (Boolean)object != false ? 4 : 3;
        }
        byte by = stkoccup[n4];
        if (n == 0) {
            int n6 = 19;
            if (by == 2) {
                n6 = 20;
            }
            if (n6 == 19 && n3 < 255) {
                this.codeOP(n6 - 1);
                this.codeOP(n3);
            } else {
                this.codeOP(n6);
                this.codeINDEX(n3);
            }
        } else {
            this.codeOP(n);
            if (n2 != 0) {
                this.codeOP(n2);
            }
        }
        this.currSSW += by;
        this.ensureStack();
        this.typesStk.push(primitiveTypes[n4]);
    }

    public void asm_logical_binary(int n) {
        switch (n) {
            case 0: {
                this.asm_logical_binary_and();
                break;
            }
            case 1: {
                this.asm_logical_binary_or();
                break;
            }
        }
    }

    private final void asm_logical_binary_and() {
        this.unblockLabels(this.jumps0, this.blocks0);
    }

    private final void asm_logical_binary_or() {
        this.unblockLabels(this.jumps1, this.blocks1);
    }

    public void asm_logical_binary_param(int n) {
        switch (n) {
            case 0: {
                this.asm_logical_binary_param_and();
                break;
            }
            case 1: {
                this.asm_logical_binary_param_or();
                break;
            }
        }
    }

    private final void asm_logical_binary_param_and() {
        this.logical_param(true, this.jumps0, this.jumps1, this.blocks0, this.blocks1);
    }

    private final void asm_logical_binary_param_or() {
        this.logical_param(false, this.jumps1, this.jumps0, this.blocks1, this.blocks0);
    }

    public void asm_logical_block() {
        this.blockLabels(this.jumps0, this.blocks0);
        this.blockLabels(this.jumps1, this.blocks1);
    }

    private void asm_logical_unblock() {
        this.unblockLabels(this.jumps0, this.blocks0);
        this.unblockLabels(this.jumps1, this.blocks1);
    }

    public void asm_logical_unblock_not() {
        this.ensure_jump();
        IntegerStack.swap(this.jumps1, this.blocks1.pop(), this.jumps0, this.blocks0.pop());
        this.invert_next_jump ^= true;
    }

    public void asm_return() {
        this.checkAlter();
        this.ensure_value();
        this.normalize_tsb();
        Class clazz = null;
        boolean bl = false;
        try {
            clazz = (Class)this.typesStk.peek();
        }
        catch (EmptyStackException emptyStackException) {
            this.asm_load_object(null);
            bl = true;
        }
        int n = primitiveTypes.length;
        int n2 = -80;
        if (!bl) {
            ++n;
            if (clazz != null && clazz.isPrimitive()) {
                n = ExpressionImage.primitiveID(clazz);
                n2 = returns[n];
            }
        }
        StringBuffer stringBuffer = new StringBuffer("evaluate");
        StringBuffer stringBuffer2 = new StringBuffer("([Ljava/lang/Object;)");
        if (n < primitiveTypes.length) {
            stringBuffer.append('_');
            stringBuffer.append(primitiveTypeNames[n]);
            stringBuffer2.append(primitiveCodes[n]);
        } else {
            stringBuffer2.append("Ljava/lang/Object;");
        }
        this.nameIdx = (short)this.getUTFIndex(stringBuffer.toString());
        this.signIdx = (short)this.getUTFIndex(stringBuffer2.toString());
        this.thetype = (byte)n;
        this.typesStk.pop();
        this.codeOP(n2);
        this.classFinished = true;
    }

    public void asm_throw_return() {
        this.checkAlter();
        Class clazz = null;
        try {
            clazz = (Class)this.typesStk.pop();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        this.codeOP(191);
        this.classFinished = true;
    }

    public void asm_unary(int n) {
        int n2;
        this.ensure_value();
        Class clazz = (Class)this.typesStk.peek();
        if (!clazz.isPrimitive()) {
            return;
        }
        int n3 = ExpressionImage.primitiveID(clazz);
        if (una[0][n][n3] == 255) {
            return;
        }
        int n4 = 0;
        while (n4 < una.length) {
            n2 = una[n4][n][n3];
            if (n2 > 0) {
                this.codeOP(n2);
            }
            ++n4;
        }
        n2 = una_excess_stack[n][n3];
        this.currSSW += n2;
        this.ensureStack();
        this.currSSW -= n2;
        this.typesStk.pop();
        this.typesStk.push(primitiveTypes[unary_promotions[n3]]);
    }

    private final void blockLabels(IntegerStack integerStack, IntegerStack integerStack2) {
        integerStack2.push(integerStack.size());
    }

    public static boolean canConvert(Class clazz, Class clazz2) {
        boolean bl = clazz.isPrimitive();
        boolean bl2 = clazz2.isPrimitive();
        if (bl2 && bl) {
            int n = ExpressionImage.primitiveID(clazz);
            int n2 = ExpressionImage.primitiveID(clazz2);
            return cvt1[n2][n] != 255;
        }
        if (bl2 ^ bl) {
            return false;
        }
        return clazz2.isAssignableFrom(clazz);
    }

    public static boolean canConvertByWidening(Class clazz, Class clazz2) {
        boolean bl = clazz.isPrimitive();
        boolean bl2 = clazz2.isPrimitive();
        if (bl2 && bl) {
            int n = ExpressionImage.primitiveID(clazz);
            int n2 = ExpressionImage.primitiveID(clazz2);
            return (cvt_wide[n2] & 128 >> n) > 0;
        }
        if (bl2 ^ bl) {
            return false;
        }
        return clazz2.isAssignableFrom(clazz);
    }

    public static boolean canGenerateBinary(int n, Class clazz, Class clazz2) {
        if (n == 0 && (clazz == string_class || clazz == tsb_class)) {
            return true;
        }
        if (!clazz.isPrimitive() || !clazz2.isPrimitive()) {
            return false;
        }
        int n2 = ExpressionImage.primitiveID(clazz);
        int n3 = ExpressionImage.primitiveID(clazz2);
        if (is_promotion_binary[n]) {
            int n4 = binary_promotions[n2][n3];
            if (n4 == 255) {
                return false;
            }
            return ops[0][n][n4] != 255;
        }
        return n2 >= 1 && n2 <= 5 && n3 >= 1 && n3 <= 5;
    }

    public static boolean canGenerateUnary(int n, Class clazz) {
        if (!clazz.isPrimitive()) {
            return false;
        }
        return una[0][n][ExpressionImage.primitiveID(clazz)] != 255;
    }

    private final void checkAlter() {
    }

    private final void codeINDEX(int n) {
        try {
            this.methodTextData.writeShort(n);
        }
        catch (IOException iOException) {}
    }

    private final void codeOP(int n) {
        try {
            this.methodTextData.write(n);
        }
        catch (IOException iOException) {}
    }

    static void dumpImage(ExpressionImage expressionImage) {
    }

    private final void ensureStack() {
        if (this.currSSW > this.max_stack) {
            this.max_stack = this.currSSW;
        }
    }

    private final void ensure_jump() {
        if (this.jump_progress != 0) {
            return;
        }
        Class clazz = (Class)this.typesStk.pop();
        this.currSSW -= stkoccup[0];
        this.jump_progress = 157;
    }

    private final void ensure_value() {
        if (this.jump_progress == 0 && this.noPendingJumps()) {
            return;
        }
        this.asm_branch_start_true();
        this.asm_load_primitive(Boolean.TRUE);
        this.asm_branch_start_false();
        this.asm_load_primitive(Boolean.FALSE);
        this.asm_branch_end();
    }

    public static Class getBinaryPromoted(Class clazz, Class clazz2) {
        int n;
        int n2 = ExpressionImage.primitiveID(clazz);
        int n3 = binary_promotions[n2][n = ExpressionImage.primitiveID(clazz2)];
        if (n3 == 255) {
            return null;
        }
        return primitiveTypes[n3];
    }

    public ExpressionBits getBits() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.write(prologue);
            dataOutputStream.writeShort(this.poolEntries);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            this.constPool.writeTo(dataOutputStream);
            dataOutputStream.write(intermezzo1);
            dataOutputStream.write(this.thetype);
            dataOutputStream.write(intermezzo2);
            dataOutputStream.writeShort(this.nameIdx);
            dataOutputStream.writeShort(this.signIdx);
            dataOutputStream.write(intermezzo3);
            int n = this.methodText.size();
            dataOutputStream.writeInt(n + 12);
            dataOutputStream.writeShort(this.max_stack);
            dataOutputStream.writeShort(this.max_locals);
            dataOutputStream.writeInt(n);
            this.methodText.writeTo(dataOutputStream);
            dataOutputStream.write(konetc);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            Object[] objectArray = new Object[this.objectPool.size()];
            this.objectPool.copyInto(objectArray);
            return new ExpressionBits(byArray, byArray2, objectArray);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private int getClassIndex(Class clazz) {
        Integer n = (Integer)this.Items.get(clazz);
        if (n == null) {
            String string = clazz.getName();
            String string2 = ExpressionImage.toHistoricalForm(string);
            int n2 = this.getUTFIndex(string2);
            n = new Integer(this.poolEntries++);
            this.writeClassInfo(n2);
            this.Items.put(clazz, n);
        }
        return n;
    }

    private int getDoubleIndex(Double d) {
        Integer n = (Integer)this.Items.get(d);
        if (n == null) {
            n = new Integer(this.poolEntries++);
            try {
                this.checkAlter();
                this.constPoolData.write(6);
                this.constPoolData.writeDouble(d);
                ++this.poolEntries;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.Items.put(d, n);
        }
        return n;
    }

    public CompiledExpression getExpression() {
        return this.getBits().getExpression();
    }

    private int getFloatIndex(Float f) {
        Integer n = (Integer)this.Items.get(f);
        if (n == null) {
            n = new Integer(this.poolEntries++);
            try {
                this.checkAlter();
                this.constPoolData.write(4);
                this.constPoolData.writeFloat(f.floatValue());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.Items.put(f, n);
        }
        return n;
    }

    public byte[] getImage() {
        return this.getBits().getImage();
    }

    private int getIntIndex(Integer n) {
        Integer n2 = (Integer)this.Items.get(n);
        if (n2 == null) {
            n2 = new Integer(this.poolEntries++);
            try {
                this.checkAlter();
                this.constPoolData.write(3);
                this.constPoolData.writeInt(n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.Items.put(n, n2);
        }
        return n2;
    }

    private int getLongIndex(Long l) {
        Integer n = (Integer)this.Items.get(l);
        if (n == null) {
            n = new Integer(this.poolEntries++);
            try {
                this.checkAlter();
                this.constPoolData.write(5);
                this.constPoolData.writeLong(l);
                ++this.poolEntries;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.Items.put(l, n);
        }
        return n;
    }

    private int getMethodIndex(Constructor constructor) {
        Integer n = (Integer)this.Items.get(constructor);
        if (n == null) {
            n = new Integer(this.writeMethodRef("<init>", ExpressionImage.getSignature(constructor), constructor.getDeclaringClass()));
            this.Items.put(constructor, n);
        }
        return n;
    }

    private int getMethodIndex(Method method) {
        Integer n = (Integer)this.Items.get(method);
        if (n == null) {
            n = new Integer(this.writeMethodRef(method.getName(), ExpressionImage.getSignature(method), method.getDeclaringClass()));
            this.Items.put(method, n);
        }
        return n;
    }

    public static String getSignature(Class clazz) {
        if (clazz.isPrimitive()) {
            return String.valueOf(primitiveCodes[ExpressionImage.primitiveID(clazz)]);
        }
        if (clazz.isArray()) {
            return String.valueOf('[') + ExpressionImage.getSignature(clazz.getComponentType());
        }
        return String.valueOf('L') + ExpressionImage.toHistoricalForm(clazz.getName()) + ';';
    }

    public static String getSignature(Constructor constructor) {
        StringBuffer stringBuffer = new StringBuffer();
        ExpressionImage.appendParametersSignature(stringBuffer, constructor.getParameterTypes());
        stringBuffer.append('V');
        return stringBuffer.toString();
    }

    public static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        ExpressionImage.appendParametersSignature(stringBuffer, method.getParameterTypes());
        stringBuffer.append(ExpressionImage.getSignature(method.getReturnType()));
        return stringBuffer.toString();
    }

    private int getStringIndex(String string) {
        Integer n = (Integer)this.Items.get(string);
        if (n == null) {
            int n2 = this.getUTFIndex(string);
            n = new Integer(this.poolEntries++);
            try {
                this.checkAlter();
                this.constPoolData.write(8);
                this.constPoolData.writeShort(n2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.Items.put(string, n);
        }
        return n;
    }

    private int getUTFIndex(String string) {
        Integer n = (Integer)this.UTFs.get(string);
        if (n == null) {
            n = new Integer(this.poolEntries++);
            try {
                this.checkAlter();
                this.constPoolData.write(1);
                this.constPoolData.writeUTF(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.UTFs.put(string, n);
        }
        return n;
    }

    static int getUnaryPromoted(int n) {
        return unary_promotions[n];
    }

    public static Class getUnaryPromoted(Class clazz) {
        int n = unary_promotions[ExpressionImage.primitiveID(clazz)];
        if (n == 255) {
            return null;
        }
        return primitiveTypes[n];
    }

    private static final byte invert_jump_bytecode(int n) {
        return (byte)((n - 1 ^ 1) + 1);
    }

    public static final boolean isPromotionBinary(int n) {
        return is_promotion_binary[n];
    }

    private final void landLabel(IntegerStack integerStack) {
        int n = this.methodText.size();
        int n2 = integerStack.pop();
        this.methodText.patchAddress(n2, n - n2 + 1);
    }

    private final void landLabels(IntegerStack integerStack, IntegerStack integerStack2) {
        int n = 0;
        if (integerStack2.size() > 0) {
            n = integerStack2.peek();
        }
        while (integerStack.size() > n) {
            this.landLabel(integerStack);
        }
    }

    private void logical_param(boolean bl, IntegerStack integerStack, IntegerStack integerStack2, IntegerStack integerStack3, IntegerStack integerStack4) {
        this.ensure_jump();
        if (this.invert_next_jump ^ bl) {
            this.jump_progress = ExpressionImage.invert_jump_bytecode(this.jump_progress);
        }
        this.invert_next_jump = false;
        this.codeOP(this.jump_progress);
        this.jump_progress = 0;
        this.mkLabel(integerStack);
        this.landLabels(integerStack2, integerStack4);
        this.blockLabels(integerStack, integerStack3);
    }

    public static void main(String[] stringArray) {
        Tester tester = new Tester(System.out);
        ExpressionImage.test(tester);
        tester.summarize();
    }

    private final void mkLabel(IntegerStack integerStack) {
        int n = this.methodText.size();
        integerStack.push(n);
        try {
            this.methodTextData.writeShort(0);
        }
        catch (IOException iOException) {}
    }

    private final boolean noPendingJumps() {
        int n = 0;
        if (this.blocks0.size() > 0) {
            n = this.blocks0.peek();
        }
        int n2 = 0;
        if (this.blocks1.size() > 0) {
            n2 = this.blocks1.peek();
        }
        return this.jumps0.size() == n && this.jumps1.size() == n2;
    }

    private void normalize_tsb() {
        Class clazz = (Class)this.typesStk.peek();
        if (clazz != tsb_class) {
            return;
        }
        this.codeOP(182);
        this.codeINDEX(this.getMethodIndex(sb_toString));
        this.typesStk.pop();
        this.typesStk.push(string_class);
    }

    static final int primitiveID(Class clazz) {
        int n = 0;
        while (n < primitiveTypes.length && primitiveTypes[n] != clazz) {
            ++n;
        }
        return n;
    }

    private static final int stackSpace(Class clazz) {
        if (clazz.isPrimitive()) {
            return stkoccup[ExpressionImage.primitiveID(clazz)];
        }
        return 1;
    }

    public static void test(Tester tester) {
    }

    private static void testComparizons(Object object, Object object2, String string, Tester tester) {
    }

    private static String toHistoricalForm(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string.length();
        int n2 = string.indexOf(46);
        while (n2 > 0 && n2 < n) {
            stringBuffer.setCharAt(n2, '/');
            n2 = string.indexOf(46, n2 + 1);
        }
        return stringBuffer.toString();
    }

    private static boolean transmitPrimitive(Object object, Object object2) throws Throwable {
        return true;
    }

    private final void unblockLabels(IntegerStack integerStack, IntegerStack integerStack2) {
        integerStack2.pop_throw();
    }

    private void writeClassInfo(int n) {
        try {
            this.checkAlter();
            this.constPoolData.write(7);
            this.constPoolData.writeShort(n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int writeMethodRef(String string, String string2, Class clazz) {
        int n = this.getUTFIndex(string);
        int n2 = this.getUTFIndex(string2);
        int n3 = this.getClassIndex(clazz);
        int n4 = this.poolEntries++;
        try {
            this.checkAlter();
            this.constPoolData.write(12);
            this.constPoolData.writeShort(n);
            this.constPoolData.writeShort(n2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int n5 = this.poolEntries++;
        int n6 = 10;
        if (clazz.isInterface()) {
            n6 = 11;
        }
        try {
            this.checkAlter();
            this.constPoolData.write(n6);
            this.constPoolData.writeShort(n3);
            this.constPoolData.writeShort(n4);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n5;
    }
}

