/* Any copyright is dedicated to the Public Domain.
   http://creativecommons.org/publicdomain/zero/1.0/ */

subscriptLoader.loadSubScript("resource://gre/modules/ril_consts.js", this);

function run_test() {
  run_next_test();
}

/**
 * Verify IconLoader.loadIcons with recordNumbers array length being 1.
 * Query images of one record at a time.
 */
add_test(function test_load_icon_basic() {
  let worker = newUint8Worker();
  let context = worker.ContextPool._contexts[0];
  let ril = context.RIL;
  let iconLoader = context.IconLoader;
  let simRecordHelper = context.SimRecordHelper;

  let test_data = [
    {rawData: [
       {codingScheme: ICC_IMG_CODING_SCHEME_BASIC,
        width: 0x10,
        height: 0x10,
        body: [0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
               0x00, 0x9d, 0xe9, 0xa1, 0x2d, 0xa1, 0x2d, 0xa1, 0x2b,
               0xa1, 0x2b, 0x9d, 0xe9, 0x00, 0x00, 0xff, 0xff, 0xff,
               0xff, 0x00, 0x00, 0xff, 0xff]}],
     expected: [
       {width: 0x10,
        height: 0x10,
        pixels: [/* 1st byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 2nd byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 3rd byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 4th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 5th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 6th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 7th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 8th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 9th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 10th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 11th byte of body: 0x9d */
                 0xffffffff, 0x000000ff, 0x000000ff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0x000000ff, 0xffffffff,
                 /* 12th byte of body: 0xe9 */
                 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0xffffffff,
                 0x000000ff, 0x000000ff, 0xffffffff,
                 /* 13th byte of body: 0xa1 */
                 0xffffffff, 0x000000ff, 0xffffffff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0xffffffff,
                 /* 14th byte of body: 0x2d */
                 0x000000ff, 0x000000ff, 0xffffffff, 0x000000ff, 0xffffffff,
                 0xffffffff, 0x000000ff, 0xffffffff,
                 /* 15th byte of body: 0xa1 */
                 0xffffffff, 0x000000ff, 0xffffffff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0xffffffff,
                 /* 16th byte of body: 0x2d */
                 0x000000ff, 0x000000ff, 0xffffffff, 0x000000ff, 0xffffffff,
                 0xffffffff, 0x000000ff, 0xffffffff,
                 /* 17th byte of body: 0xa1 */
                 0xffffffff, 0x000000ff, 0xffffffff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0xffffffff,
                 /* 18th byte of body: 0x2b */
                 0x000000ff, 0x000000ff, 0xffffffff, 0x000000ff, 0xffffffff,
                 0x000000ff, 0xffffffff, 0xffffffff,
                 /* 19th byte of body: 0xa1 */
                 0xffffffff, 0x000000ff, 0xffffffff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0xffffffff,
                 /* 20th byte of body: 0x2b */
                 0x000000ff, 0x000000ff, 0xffffffff, 0x000000ff, 0xffffffff,
                 0x000000ff, 0xffffffff, 0xffffffff,
                 /* 21th byte of body: 0x9d */
                 0xffffffff, 0x000000ff, 0x000000ff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0x000000ff, 0xffffffff,
                 /* 22th byte of body: 0xe9 */
                 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0xffffffff,
                 0x000000ff, 0x000000ff, 0xffffffff,
                 /* 23th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 24th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 25th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 26th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 27th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 28th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 29th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 30th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 31th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 32th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff]}]},
    {rawData: [
       {codingScheme: ICC_IMG_CODING_SCHEME_COLOR,
        width: 0x10,
        height: 0x10,
        bitsPerImgPoint: 0x04,
        numOfClutEntries: 0x10,
        body: [0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xff,
               0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0xaa,
               0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
               0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xff, 0xff, 0xff, 0xff,
               0xff, 0xff, 0xff, 0xff, 0xcf, 0xfc, 0xcc, 0xfc, 0xcc,
               0xcf, 0xcf, 0xfc, 0xcf, 0xcf, 0xff, 0xfc, 0xff, 0xcf,
               0xcc, 0xfc, 0xcf, 0xcf, 0xff, 0xfc, 0xff, 0xcf, 0xcc,
               0xfc, 0xcf, 0xcf, 0xff, 0xfc, 0xff, 0xcf, 0xcf, 0xcc,
               0xcf, 0xcf, 0xff, 0xfc, 0xff, 0xcf, 0xcf, 0xcc, 0xcf,
               0xfc, 0xcc, 0xfc, 0xcc, 0xcf, 0xcf, 0xfc, 0xff, 0xff,
               0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0xaa, 0xaa,
               0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
               0xaa, 0xaa, 0xaa, 0xaa, 0xff, 0xff, 0xff, 0xff, 0xff,
               0xff, 0xff, 0xff, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
               0x99, 0x99],
        clut: [0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x00,
               0x80, 0x80, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x80,
               0x00, 0x80, 0x80, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80,
               0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00,
               0x00, 0x00, 0xff, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff,
               0xff, 0xff, 0xff]}],
     expected: [
       {width: 0x10,
        height: 0x10,
        pixels: [0xff0000ff, 0xff0000ff, 0xff0000ff, 0xff0000ff, 0xff0000ff,
                 0xff0000ff, 0xff0000ff, 0xff0000ff, 0xff0000ff, 0xff0000ff,
                 0xff0000ff, 0xff0000ff, 0xff0000ff, 0xff0000ff, 0xff0000ff,
                 0xff0000ff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff,
                 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff,
                 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff,
                 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff,
                 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff,
                 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff,
                 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0x0000ffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0x0000ffff,
                 0x0000ffff, 0xffffffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                 0x0000ffff, 0xffffffff, 0x0000ffff, 0xffffffff, 0xffffffff,
                 0x0000ffff, 0x0000ffff, 0xffffffff, 0x0000ffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0xffffffff,
                 0xffffffff, 0x0000ffff, 0xffffffff, 0x0000ffff, 0x0000ffff,
                 0xffffffff, 0x0000ffff, 0x0000ffff, 0xffffffff, 0x0000ffff,
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff,
                 0xffffffff, 0xffffffff, 0x0000ffff, 0xffffffff, 0x0000ffff,
                 0x0000ffff, 0xffffffff, 0x0000ffff, 0x0000ffff, 0xffffffff,
                 0x0000ffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0x0000ffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0xffffffff,
                 0x0000ffff, 0xffffffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                 0xffffffff, 0x0000ffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0x0000ffff, 0xffffffff, 0xffffffff, 0x0000ffff,
                 0xffffffff, 0x0000ffff, 0xffffffff, 0x0000ffff, 0x0000ffff,
                 0x0000ffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0x0000ffff,
                 0x0000ffff, 0xffffffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                 0x0000ffff, 0xffffffff, 0x0000ffff, 0xffffffff, 0xffffffff,
                 0x0000ffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff,
                 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff,
                 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff,
                 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff,
                 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff,
                 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff,
                 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xff0000ff, 0xff0000ff, 0xff0000ff, 0xff0000ff, 0xff0000ff,
                 0xff0000ff, 0xff0000ff, 0xff0000ff, 0xff0000ff, 0xff0000ff,
                 0xff0000ff, 0xff0000ff, 0xff0000ff, 0xff0000ff, 0xff0000ff,
                 0xff0000ff]}]},
    {rawData: [
       {codingScheme: ICC_IMG_CODING_SCHEME_COLOR,
        width: 0x03,
        height: 0x03,
        bitsPerImgPoint: 0x05,
        numOfClutEntries: 0x20,
        body: [0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88],
        clut: [0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
               0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11,
               0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a,
               0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x20, 0x21, 0x22, 0x23,
               0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c,
               0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35,
               0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e,
               0x3f, 0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
               0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50,
               0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59,
               0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f]},
       {codingScheme: ICC_IMG_CODING_SCHEME_BASIC,
        width: 0x10,
        height: 0x10,
        body: [0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
               0x00, 0x9d, 0xe9, 0xa1, 0x2d, 0xa1, 0x2d, 0xa1, 0x2b,
               0xa1, 0x2b, 0x9d, 0xe9, 0x00, 0x00, 0xff, 0xff, 0xff,
               0xff, 0x00, 0x00, 0xff, 0xff]}],
     expected: [
       {width: 0x03,
        height: 0x03,
        pixels: [0x000102ff, 0x060708ff, 0x0c0d0eff, 0x121314ff, 0x18191aff,
                 0x1e1f20ff, 0x242526ff, 0x2a2b2cff, 0x333435ff]},
       {width: 0x10,
        height: 0x10,
        pixels: [/* 1st byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 2nd byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 3rd byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 4th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 5th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 6th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 7th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 8th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 9th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 10th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 11th byte of body: 0x9d */
                 0xffffffff, 0x000000ff, 0x000000ff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0x000000ff, 0xffffffff,
                 /* 12th byte of body: 0xe9 */
                 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0xffffffff,
                 0x000000ff, 0x000000ff, 0xffffffff,
                 /* 13th byte of body: 0xa1 */
                 0xffffffff, 0x000000ff, 0xffffffff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0xffffffff,
                 /* 14th byte of body: 0x2d */
                 0x000000ff, 0x000000ff, 0xffffffff, 0x000000ff, 0xffffffff,
                 0xffffffff, 0x000000ff, 0xffffffff,
                 /* 15th byte of body: 0xa1 */
                 0xffffffff, 0x000000ff, 0xffffffff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0xffffffff,
                 /* 16th byte of body: 0x2d */
                 0x000000ff, 0x000000ff, 0xffffffff, 0x000000ff, 0xffffffff,
                 0xffffffff, 0x000000ff, 0xffffffff,
                 /* 17th byte of body: 0xa1 */
                 0xffffffff, 0x000000ff, 0xffffffff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0xffffffff,
                 /* 18th byte of body: 0x2b */
                 0x000000ff, 0x000000ff, 0xffffffff, 0x000000ff, 0xffffffff,
                 0x000000ff, 0xffffffff, 0xffffffff,
                 /* 19th byte of body: 0xa1 */
                 0xffffffff, 0x000000ff, 0xffffffff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0xffffffff,
                 /* 20th byte of body: 0x2b */
                 0x000000ff, 0x000000ff, 0xffffffff, 0x000000ff, 0xffffffff,
                 0x000000ff, 0xffffffff, 0xffffffff,
                 /* 21th byte of body: 0x9d */
                 0xffffffff, 0x000000ff, 0x000000ff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0x000000ff, 0xffffffff,
                 /* 22th byte of body: 0xe9 */
                 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0xffffffff,
                 0x000000ff, 0x000000ff, 0xffffffff,
                 /* 23th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 24th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 25th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 26th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 27th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 28th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 29th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 30th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 31th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 32th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff]}]},
    {rawData: [
       {codingScheme: ICC_IMG_CODING_SCHEME_COLOR_TRANSPARENCY,
        width: 0x04,
        height: 0x04,
        bitsPerImgPoint: 0x04,
        numOfClutEntries: 0x10,
        body: [0xff, 0xee, 0xdd, 0xcc, 0xbb, 0xaa, 0x99, 0x88],
        clut: [0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
               0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11,
               0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a,
               0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x20, 0x21, 0x22, 0x23,
               0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c,
               0x2d, 0x2e, 0x2f]}],
     expected: [
       {width: 0x04,
        height: 0x04,
        pixels: [0x00000000, 0x00000000, 0x2a2b2cff, 0x2a2b2cff, 0x272829ff,
                 0x272829ff, 0x242526ff, 0x242526ff, 0x212223ff, 0x212223ff,
                 0x1e1f20ff, 0x1e1f20ff, 0x1b1c1dff, 0x1b1c1dff, 0x18191aff,
                 0x18191aff]}]}];

  function do_test(test_data, expected) {
    simRecordHelper.readIMG = function fakeReadIMG(recordNumber, onsuccess, onerror) {
      onsuccess(test_data);
    };

    let onsuccess = function(icons) {
      // Query one record at a time.
      do_check_eq(icons.length, 1);
      do_check_eq(icons[0].length, expected.length);
      for (let i = 0; i < icons[0].length; i++) {
        // Read the i_th image of the record.
        let icon = icons[0][i];
        let exp = expected[i];
        do_check_eq(icon.width, exp.width);
        do_check_eq(icon.height, exp.height);
        do_check_eq(icon.pixels.length, exp.pixels.length);
        for (let j = 0; j < icon.pixels.length; j++) {
          do_check_eq(icon.pixels[j], exp.pixels[j]);
        }
      }
    };

    iconLoader.loadIcons([0], onsuccess);
  }

  for (let i = 0; i < test_data.length; i++) {
    do_test(test_data[i].rawData, test_data[i].expected);
  }

  run_next_test();
});

/**
 * Verify IconLoader.loadIcons.
 */
add_test(function test_load_icons() {
  let worker = newUint8Worker();
  let context = worker.ContextPool._contexts[0];
  let ril = context.RIL;
  let iconLoader = context.IconLoader;
  let simRecordHelper = context.SimRecordHelper;

  let test_data = {
    rawData: [
      // Record 1.
      [{codingScheme: ICC_IMG_CODING_SCHEME_BASIC,
        width: 0x10,
        height: 0x10,
        body: [0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
               0x00, 0x9d, 0xe9, 0xa1, 0x2d, 0xa1, 0x2d, 0xa1, 0x2b,
               0xa1, 0x2b, 0x9d, 0xe9, 0x00, 0x00, 0xff, 0xff, 0xff,
               0xff, 0x00, 0x00, 0xff, 0xff]}],
      // Record 2.
      [{codingScheme: ICC_IMG_CODING_SCHEME_COLOR,
        width: 0x10,
        height: 0x10,
        bitsPerImgPoint: 0x04,
        numOfClutEntries: 0x10,
        body: [0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xff,
               0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0xaa,
               0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
               0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xff, 0xff, 0xff, 0xff,
               0xff, 0xff, 0xff, 0xff, 0xcf, 0xfc, 0xcc, 0xfc, 0xcc,
               0xcf, 0xcf, 0xfc, 0xcf, 0xcf, 0xff, 0xfc, 0xff, 0xcf,
               0xcc, 0xfc, 0xcf, 0xcf, 0xff, 0xfc, 0xff, 0xcf, 0xcc,
               0xfc, 0xcf, 0xcf, 0xff, 0xfc, 0xff, 0xcf, 0xcf, 0xcc,
               0xcf, 0xcf, 0xff, 0xfc, 0xff, 0xcf, 0xcf, 0xcc, 0xcf,
               0xfc, 0xcc, 0xfc, 0xcc, 0xcf, 0xcf, 0xfc, 0xff, 0xff,
               0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0xaa, 0xaa,
               0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
               0xaa, 0xaa, 0xaa, 0xaa, 0xff, 0xff, 0xff, 0xff, 0xff,
               0xff, 0xff, 0xff, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
               0x99, 0x99],
        clut: [0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x00,
               0x80, 0x80, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x80,
               0x00, 0x80, 0x80, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80,
               0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00,
               0x00, 0x00, 0xff, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff,
               0xff, 0xff, 0xff]}],
      // Record 3.
      [{codingScheme: ICC_IMG_CODING_SCHEME_COLOR,
        width: 0x03,
        height: 0x03,
        bitsPerImgPoint: 0x05,
        numOfClutEntries: 0x20,
        body: [0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88],
        clut: [0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
               0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11,
               0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a,
               0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x20, 0x21, 0x22, 0x23,
               0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c,
               0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35,
               0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e,
               0x3f, 0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
               0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50,
               0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59,
               0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f]},
       {codingScheme: ICC_IMG_CODING_SCHEME_BASIC,
        width: 0x10,
        height: 0x10,
        body: [0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
               0x00, 0x9d, 0xe9, 0xa1, 0x2d, 0xa1, 0x2d, 0xa1, 0x2b,
               0xa1, 0x2b, 0x9d, 0xe9, 0x00, 0x00, 0xff, 0xff, 0xff,
               0xff, 0x00, 0x00, 0xff, 0xff]}],
      // Record 4.
      [{codingScheme: ICC_IMG_CODING_SCHEME_COLOR_TRANSPARENCY,
        width: 0x04,
        height: 0x04,
        bitsPerImgPoint: 0x04,
        numOfClutEntries: 0x10,
        body: [0xff, 0xee, 0xdd, 0xcc, 0xbb, 0xaa, 0x99, 0x88],
        clut: [0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
               0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11,
               0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a,
               0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x20, 0x21, 0x22, 0x23,
               0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c,
               0x2d, 0x2e, 0x2f]}]],
    expected: [
      // Record 1.
      [{width: 0x10,
        height: 0x10,
        pixels: [/* 1st byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 2nd byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 3rd byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 4th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 5th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 6th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 7th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 8th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 9th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 10th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 11th byte of body: 0x9d */
                 0xffffffff, 0x000000ff, 0x000000ff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0x000000ff, 0xffffffff,
                 /* 12th byte of body: 0xe9 */
                 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0xffffffff,
                 0x000000ff, 0x000000ff, 0xffffffff,
                 /* 13th byte of body: 0xa1 */
                 0xffffffff, 0x000000ff, 0xffffffff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0xffffffff,
                 /* 14th byte of body: 0x2d */
                 0x000000ff, 0x000000ff, 0xffffffff, 0x000000ff, 0xffffffff,
                 0xffffffff, 0x000000ff, 0xffffffff,
                 /* 15th byte of body: 0xa1 */
                 0xffffffff, 0x000000ff, 0xffffffff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0xffffffff,
                 /* 16th byte of body: 0x2d */
                 0x000000ff, 0x000000ff, 0xffffffff, 0x000000ff, 0xffffffff,
                 0xffffffff, 0x000000ff, 0xffffffff,
                 /* 17th byte of body: 0xa1 */
                 0xffffffff, 0x000000ff, 0xffffffff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0xffffffff,
                 /* 18th byte of body: 0x2b */
                 0x000000ff, 0x000000ff, 0xffffffff, 0x000000ff, 0xffffffff,
                 0x000000ff, 0xffffffff, 0xffffffff,
                 /* 19th byte of body: 0xa1 */
                 0xffffffff, 0x000000ff, 0xffffffff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0xffffffff,
                 /* 20th byte of body: 0x2b */
                 0x000000ff, 0x000000ff, 0xffffffff, 0x000000ff, 0xffffffff,
                 0x000000ff, 0xffffffff, 0xffffffff,
                 /* 21th byte of body: 0x9d */
                 0xffffffff, 0x000000ff, 0x000000ff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0x000000ff, 0xffffffff,
                 /* 22th byte of body: 0xe9 */
                 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0xffffffff,
                 0x000000ff, 0x000000ff, 0xffffffff,
                 /* 23th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 24th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 25th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 26th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 27th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 28th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 29th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 30th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 31th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 32th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff]}],
      // Record 2.
      [{width: 0x10,
        height: 0x10,
        pixels: [0xff0000ff, 0xff0000ff, 0xff0000ff, 0xff0000ff, 0xff0000ff,
                 0xff0000ff, 0xff0000ff, 0xff0000ff, 0xff0000ff, 0xff0000ff,
                 0xff0000ff, 0xff0000ff, 0xff0000ff, 0xff0000ff, 0xff0000ff,
                 0xff0000ff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff,
                 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff,
                 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff,
                 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff,
                 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff,
                 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff,
                 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0x0000ffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0x0000ffff,
                 0x0000ffff, 0xffffffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                 0x0000ffff, 0xffffffff, 0x0000ffff, 0xffffffff, 0xffffffff,
                 0x0000ffff, 0x0000ffff, 0xffffffff, 0x0000ffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0xffffffff,
                 0xffffffff, 0x0000ffff, 0xffffffff, 0x0000ffff, 0x0000ffff,
                 0xffffffff, 0x0000ffff, 0x0000ffff, 0xffffffff, 0x0000ffff,
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff,
                 0xffffffff, 0xffffffff, 0x0000ffff, 0xffffffff, 0x0000ffff,
                 0x0000ffff, 0xffffffff, 0x0000ffff, 0x0000ffff, 0xffffffff,
                 0x0000ffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0x0000ffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0xffffffff,
                 0x0000ffff, 0xffffffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                 0xffffffff, 0x0000ffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0x0000ffff, 0xffffffff, 0xffffffff, 0x0000ffff,
                 0xffffffff, 0x0000ffff, 0xffffffff, 0x0000ffff, 0x0000ffff,
                 0x0000ffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0x0000ffff,
                 0x0000ffff, 0xffffffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                 0x0000ffff, 0xffffffff, 0x0000ffff, 0xffffffff, 0xffffffff,
                 0x0000ffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff,
                 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff,
                 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff,
                 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff,
                 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff,
                 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff,
                 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xff0000ff, 0xff0000ff, 0xff0000ff, 0xff0000ff, 0xff0000ff,
                 0xff0000ff, 0xff0000ff, 0xff0000ff, 0xff0000ff, 0xff0000ff,
                 0xff0000ff, 0xff0000ff, 0xff0000ff, 0xff0000ff, 0xff0000ff,
                 0xff0000ff]}],
      // Record 3.
      [{width: 0x03,
        height: 0x03,
        pixels: [0x000102ff, 0x060708ff, 0x0c0d0eff, 0x121314ff, 0x18191aff,
                 0x1e1f20ff, 0x242526ff, 0x2a2b2cff, 0x333435ff]},
       {width: 0x10,
        height: 0x10,
        pixels: [/* 1st byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 2nd byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 3rd byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 4th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 5th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 6th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 7th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 8th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 9th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 10th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 11th byte of body: 0x9d */
                 0xffffffff, 0x000000ff, 0x000000ff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0x000000ff, 0xffffffff,
                 /* 12th byte of body: 0xe9 */
                 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0xffffffff,
                 0x000000ff, 0x000000ff, 0xffffffff,
                 /* 13th byte of body: 0xa1 */
                 0xffffffff, 0x000000ff, 0xffffffff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0xffffffff,
                 /* 14th byte of body: 0x2d */
                 0x000000ff, 0x000000ff, 0xffffffff, 0x000000ff, 0xffffffff,
                 0xffffffff, 0x000000ff, 0xffffffff,
                 /* 15th byte of body: 0xa1 */
                 0xffffffff, 0x000000ff, 0xffffffff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0xffffffff,
                 /* 16th byte of body: 0x2d */
                 0x000000ff, 0x000000ff, 0xffffffff, 0x000000ff, 0xffffffff,
                 0xffffffff, 0x000000ff, 0xffffffff,
                 /* 17th byte of body: 0xa1 */
                 0xffffffff, 0x000000ff, 0xffffffff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0xffffffff,
                 /* 18th byte of body: 0x2b */
                 0x000000ff, 0x000000ff, 0xffffffff, 0x000000ff, 0xffffffff,
                 0x000000ff, 0xffffffff, 0xffffffff,
                 /* 19th byte of body: 0xa1 */
                 0xffffffff, 0x000000ff, 0xffffffff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0xffffffff,
                 /* 20th byte of body: 0x2b */
                 0x000000ff, 0x000000ff, 0xffffffff, 0x000000ff, 0xffffffff,
                 0x000000ff, 0xffffffff, 0xffffffff,
                 /* 21th byte of body: 0x9d */
                 0xffffffff, 0x000000ff, 0x000000ff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0x000000ff, 0xffffffff,
                 /* 22th byte of body: 0xe9 */
                 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0xffffffff,
                 0x000000ff, 0x000000ff, 0xffffffff,
                 /* 23th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 24th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 25th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 26th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 27th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 28th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 29th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 30th byte of body: 0x00 */
                 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff,
                 0x000000ff, 0x000000ff, 0x000000ff,
                 /* 31th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff,
                 /* 32th byte of body: 0xff */
                 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                 0xffffffff, 0xffffffff, 0xffffffff]}],
      // Record 4.
      [{width: 0x04,
        height: 0x04,
        pixels: [0x00000000, 0x00000000, 0x2a2b2cff, 0x2a2b2cff, 0x272829ff,
                 0x272829ff, 0x242526ff, 0x242526ff, 0x212223ff, 0x212223ff,
                 0x1e1f20ff, 0x1e1f20ff, 0x1b1c1dff, 0x1b1c1dff, 0x18191aff,
                 0x18191aff]}]]};

  function do_test() {
    simRecordHelper.readIMG = function fakeReadIMG(recordNumber, onsuccess, onerror) {
      onsuccess(test_data.rawData[recordNumber]);
    };

    let onsuccess = function(icons) {
      do_check_eq(icons.length, test_data.expected.length);
      for (let i = 0; i < icons.length; i++) {
        for (let j = 0; j < icons[i].length; j++) {
          // Read the j_th image from the i_th record.
          let icon = icons[i][j];
          let expected = test_data.expected[i][j];
          do_check_eq(icon.width, expected.width);
          do_check_eq(icon.height, expected.height);
          do_check_eq(icon.pixels.length, expected.pixels.length);
          for (let k = 0; k < icon.pixels.length; k++) {
            do_check_eq(icon.pixels[k], expected.pixels[k]);
          }
        }
      }
    };

    let recordNumbers = [0, 1, 2, 3];
    iconLoader.loadIcons(recordNumbers, onsuccess);
  }

  do_test();
  run_next_test();
});
