require(['zepto', 'i18next'], function(util) {
    var start = null,
        handle = null;

    function go() {
        if (!start) {
            start = new Date().getTime();
        }
        update = true;
        handle = setInterval(tick, 15);
    }

    function pad(value, padding) {
        return (value > 9 ? value : padding.toString() + value).toString();
    }

    function get_tick() {
        var current = new Date().getTime(),
            diff = new Date(current - start),
            tick = [
                pad(diff.getSeconds(), 0),
                pad(diff.getMinutes(), 0),
                Math.floor(diff / (1000 * 60 * 60)),
                pad(Math.round(diff.getMilliseconds() / 10), 0).substring(0, 2)];
        return tick;
    }

    function tick() {
        var t = get_tick();
        $('#seconds').text(t[0]);
        $('#minutes').text(t[1]);
        $('#hours').text(t[2]);
        $('#milli').text(t[3]);
    }

    function reset() {
        start = null;
        $('#seconds').text('00');
        $('#minutes').text('00');
        $('#hours').text('0');
        $('#milli').text('00');
        $('#lap').trigger('click');
        $('table tbody').html('');
    }

    function lap() {
        var t = get_tick();
        $('table tbody').prepend('<tr><td>' + pad(($('tr').length + 1), ' ') + '</td>' +
                                 '<td>' + t[2] + ':' + t[1] +
                                 ':' + t[0] + '.' + t[3] +
                                 '</td></tr>');
    }

    function stop() {
        update = false;
        start = null;
        clearInterval(handle);
    }

    $(document).ready(function() {
        $('#start').on('click', function() {
            go();
            $('#stopped').hide();
            $('#started').show();
        });

        $('#lap').on('click', function() {
            lap();
        });

        $('#reset').on('click', function() {
            reset();
        });

        $('#stop').on('click', function() {
            stop();
            $('#stopped').show();
            $('#started').hide();
        });

        var resources = {
          'fr': { translation: {
              'heading': 'Chronomètre',
              'start': 'Commencer',
              'lap': 'Tour',
              'reset': 'Remettre',
              'stop': 'Arreter'
            }
          },
          'en': { translation: {
              'heading': 'Stopwatch',
              'start': 'Start',
              'lap': 'Lap',
              'reset': 'Reset',
              'stop': 'Stop'
            }
          }
        };

        i18n.init({resStore: resources});
        i18n.setLng(window.navigator.language, function(){});
        $('.i18n').each(function(i, value) {
            var $value = $(value);
            $value.html(i18n.t($value.data('i18n')));
            $value.removeClass('i18n');
        });
    });
});
