/*
 * Decompiled with CFR 0.152.
 */
package classycle;

import classycle.AnalyserCommandLine;
import classycle.ClassAttributes;
import classycle.PackageProcessor;
import classycle.Parser;
import classycle.XMLPackageRenderer;
import classycle.XMLPackageStrongComponentRenderer;
import classycle.graph.AtomicVertex;
import classycle.graph.StrongComponent;
import classycle.graph.StrongComponentAnalyser;
import classycle.renderer.AtomicVertexRenderer;
import classycle.renderer.PlainStrongComponentRenderer;
import classycle.renderer.TemplateBasedClassRenderer;
import classycle.renderer.XMLClassRenderer;
import classycle.renderer.XMLStrongComponentRenderer;
import classycle.util.StringPattern;
import classycle.util.Text;
import classycle.util.TrueStringPattern;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class Analyser {
    private static final String VERSION = "1.4.1";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final String CSV_TEMPLATE = "{0},{1},{3},{2},{4},{5},{6},{7},{8},{9}\n";
    private final String[] _classFiles;
    private final StringPattern _pattern;
    private final StringPattern _reflectionPattern;
    private final boolean _mergeInnerClasses;
    private StrongComponentAnalyser _classAnalyser;
    private StrongComponentAnalyser _packageAnalyser;

    public Analyser(String[] classFiles) {
        this(classFiles, new TrueStringPattern(), null, false);
    }

    public Analyser(String[] classFiles, StringPattern pattern, StringPattern reflectionPattern, boolean mergeInnerClasses) {
        this._classFiles = classFiles;
        this._pattern = pattern;
        this._reflectionPattern = reflectionPattern;
        this._mergeInnerClasses = mergeInnerClasses;
    }

    public long createClassGraph() throws IOException {
        long time = System.currentTimeMillis();
        AtomicVertex[] classGraph = Parser.readClassFiles(this._classFiles, this._pattern, this._reflectionPattern, this._mergeInnerClasses);
        this._classAnalyser = new StrongComponentAnalyser(classGraph);
        return System.currentTimeMillis() - time;
    }

    public AtomicVertex[] getClassGraph() {
        if (this._classAnalyser == null) {
            try {
                this.createClassGraph();
            }
            catch (IOException e) {
                throw new RuntimeException(e.toString(), e);
            }
        }
        return this._classAnalyser.getGraph();
    }

    public int getNumberOfExternalClasses() {
        AtomicVertex[] graph = this.getClassGraph();
        HashSet<String> usedClasses = new HashSet<String>();
        int result = 0;
        for (int i = 0; i < graph.length; ++i) {
            AtomicVertex vertex = graph[i];
            int n = vertex.getNumberOfOutgoingArcs();
            for (int j = 0; j < n; ++j) {
                ClassAttributes attributes = (ClassAttributes)vertex.getHeadVertex(j).getAttributes();
                if (attributes.getType() != "unknown external class" || usedClasses.contains(attributes.getName())) continue;
                ++result;
                usedClasses.add(attributes.getName());
            }
        }
        return result;
    }

    public long condenseClassGraph() {
        this.checkClassGraph("condenseClassGraph()");
        long time = System.currentTimeMillis();
        this._classAnalyser.getCondensedGraph();
        return System.currentTimeMillis() - time;
    }

    public StrongComponent[] getCondensedClassGraph() {
        this.checkClassGraph("getCondenseClassGraph()");
        return this._classAnalyser.getCondensedGraph();
    }

    public long calculateClassLayerMap() {
        this.checkClassGraph("calculateClassLayerMap()");
        long time = System.currentTimeMillis();
        this._classAnalyser.getLayerMap();
        return System.currentTimeMillis() - time;
    }

    public Map<AtomicVertex, Integer> getClassLayerMap() {
        this.checkClassGraph("getClassLayerMap()");
        return this._classAnalyser.getLayerMap();
    }

    public long createPackageGraph() {
        this.checkClassGraph("createPackageGraph()");
        long time = System.currentTimeMillis();
        PackageProcessor processor = new PackageProcessor();
        processor.deepSearchFirst(this._classAnalyser.getGraph());
        this._packageAnalyser = new StrongComponentAnalyser(processor.getGraph());
        return System.currentTimeMillis() - time;
    }

    public void printCSV(PrintWriter writer) {
        StrongComponent[] cycles = this.getCondensedClassGraph();
        AtomicVertex[] graph = this.getClassGraph();
        Map<AtomicVertex, Integer> map = this.getClassLayerMap();
        writer.println("class name,type,inner class,size,used by,uses internal classes,uses external classes,layer index,cycle,source");
        this.render(graph, cycles, map, new TemplateBasedClassRenderer(CSV_TEMPLATE), writer);
        writer.close();
    }

    public void printRaw(PrintWriter writer) {
        AtomicVertex[] graph = this.getClassGraph();
        for (int i = 0; i < graph.length; ++i) {
            AtomicVertex vertex = graph[i];
            writer.println(vertex.getAttributes());
            int n = vertex.getNumberOfOutgoingArcs();
            for (int j = 0; j < n; ++j) {
                writer.println("    " + vertex.getHeadVertex(j).getAttributes());
            }
        }
        writer.close();
    }

    public void printComponents(PrintWriter writer, int minSize) {
        this.checkClassGraph("printComponents()");
        StrongComponent[] components = this.getCondensedClassGraph();
        PlainStrongComponentRenderer renderer = new PlainStrongComponentRenderer();
        for (int i = 0; i < components.length; ++i) {
            StrongComponent component = components[i];
            if (component.getNumberOfVertices() < minSize) continue;
            writer.println(renderer.render(component));
        }
        writer.close();
    }

    private void checkClassGraph(String method) {
        if (this._classAnalyser == null) {
            throw new IllegalStateException(method + " should be invoked after createClassGraph().");
        }
    }

    public AtomicVertex[] getPackageGraph() {
        if (this._packageAnalyser == null) {
            this.createPackageGraph();
        }
        return this._packageAnalyser.getGraph();
    }

    public long condensePackageGraph() {
        this.checkPackageGraph("condensePackageGraph()");
        long time = System.currentTimeMillis();
        this._packageAnalyser.getCondensedGraph();
        return System.currentTimeMillis() - time;
    }

    public StrongComponent[] getCondensedPackageGraph() {
        this.checkPackageGraph("getCondensedPackageGraph()");
        return this._packageAnalyser.getCondensedGraph();
    }

    public long calculatePackageLayerMap() {
        this.checkPackageGraph("calculatePackageLayerMap()");
        long time = System.currentTimeMillis();
        this._packageAnalyser.getLayerMap();
        return System.currentTimeMillis() - time;
    }

    public Map<AtomicVertex, Integer> getPackageLayerMap() {
        this.checkPackageGraph("getPackageLayerMap()");
        return this._packageAnalyser.getLayerMap();
    }

    public void readAndAnalyse(boolean packagesOnly) throws IOException {
        System.out.println("============= Classycle V1.4.1 =============");
        System.out.println("========== by Franz-Josef Elmer ==========");
        System.out.print("read class files and create class graph ... ");
        long duration = this.createClassGraph();
        System.out.println("done after " + duration + " ms: " + this.getClassGraph().length + " classes analysed.");
        if (!packagesOnly) {
            System.out.print("condense class graph ... ");
            duration = this.condenseClassGraph();
            System.out.println("done after " + duration + " ms: " + this.getCondensedClassGraph().length + " strong components found.");
            System.out.print("calculate class layer indices ... ");
            duration = this.calculateClassLayerMap();
            System.out.println("done after " + duration + " ms.");
        }
        System.out.print("create package graph ... ");
        duration = this.createPackageGraph();
        System.out.println("done after " + duration + " ms: " + this.getPackageGraph().length + " packages.");
        System.out.print("condense package graph ... ");
        duration = this.condensePackageGraph();
        System.out.println("done after " + duration + " ms: " + this.getCondensedPackageGraph().length + " strong components found.");
        System.out.print("calculate package layer indices ... ");
        duration = this.calculatePackageLayerMap();
        System.out.println("done after " + duration + " ms.");
    }

    public void printXML(String title, boolean packagesOnly, PrintWriter writer) {
        Map<AtomicVertex, Integer> layerMap;
        XMLStrongComponentRenderer sRenderer;
        StrongComponent[] components;
        this.checkPackageGraph("printXML()");
        writer.println("<?xml version='1.0' encoding='UTF-8'?>");
        writer.println("<?xml-stylesheet type='text/xsl' href='reportXMLtoHTML.xsl'?>");
        writer.print("<classycle title='");
        writer.print(Text.excapeForXML(title));
        writer.print("' date='");
        writer.print(DATE_FORMAT.format(new Date()));
        writer.println("'>");
        if (!packagesOnly) {
            components = this.getCondensedClassGraph();
            writer.println("  <cycles>");
            sRenderer = new XMLStrongComponentRenderer(2);
            for (int i = 0; i < components.length; ++i) {
                writer.print(sRenderer.render(components[i]));
            }
            writer.println("  </cycles>");
            writer.println("  <classes numberOfExternalClasses=\"" + this.getNumberOfExternalClasses() + "\">");
            AtomicVertex[] graph = this.getClassGraph();
            layerMap = this.getClassLayerMap();
            this.render(graph, components, layerMap, new XMLClassRenderer(), writer);
            writer.println("  </classes>");
        }
        components = this.getCondensedPackageGraph();
        writer.println("  <packageCycles>");
        sRenderer = new XMLPackageStrongComponentRenderer(2);
        for (int i = 0; i < components.length; ++i) {
            writer.print(sRenderer.render(components[i]));
        }
        writer.println("  </packageCycles>");
        writer.println("  <packages>");
        AtomicVertex[] graph = this.getPackageGraph();
        layerMap = this.getPackageLayerMap();
        this.render(graph, components, layerMap, new XMLPackageRenderer(), writer);
        writer.println("  </packages>");
        writer.println("</classycle>");
        writer.close();
    }

    private void render(AtomicVertex[] graph, StrongComponent[] cycles, Map<AtomicVertex, Integer> layerMap, AtomicVertexRenderer renderer, PrintWriter writer) {
        List<StrongComponent> list = this.getTrueCycles(cycles);
        for (int i = 0; i < graph.length; ++i) {
            AtomicVertex vertex = graph[i];
            Integer layerIndex = layerMap.get(vertex);
            writer.print(renderer.render(vertex, this.getCycleFor(vertex, list), layerIndex == null ? -1 : layerIndex));
        }
    }

    private List<StrongComponent> getTrueCycles(StrongComponent[] cycles) {
        ArrayList<StrongComponent> list = new ArrayList<StrongComponent>();
        if (cycles != null) {
            for (int i = 0; i < cycles.length; ++i) {
                if (cycles[i].getNumberOfVertices() <= 1) continue;
                list.add(cycles[i]);
            }
        }
        return list;
    }

    private StrongComponent getCycleFor(AtomicVertex vertex, List<StrongComponent> cycles) {
        for (StrongComponent cycle : cycles) {
            int m = cycle.getNumberOfVertices();
            for (int j = 0; j < m; ++j) {
                if (cycle.getVertex(j) != vertex) continue;
                return cycle;
            }
        }
        return null;
    }

    private void checkPackageGraph(String method) {
        if (this._packageAnalyser == null) {
            throw new IllegalStateException(method + " should be invoked after createPackageGraph().");
        }
    }

    public static void main(String[] args) throws Exception {
        AnalyserCommandLine commandLine = new AnalyserCommandLine(args);
        if (!commandLine.isValid()) {
            System.out.println("Usage: java -jar classycle.jar " + commandLine.getUsage());
            System.exit(0);
        }
        Analyser analyser = new Analyser(commandLine.getClassFiles(), commandLine.getPattern(), commandLine.getReflectionPattern(), commandLine.isMergeInnerClasses());
        analyser.readAndAnalyse(commandLine.isPackagesOnly());
        if (commandLine.getXmlFile() != null) {
            analyser.printXML(commandLine.getTitle(), commandLine.isPackagesOnly(), new PrintWriter(new FileWriter(commandLine.getXmlFile())));
        }
        if (commandLine.getCsvFile() != null) {
            analyser.printCSV(new PrintWriter(new FileWriter(commandLine.getCsvFile())));
        }
        if (commandLine.isRaw()) {
            analyser.printRaw(new PrintWriter(System.out));
        }
        if (commandLine.isCycles() || commandLine.isStrong()) {
            analyser.printComponents(new PrintWriter(System.out), commandLine.isCycles() ? 2 : 1);
        }
    }
}

