/*
 * Decompiled with CFR 0.152.
 */
package classycle.ant;

import classycle.Analyser;
import classycle.ant.ClassycleTask;
import classycle.dependency.DefaultResultRenderer;
import classycle.dependency.DependencyChecker;
import classycle.dependency.ResultRenderer;
import classycle.util.Text;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import org.apache.tools.ant.BuildException;

public class DependencyCheckingTask
extends ClassycleTask {
    private File _definitionFile;
    private String _dependencyDefinition;
    private String _resultRenderer;
    private boolean _failOnUnwantedDependencies;

    public void setFailOnUnwantedDependencies(boolean failOnUnwantedDependencies) {
        this._failOnUnwantedDependencies = failOnUnwantedDependencies;
    }

    public void setDefinitionFile(File definitionFile) {
        this._definitionFile = definitionFile;
    }

    public void setResultRenderer(String resultRenderer) {
        this._resultRenderer = resultRenderer;
    }

    public void addText(String text) {
        this._dependencyDefinition = text.trim();
    }

    @Override
    public void execute() throws BuildException {
        super.execute();
        boolean ok = false;
        PrintWriter printWriter = null;
        try {
            Analyser analyser = new Analyser(this.getClassFileNames(), this.getPattern(), this.getReflectionPattern(), this.isMergeInnerClasses());
            Properties properties = this._definitionFile == null ? this.getProject().getProperties() : System.getProperties();
            DependencyChecker dependencyChecker = new DependencyChecker(analyser, this.getDependencyDefinitions(), properties, this.getRenderer());
            printWriter = this._reportFile == null ? new PrintWriter(System.out) : new PrintWriter(new FileWriter(this._reportFile));
            ok = dependencyChecker.check(printWriter);
            printWriter.flush();
            printWriter.close();
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
        if (this._failOnUnwantedDependencies && !ok) {
            throw new BuildException("Unwanted dependencies found. See output for details.");
        }
    }

    private ResultRenderer getRenderer() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ResultRenderer renderer = new DefaultResultRenderer();
        if (this._resultRenderer != null) {
            renderer = (ResultRenderer)Class.forName(this._resultRenderer).newInstance();
        }
        return renderer;
    }

    private String getDependencyDefinitions() throws IOException, BuildException {
        String result = this._dependencyDefinition;
        if (this._definitionFile != null) {
            result = Text.readTextFile(this._definitionFile);
        }
        if (result.length() == 0) {
            throw new BuildException("Empty dependency definition.");
        }
        return result;
    }
}

