/*
 * Decompiled with CFR 0.152.
 */
package classycle.graph;

import classycle.graph.Vertex;

public abstract class GraphProcessor {
    public void deepSearchFirst(Vertex[] graph) {
        int i;
        this.initializeProcessing(graph);
        for (i = 0; i < graph.length; ++i) {
            graph[i].reset();
        }
        for (i = 0; i < graph.length; ++i) {
            if (graph[i].isVisited()) continue;
            this.process(graph[i]);
        }
        this.finishProcessing(graph);
    }

    protected void process(Vertex vertex) {
        vertex.visit();
        this.processBefore(vertex);
        int n = vertex.getNumberOfOutgoingArcs();
        for (int i = 0; i < n; ++i) {
            this.processArc(vertex, vertex.getHeadVertex(i));
        }
        this.processAfter(vertex);
    }

    protected abstract void initializeProcessing(Vertex[] var1);

    protected abstract void processBefore(Vertex var1);

    protected abstract void processArc(Vertex var1, Vertex var2);

    protected abstract void processAfter(Vertex var1);

    protected abstract void finishProcessing(Vertex[] var1);
}

