#
# spec file for package ccaudio2
#
# Copyright (C) 2014 David Sugar, Tycho Softworks.
# Copyright (C) 2015 Cherokees of Idaho.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#


%define libname libccaudio2-2
Name:           ccaudio2
Version:        2.1.7
Release:        1
Summary:        C++ class framework for telephonic audio applications
License:        LGPL-3.0+
Group:          Productivity/Telephony/Utilities
Url:            http://www.gnutelephony.org/index.php/GNU_ccAudio2
Source:         %{name}-%{version}.tar.gz
BuildRequires:  cmake
BuildRequires:  libgsm-devel
BuildRequires:  pkgconfig
BuildRequires:  speex-devel
BuildRequires:  ucommon-devel >= 6.4.4
Requires:       %{libname}%{?_isa} = %{version}-%{release}
Obsoletes:      %{name}-bin < %{version}-%{release}
Provides:       %{name}-bin = %{version}-%{release}
BuildRoot:      %{_tmppath}/%{name}-%{version}-build

%description
This is a collection of command line tools that use various aspects of the
ccaudio2 library.  This includes command line tools for telephonic processing
of audio files.

%package -n %{libname}
Summary:        GNU ccaudio runtime library
Group:          System/Libraries

%description -n %{libname}
The GNU telephonic audio library covers a range of functionality including
tone generation and detection, streaming and transcoding of encoded audio
frames, accessing of audio files on disk, phrasebook management, and audio
utilities.

%package devel
Summary:        Headers for building ccaudio applications
Group:          Development/Libraries/C and C++
Requires:       %{libname}%{?_isa} = %{version}-%{release}
Requires:       pkgconfig
Requires:       ucommon-devel%{?_isa} >= 6.0.0

%description devel
This package provides header and support files for building applications
that use GNU ccAudio.

%prep
%setup -q

%build
%cmake \
    -DCMAKE_INSTALL_SYSCONFDIR:PATH=%{_sysconfdir} \
    -DCMAKE_INSTALL_LOCALSTATEDIR:PATH=%{_localstatedir}

make %{?_smp_mflags}

%install
%cmake_install

%files -n %{libname}
%defattr(-,root,root,-)
%doc AUTHORS README COPYING COPYING.LESSER NEWS SUPPORT ChangeLog
%{_libdir}/*.so.*
%config(noreplace) %{_sysconfdir}/tones.conf

%files
%defattr(-,root,root,-)
%{_bindir}/audiotool
%{_bindir}/tonetool
%{_mandir}/man1/audiotool.*
%{_mandir}/man1/tonetool.*

%files devel
%defattr(-,root,root,-)
%{_libdir}/*.so
%{_includedir}/ccaudio2.h
%{_libdir}/pkgconfig/*.pc

%post -n %{libname} -p /sbin/ldconfig

%postun -n %{libname} -p /sbin/ldconfig

%changelog
