//
//  Public definitions for Crystal Ball VGA Planets DLL
//

#include <windows.h>

typedef unsigned short  PWord;
#define APPLAPI		far pascal

#ifdef __cplusplus
extern "C" {
#endif

	PWord APPLAPI vpVersion(void);
	PWord APPLAPI vpFound(void);
	int	  APPLAPI vpSearchPath(LPSTR newpath);
	PWord APPLAPI vpPlayer(PWord newplayer, LPSTR password);
	PWord APPLAPI vpFree(void);
	PWord APPLAPI vpTurn(void);

	PWord APPLAPI scoreWarShip(PWord raceid);
	PWord APPLAPI scoreCargoShip(PWord raceid);
	PWord APPLAPI scorePlanet(PWord raceid);
	PWord APPLAPI scoreBase(PWord raceid);
	PWord APPLAPI scoreTotal(PWord raceid);

	LPSTR APPLAPI msgGet(PWord MessNo);
	LPSTR APPLAPI msgGetCurrent(void);
	LPSTR APPLAPI msgGetLine(PWord LineNo);
	PWord APPLAPI msgNext(void);
	PWord APPLAPI msgPrev(void);
	PWord APPLAPI msgStatus(void);
	PWord APPLAPI msgSize(void);
	PWord APPLAPI msgTotal(void);

	LPSTR APPLAPI racenmLongName(PWord raceid, LPSTR retbuffer, PWord retbufsize);
	LPSTR APPLAPI racenmShortName(PWord raceid, LPSTR retbuffer, PWord retbufsize);
	LPSTR APPLAPI racenmAdjective(PWord raceid, LPSTR retbuffer, PWord retbufsize);

	PWord APPLAPI planetX(PWord planetid);
  	PWord APPLAPI planetY(PWord planetid);
	int   APPLAPI planetName(PWord planetid, LPSTR retbuffer, PWord retbufsize);

	int   APPLAPI planetId(PWord planetid);
	int   APPLAPI planetBuildBase(PWord planetid);
	int   APPLAPI planetFCode(PWord planetid, LPSTR retbuffer, PWord retbufsize);
	int   APPLAPI planetOwner(PWord planetid);
	int   APPLAPI planetMines(PWord planetid);
	int   APPLAPI planetFactories(PWord planetid);
	int   APPLAPI planetDefence(PWord planetid);
	int   APPLAPI planetTemperature(PWord planetid);
	long  APPLAPI planetColClans(PWord planetid);
	PWord APPLAPI planetColTax(PWord planetid);
	int   APPLAPI planetColHappiness(PWord planetid);
	PWord APPLAPI planetNatTax(PWord planetid);
	int   APPLAPI planetNatHappiness(PWord planetid);
	PWord APPLAPI planetNatGovernment(PWord planetid);
	long  APPLAPI planetNatPopulation(PWord planetid);
	PWord APPLAPI planetNatType(PWord planetid);
	long  APPLAPI planetFuelAvail(PWord planetid);
	long  APPLAPI planetTritAvail(PWord planetid);
	long  APPLAPI planetDuraAvail(PWord planetid);
	long  APPLAPI planetMolyAvail(PWord planetid);
	long  APPLAPI planetMoneyAvail(PWord planetid);
	long  APPLAPI planetSuppliesAvail(PWord planetid);
	long  APPLAPI planetFuelCore(PWord planetid);
	long  APPLAPI planetTritCore(PWord planetid);
	long  APPLAPI planetDuraCore(PWord planetid);
	long  APPLAPI planetMolyCore(PWord planetid);
	PWord APPLAPI planetFuelDensity(PWord planetid);
	PWord APPLAPI planetTritDensity(PWord planetid);
	PWord APPLAPI planetDuraDensity(PWord planetid);
	PWord APPLAPI planetMolyDensity(PWord planetid);

	int   APPLAPI baseError(void);
	int   APPLAPI baseSetup(LPSTR pdatadat);
	int   APPLAPI baseId(PWord baseid);
	int   APPLAPI baseOwner(PWord baseid);
	int   APPLAPI baseDefence(PWord baseid);
	int   APPLAPI baseDamage(PWord baseid);
	int   APPLAPI baseFighters(PWord baseid);
	int   APPLAPI baseShipToFix(PWord baseid);
	int   APPLAPI baseFixOrder(PWord baseid);
	int   APPLAPI baseBaseMission(PWord baseid);
	int   APPLAPI baseTLEngine(PWord baseid);
	int   APPLAPI baseTLBeam(PWord baseid);
	int   APPLAPI baseTLTorp(PWord baseid);
	int   APPLAPI baseTLHull(PWord baseid);
	int   APPLAPI baseTechLevel(PWord baseid, PWord knowledge);
	int   APPLAPI baseEngines(PWord baseid, PWord techlevel);
	int   APPLAPI baseBeams(PWord baseid, PWord techlevel);
	int   APPLAPI baseHulls(PWord baseid, PWord techlevel);
	int   APPLAPI baseTubes(PWord baseid, PWord techlevel);
	int   APPLAPI baseTorpedos(PWord baseid, PWord techlevel);

	PWord APPLAPI shipX(PWord shipid);
	PWord APPLAPI shipY(PWord shipid);
	PWord APPLAPI shipOwner(PWord shipid);
	PWord APPLAPI shipMass(PWord shipid);
	PWord APPLAPI shipSpeed(PWord shipid);
	PWord APPLAPI shipHull(PWord shipid);
	int   APPLAPI shipHeading(PWord shipid);
	PWord APPLAPI shipName(PWord shipid, LPSTR retbuffer, PWord retbufsize);
	PWord APPLAPI shipDestroyed(PWord shipid);

	PWord APPLAPI mineX(PWord Mine);
	PWord APPLAPI mineY(PWord Mine);
	PWord APPLAPI mineOwner(PWord Mine);
	PWord APPLAPI mineUnits(PWord Mine);
	PWord APPLAPI mineWeb(PWord Mine);

	PWord APPLAPI hullTrue(PWord raceid, PWord slotid);
	int   APPLAPI hullName(PWord hullid, LPSTR retbuffer, PWord retbufsize);
	PWord APPLAPI hullTechLevel(PWord hullid);
	PWord APPLAPI hullMass(PWord hullid);
	PWord APPLAPI hullPicture(PWord hullid);
	PWord APPLAPI hullTritanium(PWord hullid);
	PWord APPLAPI hullDuranium(PWord hullid);
	PWord APPLAPI hullMolybdenum(PWord hullid);
	PWord APPLAPI hullMoney(PWord hullid);
	PWord APPLAPI hullFuelTankSize(PWord hullid);
	PWord APPLAPI hullCrewSize(PWord hullid);
	PWord APPLAPI hullCargoSize(PWord hullid);
	PWord APPLAPI hullEngines(PWord hullid);
	PWord APPLAPI hullBays(PWord hullid);
	PWord APPLAPI hullTubes(PWord hullid);
	PWord APPLAPI hullBeams(PWord hullid);

	int   APPLAPI engineName(PWord engineid, LPSTR retbuffer, PWord retbufsize);
	PWord APPLAPI engineTechLevel(PWord engineid);
	PWord APPLAPI engineTritanium(PWord engineid);
	PWord APPLAPI engineDuranium(PWord engineid);
	PWord APPLAPI engineMolybdenum(PWord engineid);
	PWord APPLAPI engineMoney(PWord engineid);
	PWord APPLAPI engineFuelUsage(PWord engineid, PWord warp);

	int   APPLAPI beamName(PWord beamid, LPSTR retbuffer, PWord retbufsize);
	PWord APPLAPI beamTechLevel(PWord beamid);
	PWord APPLAPI beamMass(PWord beamid);
	PWord APPLAPI beamTritanium(PWord beamid);
	PWord APPLAPI beamDuranium(PWord beamid);
	PWord APPLAPI beamMolybdenum(PWord beamid);
	PWord APPLAPI beamMoney(PWord beamid);
	PWord APPLAPI beamKill(PWord beamid);
	PWord APPLAPI beamDestruction(PWord beamid);

	int   APPLAPI torpName(PWord torpid, LPSTR retbuffer, PWord retbufsize);
	PWord APPLAPI torpTechLevel(PWord torpid);
	PWord APPLAPI torpMass(PWord torpid);
	PWord APPLAPI torpTritanium(PWord torpid);
	PWord APPLAPI torpDuranium(PWord torpid);
	PWord APPLAPI torpMolybdenum(PWord torpid);
	PWord APPLAPI torpAmmoCost(PWord torpid);
	PWord APPLAPI torpMoney(PWord torpid);
	PWord APPLAPI torpKill(PWord torpid);
	PWord APPLAPI torpDestruction(PWord torpid);

#ifdef __cplusplus
}
#endif
