#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "phostpdk.h"

#ifdef __MSDOS__
#ifdef __cplusplus
extern "C" {
#endif
extern void fnsplit(const char *, char *, char *, char *, char *);
#ifdef __cplusplus
}
#endif
#endif

char *poptarg;    /* Global argument pointer. */
int  poptind = 0; /* Global argv index. */

static char *scan = NULL;	/* Private scan pointer. */

int
pgetopt(int argc, char *argv[], char *optstring)
{
    char c;
    char *place;

	poptarg = NULL;

	if (scan == NULL || *scan == '\0') {
		if (poptind == 0)
			poptind++;

		if (poptind >= argc || argv[poptind][0] != '-' || argv[poptind][1] == '\0')
			return(EOF);
		if (strcmp(argv[poptind], "--")==0) {
			poptind++;
			return(EOF);
		}

		scan = argv[poptind]+1;
		poptind++;
	}

	c = *scan++;
    place = strchr(optstring, c);

	if (place == NULL || c == ':') {
#ifdef __MSDOS__
		char fname[256];

		fnsplit(argv[0],0,0,fname,0);
#else
#define fname argv[0]
#endif
		fprintf(stderr,"%s: unknown option -%c\n", fname, c);
		return('?');
	}

	place++;
	if (*place == ':') {
		if (*scan != '\0') {
			poptarg = scan;
			scan = NULL;
		} else {
			poptarg = argv[poptind];
			poptind++;
		}
	}

	return(c);
}

