#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include "altspec.h"

FILE * planfile;
FILE * logfile;
char path[80]= {'\0'};
racenm name;
int pathdir;

long int min(long int first, long int second);
int invoptions();
char * pathtofile(const char * fname);
int main(int args, char* cline[]);
int AddMessage(int pPlayer, char* pMessages[], int num);
int CopyMessages(FILE*  pOldResultFile, FILE* pNewResultFile,
                     unsigned long int  pLengthOfNewMessages,
                     unsigned int  pNewMessageNr,
                     char*  pNewMessages[], unsigned int  pMessageStart);
int WriteNewResultStart(FILE*  pOldResultFile, FILE* pNewResultFile,
                         unsigned long int  pLengthOfNewMessages,
                         unsigned int pNewMessageNr,
                         unsigned long int* pMessageStart,
                         unsigned long int* pMessageEnd);
int lprintf(int scrn, const char * mess, ...);


int main (int args, char* cline[]) {
  int pts[11] = {0};
  int newpts[11] = {0};
  int hws[11] = {0};
  int list[11] = {0};
  int x, y, z;
  int hwval, exval, listtype, argst;
  int * extra;  int * expts;
  char * messages[21];
  char * message;
  char filename[80] = {'\0'};
  char fill;
  bdata bsinfo;
  pdata hwinfo;

  printf("Invasion! v1.2b by Micheal Keane\n");
  printf(" An invasion scenario util for hosts\n");

  printf("%d %s %s\n", args, cline[0], cline[1]);

  strcpy(path, ".\\");
  pathdir = 0; hwval = 1; exval = 0; listtype = 1;
  argst = 1;

  if (args > 1) {
    if (cline[1][0] != '/') {
      strcpy(path, cline[1]);
      argst++;
    }
    for (x = argst; x < args; x++) {
      if (cline[x][0] == '/') {
        if ((x + 1) < args) {
          switch(cline[x][1]) {
            case 'h':
              hwval = atoi(cline[x + 1]);
              x++;
              break;
            case 'l':
              listtype = atoi(cline[x + 1]);
              x++;  
              break;
          }
        }
      }
    }
    if ((hwval < 0)) {
      invoptions();
      exit(1);
    }
    if ((listtype < 1) || (listtype > 3)) {
      lprintf(1, "illegal listtype, defaulting to 1\n");
      listtype = 1;
    }
  }

  x = strlen(path) - 1;

  if (path[x] != 92) {
    strcat(path, "\\");
  }

  strcpy(filename, pathtofile("inv.log"));
  logfile = fopen(filename, "w+t");
  if (logfile == NULL)  {
    printf("Invalid path!\n");
    exit(1);
  }
  fclose(logfile);

  lprintf(0, "Invasion! v1.2b by Micheal Keane\n");
  lprintf(0, " An invasion scenario util for hosts\n");
  lprintf(0, "%d %s %s\n", args, cline[0], cline[1]);
  lprintf(1, "hwval=%d\n", hwval);
  lprintf(1, "listtype=%d\n", listtype);
  lprintf(1, "path=%s\n", path);
  
  if ((message = (char *)malloc(1600)) == NULL) {
    lprintf(1, "(message = (char *)malloc(1600)) failed\n");
    exit(1);
  }
  message[0] = '\0';

  for (x = 0; x < 21; x++) {
    if ((messages[x] = (char *)malloc(40)) == NULL) {
      lprintf(1, "(messages[%i] = (char *)malloc(40)) failed\n", x);
      exit(1);
    }
    strcpy(messages[x], "\0");
  }  

  loadfiles();

  strcpy(filename, pathtofile("inv1.hst"));
  lprintf(1, "Now opening and reading %s...\n", filename);
  planfile = fopen(filename, "r+t");
  if (planfile != 0) {
    for (x  = 0; x < 11; x++) {
      fscanf(planfile, "%d %d", &hws[x], &pts[x]);
    }
    fclose(planfile);
  }
  else {
    fclose(planfile);
    strcpy(filename, pathtofile("refdata.hst"));
    lprintf(1, "inv1.hst not found... scanning %s\n", filename);
    planfile = fopen(filename, "r+b");
    if (planfile != 0) {
       fread(hws, 2, 3, planfile);
       fread(hws, 2, 11, planfile);
    }
    else {
      strcpy(filename, pathtofile("bdata.hst"));
      lprintf(1, "refdata.hst not found... scanning %s\n", filename);
      planfile = fopen(filename, "r+b");
      if (planfile != 0) {              
        for (x = 0; x < 500; x++) {
          fseek(planfile, (long int)(x * sizeof(bdata) + 2), SEEK_SET);
          fread(&bsinfo, sizeof(bdata), 1, planfile);
          if (bsinfo.race != 0) {
            hws[bsinfo.race - 1] = x + 1;
      } } }
      else {
        lprintf(1, "bdata.hst doesn't exist!\nExiting Invasion!\n");
        invoptions();
        exit(1);
  } } }
  fclose(planfile);

  strcpy(filename, pathtofile("inv2.hst"));
  lprintf(1, "Looking for %s...\n", filename);
  planfile = fopen(filename, "r+t");
  if (planfile != NULL) {
    fscanf(planfile, "%d", &exval);
    if ( ((extra = (int *)malloc(2 * (exval + 1))) == NULL) ||
         ((expts = (int *)malloc(2 * (exval + 1))) == NULL) ) {
       lprintf(1, "((extra = (int *)malloc(%i)) || (expts = (int *)malloc(%i))) failed!\n",
            (2 * (exval + 1)), (2 * (exval + 1)));
       exit(1);
    }
    for (x = 0; x < exval; x++) {
      fscanf(planfile, "%d %d", (extra + x), (expts + x));
    }
  }
  else {
    lprintf(1, "optional inv2.hst not found...\n");
  }
  fclose(planfile);

  strcpy(filename, pathtofile("pdata.hst"));
  lprintf(1, "Now opening and reading %s\n", filename);
  planfile = fopen(filename, "r+b");
  if (planfile == NULL) {
    lprintf(1, "pdata.hst doesn't exist!\nExiting Invasion!\n");
    invoptions();
    exit(1);
  }
  lprintf(1, "tallying points this turn...\nstarting with homeworlds...\n");
  for (x = 0; x < 11; x++) {
    if ((hws[x] != 0) && (hws[x] < 501)) {
      fseek(planfile, (long int)((hws[x] - 1) * sizeof(pdata) + 2), SEEK_SET);
      fread(&hwinfo, sizeof(pdata), 1, planfile);
      if ((x != (hwinfo.race - 1)) && (hwinfo.race > 0) &&
      (hwinfo.race < 12)) {
        newpts[(hwinfo.race - 1)] += hwval;
  } } }

  if (exval > 0) {
    lprintf(1, "tallying extra points...\n");
    for (x = 0; x < exval; x++) {
      fseek(planfile, (long int)((extra[x] - 1) * sizeof(pdata) + 2), SEEK_SET);
      fread(&hwinfo, sizeof(pdata), 1, planfile);
      if ((hwinfo.race > 0) && (hwinfo.race < 12)) {
        newpts[(hwinfo.race - 1)] += expts[x];
  } } }
    
  fclose(planfile);

  for (x = 0; x < 11; x++) {
    pts[x] += newpts[x];
  }
  strcpy(filename, pathtofile("inv1.hst"));
  lprintf(1, "Now opening and writing %s\n", filename);
  planfile = fopen(filename, "w+t");
  for (x  = 0; x < 11; x++) {
    fprintf(planfile, "%i %i\n", hws[x], pts[x]);
  }
  fclose(planfile);

  lprintf(1, "preparing message to players..\n");
  sprintf(messages[0], "   <<< Invasion Report! >>>\r");
  sprintf(messages[1], "\r");
  sprintf(messages[2], " # Name                 Total  New\r");
  for (x = 0; x < 11; x++) {
    fill = name.informal[x][20];
    name.informal[x][20] = '\0';
    sprintf(messages[x+3], "%2d %20s  %3d  %3d\r",
     x+1, name.informal[x], pts[x], newpts[x]);
    name.informal[x][20] = fill;
  }
  for (x = 14; x < 18; x++) {
    sprintf(messages[x], "\r");
  }
  sprintf(messages[18], "Invasion! v1.2b by Micheal Keane\r");
  sprintf(messages[19], "\r");

  lprintf(1, "ordering scores...\n");

  switch(listtype) {
    case 1:
      for (x = 0; x < 11; x++) {
        list[x] = pts[x];
      }
      break;
    case 2:
      for (x = 0; x < 11; x++) {
        list[x] = newpts[x];
      }
      break;
    case 3:
      for (x = 0; x < 11; x++) {
        list[x] = 12 - x;
      }
      break;
  }


  for (x = 0; x < 11; x++) {
    for (y = x; y < 11; y++) {
      if (list[y] > list[x]) {
        strcpy(messages[20], messages[x+3]);
        strcpy(messages[x+3], messages[y+3]);
        strcpy(messages[y+3], messages[20]);
        z = list[x]; list[x] = list[y]; list[y] = z;
      }
    }
  }

  strcpy(filename, pathtofile("invscore.txt"));
  planfile = fopen(filename, "w+t");
  for (x = 0; x < 20; x++) {
    printf("%s\n", messages[x]);
    fprintf(planfile, "%s\n", messages[x]);
  }
  fclose(planfile);

  lprintf(1, "shifting message...\n");
  
  for (x = 0; x < 20; x++) {
    for (y = 0; y < strlen(messages[x]); y++) {
        messages[x][y] += 13;
    }
    strcat(message, messages[x]);
  }

  for (x = 1; x < 12; x++) {
    if (hws[x - 1] != 0) {
      lprintf(1, "sending message to player %i\n", x);
      AddMessage(x, &message, 1);
    }
  }

  if (exval != 0) {
    free(extra);
    free(expts);
  }
  free(message);

  lprintf(1, "Finished!\n");
  return 0;
}

int invoptions() {
  printf("INV command line options\n");
  printf(" INV [Path] [/H ##]\n");
  printf("[Path] must be a valid directory\n");
  printf("/H ## where ## is the point value for homeworlds. Defaults to 1\n\n");

  return 0;
}

int loadfiles() {
  char filename[80];
  FILE * namefile;

  lprintf(1, "now opening and loading race.nm...\n");

  strcpy(filename, pathtofile("RACE.NM"));
  if (((namefile = fopen(filename, "rb")) == NULL) && (pathdir > 0)) {
    strcpy(filename, "RACE.NM");
    if ((namefile = fopen(filename, "rb")) == NULL) {
      lprintf(1, "%s not found!\n", filename);
      exit(1);
    }
  }

  if (fread(&name, sizeof(racenm), 1, namefile) == 0) {
    lprintf(1, "fread failed!\n");
    exit(1);
  }
  fclose(namefile);

  return 1;
}

char * pathtofile(const char * fname) {
  char fn[80] = {'\0'};
  sprintf(fn, "%s%s", path, fname);
  return fn;
}

int lprintf (int scrn, const char * mess, ...) {
  int x;
  va_list ap;
  char filename[80];

  va_start(ap, mess);

  strcpy(filename, pathtofile("inv.log"));
  logfile = fopen(filename, "a+t");
  x = vfprintf(logfile, mess, ap);
  fclose(logfile);

  if (scrn != 0) {
    vprintf(mess, ap);
  }
  va_end(ap);
  return x;
}

#pragma warn -par
void ConvertLongToDos(unsigned long int* pData, unsigned int pNumber)
{
#ifndef __MSDOS__
    while (pNumber-- > 0)
    {
        *pData =    ( ((*pData) & 0x000000FFUL) << 24 )
                  | ( ((*pData) & 0x0000FF00UL) <<  8 )
                  | ( ((*pData) & 0x00FF0000UL) >>  8 )
                  | ( ((*pData) & 0xFF000000UL) >> 24 );
        pData++;
    }
#endif
}

void ConvertShortToDos(unsigned int* pData, unsigned int pNumber)
{
#ifndef __MSDOS__
    while (pNumber-- > 0)
    {
        *pData= ( (((*pData) & 0x00FFU) << 8) | (((*pData) & 0xFF00U) >> 8) );
        pData++;
    }
#endif
}

#pragma warn +par

#define ConvertLongToUnix  ConvertLongToDos
#define ConvertShortToUnix ConvertShortToDos

/* replace the first 32 bytes in the result that contain the adresses of the
   result parts
   Returned are the start of the messages in the result and the start of the
   following object */
int WriteNewResultStart(FILE*  pOldResultFile, FILE* pNewResultFile,
                         unsigned long int  pLengthOfNewMessages,
                         unsigned int pNewMessageNr,
                         unsigned long int* pMessageStart,
                         unsigned long int* pMessageEnd)
{
    unsigned long int lObjectStart;
    int i;

    for (i=0; i<5; i++)
    {
        if (!fread(&lObjectStart,4,1,pOldResultFile))
            return 0;
        fwrite(&lObjectStart,4,1,pNewResultFile);
    }

    ConvertLongToUnix(&lObjectStart,1);
    *pMessageStart=lObjectStart;
    if (!fread(pMessageEnd,4,1,pOldResultFile))
        return 0;
    ConvertLongToUnix(pMessageEnd,1);
    *pMessageEnd+=pLengthOfNewMessages+6*pNewMessageNr;

    lObjectStart=*pMessageEnd;
    ConvertLongToDos(&lObjectStart,1);
    fwrite(&lObjectStart,4,1,pNewResultFile);

    for (i=0; i<2; i++)
    {
        if (!fread(&lObjectStart,4,1,pOldResultFile))
            return 0;
        ConvertLongToUnix(&lObjectStart,1);
        lObjectStart+=pLengthOfNewMessages+6*pNewMessageNr;
        ConvertLongToDos(&lObjectStart,1);
        fwrite(&lObjectStart,4,1,pNewResultFile);
    }

    return 1;
}

/* the pNewMessages[] array contains the new messages, already formatted
   as result messages (+13 shifted). */
int CopyMessages(FILE*  pOldResultFile, FILE* pNewResultFile,
                     unsigned long int  pLengthOfNewMessages,
                     unsigned int  pNewMessageNr,
                     char*  pNewMessages[], unsigned int  pMessageStart)
{
    unsigned int lOldMessageNr,
          lTmpUns16,
          i;
    unsigned long int lTmpUns32;

    if (!fread(&lOldMessageNr,2,1,pOldResultFile))
        return 0;
    ConvertShortToUnix(&lOldMessageNr,1);
    lTmpUns16=lOldMessageNr+pNewMessageNr;
    ConvertShortToDos(&lTmpUns16,1);
    fwrite(&lTmpUns16,2,1,pNewResultFile);

/* calculate the start of the message bodies : 6 bytes per header entry,
 * 2 bytes for the number of messages, 1 byte for the 0 after the headers
 * The starting offset is the old start of the message block
 */
    pMessageStart+=3+6*(lOldMessageNr+pNewMessageNr);

/* first write the header entries for the new messages : start, length */
    for (i=0; i<pNewMessageNr; i++)
    {
        lTmpUns16=strlen(pNewMessages[i]);
        lTmpUns32=pMessageStart;
        pMessageStart+=lTmpUns16;

        ConvertShortToDos(&lTmpUns16,1);
        ConvertLongToDos(&lTmpUns32,1);
        fwrite(&lTmpUns32,4,1,pNewResultFile);
        fwrite(&lTmpUns16,2,1,pNewResultFile);
    }

/* now write the header entries for the old messages : start, length
 * The start of the messages is shifted by pLengthOfNewMessages+6*pNewMessageNr */

    for (i=0; i<lOldMessageNr; i++)
    {
        if (!fread(&lTmpUns32,4,1,pOldResultFile))
            return 0;
        ConvertLongToUnix(&lTmpUns32,1);
        lTmpUns32+=pLengthOfNewMessages+6*pNewMessageNr;
        ConvertLongToDos(&lTmpUns32,1);
        fwrite(&lTmpUns32,4,1,pNewResultFile);

        if (!fread(&lTmpUns16,2,1,pOldResultFile))
            return 0;
        fwrite(&lTmpUns16,2,1,pNewResultFile);
    }

/* write dummy 0 */
    fread(&i,1,1,pOldResultFile);
    fwrite(&i,1,1,pNewResultFile);

/* insert the body of the new messages */
    for (i=0; i<pNewMessageNr; i++)
    {

      lTmpUns16=strlen(pNewMessages[i]);

      fwrite(pNewMessages[i],lTmpUns16,1,pNewResultFile);
    }

    return 1;
}


int AddMessage(int pPlayer, char* pMessages[], int num)
{
    int      x;  
    FILE     *lOldResult,
             *lNewResult;
    char     NewName[20],
             OldName[20],
             *lBuffer,
             tempname[2][80];
    unsigned long int    lMessLength=0,
             lMessStart,
             lMessEnd,
             lTmpUns32;
    unsigned int    lNewMessageNr=num,
             lTmpUns16;

    static const unsigned int lBufferLength=10240;

    sprintf(NewName, "player%d.rst", pPlayer);
    sprintf(OldName, "player%d.bak", pPlayer);

    strcpy(tempname[0], pathtofile(OldName));
    strcpy(tempname[1], pathtofile(NewName));
    remove(tempname[0]);

    if (rename(tempname[1],tempname[0]))    {
         lprintf(1, "can't find %s...\n",NewName);
         return 1;
    }

    if (  ((lOldResult=fopen(tempname[0],"rb")) == NULL)
       || ((lNewResult=fopen(tempname[1],"wb")) == NULL)   ) {
        return 1;
    }

    for (x = 0; x < num; x++) {
        lMessLength+=strlen(pMessages[x]);
    }

    if (!WriteNewResultStart(lOldResult, lNewResult, lMessLength, lNewMessageNr,
                             &lMessStart, &lMessEnd)) {
        goto FailedRead;
    }

    lTmpUns32=lMessStart-33;
    lBuffer=(char*)malloc(lBufferLength);
    if (lBuffer == NULL) {
        lprintf(1, "Out of memory.\n");
        return 1;
    }

    while (lTmpUns32>0)
    {
        if (!fread(lBuffer,(unsigned int)min(lTmpUns32,lBufferLength),1,lOldResult))
            goto FailedRead;
        fwrite(lBuffer,(unsigned int)min(lTmpUns32,lBufferLength),1,lNewResult);
        lTmpUns32-=min(lTmpUns32,lBufferLength);
    }

    if (!CopyMessages(lOldResult, lNewResult, lMessLength, lNewMessageNr,
                      pMessages, lMessStart)) {
        goto FailedRead;
    }
    do
    {
        lTmpUns16=fread(lBuffer,1,lBufferLength,lOldResult);
        fwrite(lBuffer,1,lTmpUns16,lNewResult);
    }
    while (lBufferLength == lTmpUns16);
    free(lBuffer);

    fclose(lOldResult);
    fclose(lNewResult);
    return 0;

FailedRead :
    lprintf(1, "Unexpected end of file in player%u.rst\n", pPlayer);
    fclose(lOldResult);
    fclose(lNewResult);
    return 1;
}

long int min(long int first, long int second) {
    return ((first < second) ? first : second);
}
