#include "plateau.h"
 
extern struct piece pieces[24];
 
/*  Miscellaneous functions  */
 
char lookup();
int parsesquare();
int parsepiece();
int findpiece();
char *color_to_txt();
void flip();
enum weapons char_to_weap();
void cpstruct();
 
 
char lookup(weapon)
enum weapons weapon;
{   switch (weapon)
	{   case blank: return 'x';
		case red:   return 'r';
		case blue:  return 'b';
		case orange:return 'o';
	}
	return '?';
}
 
int parsesquare(buffer,cptr,rptr)
char buffer[5];
int *cptr,*rptr;
{   *cptr = (tolower(*buffer)-97);
    *rptr = atoi(buffer+1) - 1;
  
    if ( (*cptr > 3) || (*cptr < 0) || (*rptr > 3) || (*rptr < 0) )
	return -1;
    else
	return 0;
}
 
int parsepiece(buffer,tptr,bptr)
char buffer[5];
enum weapons *tptr,*bptr;
{   *tptr = char_to_weap(*buffer);
    *bptr = char_to_weap(*(buffer+1));
 
    if ((*tptr == unknown) || (*bptr == unknown))
	return -1;
    else
	return 0;
}
 
int findpiece(tside,bside,color,pstatus)
enum weapons tside,bside;
enum colors color;
enum location pstatus;
{   int hash,limit;
 
    hash = (int)tside + (int)bside;
    if (hash != 0)
	hash += 3;
    hash += (color == black) ? 0 : 12;
    limit = (color == black) ? 12 : 24;
 
    for (;hash < limit;hash++)
    {	if (pieces[hash].status != pstatus)
	    continue;
	if (pieces[hash].top == tside)
	{   if (pieces[hash].bottom == bside)
		return (hash);
	}
	else
	{   if (pieces[hash].bottom == tside && pieces[hash].top == bside)
	    {	flip(hash);
		return (hash);
	    }
	}
    }
    return -1;
}
 
char *color_to_txt(color,tptr)
enum colors color;
char tptr[];
{   if (color == black)
		strcpy(tptr,"black");
    else
    {   if (color == white)
	    	strcpy(tptr,"white");
		else
			return NULL;
    }
    return tptr;
}
 
void flip(pieceno)
int pieceno;
{   enum weapons temp;
    int under;
 
    temp = pieces[pieceno].top;
    pieces[pieceno].top = pieces[pieceno].bottom;
    pieces[pieceno].bottom = temp;
    if (pieces[pieceno].revealed == top)
		pieces[pieceno].revealed = all;
 
    if ((under = pieces[pieceno].link) != 99)
    {   if (pieces[under].revealed == none)
	    pieces[under].revealed = top;
    }
}
 
enum weapons char_to_weap(side)
char side;
{   switch (side)
	{	case 'x' :  return blank;
		case 'o' :  return orange;
		case 'r' :  return red;
		case 'b' :  return blue;
	}
	return unknown;
}
 
void cpstruct(old,new)
struct gameinfo old;
struct gameinfo *new;
{   
    strcpy(new->name,old.name);
    strcpy(new->opp_address,old.opp_address);
    new->color = old.color;
    new->moveno = old.moveno;
    new->status = old.status;
    new->comments = old.comments;
}
