#include "plateau.h"
 
extern struct square board[4][4];
extern struct piece pieces[24];
extern struct square stack;
 
extern int captureno;
extern int to_capture[10];
 
/*  Display functions  */
 
void enterline();
void drawline();
void scroll();
void display();
void clear_display();
void onboard_setup();
void offboard_setup();
void stack_setup();
void offered_setup();
void putpiece();
void put_to_screen();
 
void enterline(text,buffer)
char text[],buffer[80];
{   printf("%s",text);
    fgets(buffer,80,stdin);
    strtok(buffer,"\n");
} 
 
void drawline(text)
char text[];
{   printf("%s",text);
}
 
void scroll()
{   printf("\n");
}
 
void entercomment(buffer)
char buffer[80];
{   fgets(buffer,80,stdin);
    if (*buffer == '\n')
	*buffer = NULL;
}
 
void display(gameptr)
struct gameinfo *gameptr;
{   char display[25][80];
 
    clear_display(display);
    onboard_setup(gameptr,display);
    offboard_setup(gameptr,display);
    stack_setup(gameptr,display);
    offered_setup(gameptr,display);
    put_to_screen(display);
}
 
void clear_display(display)
char display[25][80];
{   int i,j;
 
    for (i=0;i<25;i++)
	for (j=0;j<80;j++)
	    display[i][j] = ' ';
 
    for (i=16;i>=0;i--)
	for (j=5;j<=45;j+=10)
	    display[23-i][i+j] = '/';
 
    for (i=16;i>=0;i-=4)
	for (j=i+1;j<i+40;j++)
	    display[23-i][j+5] = '-';
 
    display[9][16] = '4';
    display[13][12] = '3';
    display[17][8] = '2';
    display[21][4] = '1';
    display[6][26] = 'A';
    display[6][36] = 'B';
    display[6][46] = 'C';
    display[6][56] = 'D';
}
 
void onboard_setup(gameptr,display)
struct gameinfo *gameptr;
char display[25][80];
{   int i,j,k,pieceno,row,column;
 
    for (i=0;i<4;i++)
	for (j=0;j<4;j++)
	{   k = board[i][j].stackheight;
	    if (k == 0)
		continue;
	    else
	    {	pieceno = board[i][j].link;
		while (k-- > 0)
		{   row = 22 - (4*j) - k;
		    column = 10 + (4*j) + (10*i);
		    if (gameptr->status == 'b' || gameptr->status == 'w')
		    	putpiece(gameptr,pieceno,display,row,column,all);
		    else
		    	putpiece(gameptr,pieceno,display,row,column,
				pieces[pieceno].revealed);
		    pieceno = pieces[pieceno].link;
		}
	    }
	}
}
 
void offboard_setup(gameptr,display)
struct gameinfo *gameptr;
char display[25][80];
{   int i,wcaptured=0,bcaptured=0,woff=0,boff=0;
 
    for (i=0;i<12;i++)
	if (pieces[i].status == captured)
	{
	    putpiece(gameptr,i,display,23-bcaptured,60,all);
	    sprintf(&(display[23-bcaptured][56]),"%2d",pieces[i].value);
	    display[23-bcaptured][58] = ' ';
	    bcaptured++;
	}
	else if (pieces[i].status == offboard)
	{   
	    putpiece(gameptr,i,display,7+boff,0,none);
	    boff++;
	}
 
    for (i=12;i<24;i++)
	if (pieces[i].status == captured)
	{   putpiece(gameptr,i,display,7+wcaptured,7,all);
	    sprintf(&(display[7+wcaptured][12]),"%2d",pieces[i].value);
	    display[7+wcaptured][14] = ' ';
	    wcaptured++;
	}
	else if (pieces[i].status == offboard)
	{   putpiece(gameptr,i,display,23-woff,67,none);
	    woff++;
	}
 
    for (i=0;i<captureno;i++)
    {   if (COLOR(to_capture[i]) == black)
        {   putpiece(gameptr,to_capture[i],display,23-bcaptured,60,
	            pieces[to_capture[i]].revealed);
	    sprintf(&(display[23-bcaptured][56]),"??");
	    display[23-bcaptured][58] = ' ';
            bcaptured++;
 	}
	else
	{   putpiece(gameptr,to_capture[i],display,7+wcaptured,7,
	            pieces[to_capture[i]].revealed);
	    sprintf(&(display[7+wcaptured][12]),"??");
	    display[7+wcaptured][14] = ' ';
	    wcaptured++;
	}
    }
}
 
void offered_setup(gameptr,display)
struct gameinfo *gameptr;
char display[25][80];
{   int pieceno,i=10;
 
    if (gameptr->status != 'o')
	return;
 
    strncpy(&(display[24][0]),"Offered:",8);
    for (pieceno=0;pieceno<24;pieceno++)
	if (pieces[pieceno].status == offered)
	{   putpiece(gameptr,pieceno,display,24,i,all);
	    i+=5;
	}
}
	
 
 
void stack_setup(gameptr,display)
struct gameinfo *gameptr;
char display[25][80];
{   int i,pieceno;
 
    if (stack.stackheight == 0)
	return;
 
    strncpy(&(display[5][67]),"Stack:",6);
    pieceno = stack.link;
    putpiece(gameptr,pieceno,display,7,67,all);
    i=0;
    while ((pieceno = pieces[pieceno].link) != 99)
    {   i++;
	putpiece(gameptr,pieceno,display,7+i,67,all);
    }
}
 
void putpiece(gameptr,pieceno,display,row,column,known)
struct gameinfo *gameptr;
int pieceno;
char display[25][80];
int row,column;
enum info known;
{   if (pieceno < 12)
    {	display[row][column]   = '<';
	display[row][column+3] = '>';
    }
    else
    {	display[row][column]   = '[';
	display[row][column+3] = ']';
    }
 
    if (((gameptr->color == black) && (pieceno < 12)) ||
	((gameptr->color == white) && (pieceno >= 12)))
	    known = all;
 
    if (known == none || known == to_be_top)
        display[row][column+1] = ' ';
    else
	display[row][column+1] = lookup(pieces[pieceno].top);
 
    if (known == all)
	display[row][column+2] = lookup(pieces[pieceno].bottom);
    else
	display[row][column+2] = ' ';
}
 
void put_to_screen(display)
char display[25][80];
{   int i,j;
 
    for (i=0;i<25;i++,printf("\n"))
/*	for (j=0;j<79;j++)*/
    {   display[i][79] = '\0';
	    printf("%s",display[i]);
    }
}
