#include "plateau.h"
 
extern struct piece pieces[24];
extern struct square board[4][4];
 
/*  Disk file functions  */
 
FILE *open_gamefile();
void write_position();
void read_position();
void list_gameinfo();
void update_gameinfo();
void write_gameinfo();
struct gameinfo *read_gameinfo();
 
FILE *open_gamefile(filename)
char filename[];
{   FILE *fptr;
    if ((fptr = fopen(filename,"r+")) == NULL)
	{	printf("That file cannot be opened.\n");
		exit(1);
    }
    return fptr;
}
 
void write_position(fptr)
FILE *fptr;
{
    int i,j;
 
    for (i=0;i<24;i++)
    {	fprintf(fptr,"%02d %02d %02d %02d %02d %02d %02d\n",
	    pieces[i].top,pieces[i].bottom,pieces[i].value,
	    pieces[i].status,pieces[i].link,pieces[i].revealed,
	    pieces[i].knowninfo);
    }
 
    for (i=0;i<4;i++)
	for (j=0;j<4;j++)
	    fprintf(fptr,"%02d %02d\n",board[i][j].stackheight,
		board[i][j].link);
}
 
void read_position(game,fptr)
struct gameinfo *game;
FILE *fptr;
{   char buffer[80];
    char flag = 'n';
    int i,j;
    struct gameinfo tempgame;
    FILE *gptr;
    
    /*tempgame.moveno = game->moveno;*/
    strcpy(tempgame.opp_address,game->opp_address);
    tempgame.color = game->color;
    if (fseek(fptr,(long)0,0) == -1)
    {   printf("Error: Cannot read game position\n");
	exit(2);
    }
  while (1)
  {
    while (fgets(buffer,80,fptr) != NULL &&
		 strstr(buffer,"PLATEAU!") == NULL);
   
    if (strstr(buffer,"PLATEAU!") != NULL)
    {
        parse_header(&tempgame,buffer);
	if (tempgame.moveno > game->moveno && tempgame.status == 'p')
	{   if (flag == 'y')
	        return;
	    else
	    {   printf("%d,%d,%c\n",tempgame.moveno,game->moveno,flag);
	 	printf("Board position not found.\n");
		exit(0);
	    }
        }
	if (tempgame.moveno != game->moveno)
	    continue;
	    if (fgets(buffer,80,fptr) == NULL)
	    	printf("Disaster strikes\n");
	    if (strstr(buffer,"-----") == NULL)
	    {   fputs(buffer,stdout);
	        printf("Error: corrupted game file\n");
	        exit(2);
	    }
 
            for (i=0;i<24;i++)
    	    {   fgets(buffer,80,fptr);
		pieces[i].top = atoi(strtok(buffer," "));
		pieces[i].bottom = atoi(strtok(NULL," "));
		pieces[i].value = atoi(strtok(NULL," "));
		pieces[i].status = atoi(strtok(NULL," "));
		pieces[i].link = atoi(strtok(NULL," "));
		pieces[i].revealed = atoi(strtok(NULL," "));
		pieces[i].knowninfo = atoi(strtok(NULL,"\n"));
    	    }
	
    	    for (i=0;i<4;i++)
  		for (j=0;j<4;j++)
		{   fgets(buffer,80,fptr);
		    board[i][j].stackheight = atoi(strtok(buffer," "));
		    board[i][j].link = atoi(strtok(NULL,"\n"));
 		}
 
	    if (tempgame.comments == 'y')
	        if ((gptr = fopen("comfile","w")) == NULL)
	        {   printf("Cannot open comment file.\n");
	  	    exit(3);
	        }
		else
		{   do
		    {   fgets(buffer,80,fptr);
			if (strstr(buffer,"---") == NULL)
			    fputs(buffer,gptr);
		    } while (strstr(buffer,"---") == NULL);
		    fclose(gptr);
		}
	    flag = 'y';
	    cpstruct(tempgame,game);
    }
    else 
    {   if (flag == 'y')
	    return;
	else
  	{   printf("Board position not found.\n");
	    exit(2);
	}
    }
  }
}
 
void list_gameinfo()
{   FILE *fptr;
    struct gameinfo game;
    char tptr[10];
 
    recmoves();
    if ((fptr = fopen("board.cfg","r")) == NULL)
    {	printf("I can't find your 'board.cfg' file!\n");
	printf("Would you like to create one? (y/n) ");
	fgets(tptr,10,stdin);
	if (tolower(*tptr) == 'y')
	{   fptr = fopen("board.cfg","w");
	    fputc(EOF,fptr);
	    fclose(fptr);
	    printf("Board.cfg file created.\n");
	    fptr = fopen("board.cfg","r");
	}
	else
	{   printf("Exiting program...\n");
	    exit();
	} 
    }
 
    printf("\n\nGames on file:\n\n");
    printf("Gamename  Opponent                               ");
    printf(" Color  Moves  Status\n");
    printf("--------  --------                               ");
    printf(" -----  -----  ------\n");
 
    while (read_gameinfo(&game,fptr) != NULL)
    {   if (game.status != 'x')	
	{   color_to_txt(game.color,tptr);
	    printf("%-8s  %-40s%5s   %3d   ",game.name, game.opp_address,
		tptr,game.moveno);
	}
	if (game.status == 'p')
	    printf("In progress\n");
	if (game.status == 'w')
	    printf("White won\n");
	if (game.status == 'b')
	    printf("Black won\n");
	if (game.status == 'o')
	    printf("Pris. Exchange\n");
    }
    fclose(fptr);
}
 
struct gameinfo *read_gameinfo(game,fptr)
struct gameinfo *game;
FILE *fptr;
{   char buffer[80];
    char *cptr;
 
    if (fgets(buffer,80,fptr) == NULL)
    	return (NULL);
 
    if ((cptr = strtok(buffer,":")) != NULL)
    {	strcpy(game->name,cptr);
	if ((cptr = strtok(NULL,":")) != NULL)
	{   strcpy(game->opp_address,cptr);
	    if ((cptr = strtok(NULL,":")) != NULL)
	    {	if (strcmp(cptr,"black") == 0)
		    game->color = black;
		else
		    game->color = white;
		if ((cptr = strtok(NULL,":")) != NULL)
		{   if (isdigit(*cptr))
		    {	game->moveno = atoi(cptr);
			if ((cptr = strtok(NULL,":")) != NULL)
			{   game->status = *cptr;
			    return game;
			}
		    }
		}
	    }
	}
    }
    /*fprintf(stderr,"Possibly corrupt entry.\n");*/
    return (read_gameinfo(game,fptr));
}
 
void update_gameinfo(game,delflag)
struct gameinfo *game;
int delflag;
{   FILE *fptr,*gptr;
    struct gameinfo readgame;
 
    if ((fptr = fopen("board.cfg","r")) == NULL)
    {   scroll();
	drawline("Cannot open file for reading.");
	exit(3);
    }
    if ((gptr = fopen("board.cf2","w")) == NULL)
    {   scroll();
	drawline("Cannot open file for writing.");
	exit(4);
    }
 
    while (read_gameinfo(&readgame,fptr) != NULL)
    {	if (strcmp(readgame.name,game->name) == 0)
	{   if (delflag == 0)
		write_gameinfo(game,gptr);
	}
	else
	    write_gameinfo(&readgame,gptr);
    }
    fputc(EOF,gptr);
    fclose(fptr);
    fclose(gptr);
#ifndef DOS
    system("mv board.cf2 board.cfg");
#else
   system("copy board.cf2 board.cfg");
   system("del board.cf2");
#endif
}
 
void write_gameinfo(game,fptr)
struct gameinfo *game;
FILE *fptr;
{   char tptr[10];
	
	color_to_txt(game->color,tptr);
 
    fprintf(fptr,"%s:%s:%s:%d:%c:\n",game->name,game->opp_address,
		tptr,game->moveno,game->status);
}
