/*************************************************************************
  char *strblk(string)
               char *

  removes leading and trailing white space from strings of arbitrary
  length.  returns a pointer to the string that is the same as the
  pointer passed to it as an argument.

  hard to believe that there is no standard C function to do this ...
*************************************************************************/
#include <string.h>

#ifndef NULL
#define NULL 0L
#endif

char *strblk(string)
char *string;
  {
    long length;

    if(string == NULL) return(string);
    length = strlen(string);
    if(length != 0)
      { /* not null string */
        /* remove trailing white space */
        while(length > 0)
          {
            if(isspace(string[length - 1])) length--;
            else break;
          }
        string[length] = '\0';
        /* reverse the string */
        strrev(string);
        /* remove trailing white space from reversed string */
        while(length > 0)
          {
            if(isspace(string[length - 1])) length--;
            else break;
          }
        string[length] = '\0';
        /* reverse the string back */
        strrev(string);
      } /* not null string */
    return(string);
  } /* end of strblk() */
