/*************************************************************************
Legends Soldier Calculator
Copyright (c) 1994 by Mark R. Nuiver.  All rights reserved.

Header Name      => lsc.h
Version          => 4.0.0
Change Date      => 94/02/22
Programmer       => M.R. Nuiver
Operating System => AmigaDOS 3.00                  MS-DOS 6.0
Compiler         => SAS/C 5.10                     Power C 2.0.0

Revision Notes

Version Date      Programmer      Reason
------- --------  --------------  ---------------------------------------
4.0.0   94/02/22  Mark Nuiver     * Added TAI (Air) as terrain #15, made
                                    TCO (Confined) terrain #16, removed
                                    TWI (Winternight).  TAI is being treated
                                    as a "basic" terrain, and now there are
                                    no special terrains in use.
4.0.0   94/01/17  Mark Nuiver     * Added MAXAFB, etc symbols.
4.0.0   94/01/08  Mark Nuiver     * Added weapon class "Other".
4.0.0   94/01/02  Mark Nuiver     * Added enum reserve_options.
4.0.0   93/12/27  Mark Nuiver     * Added LASTCFIELD, terrain_symbols,
                                    fort_symbols, losses_symbols,
                                    reserve_symbols, Reserve[], Losses[],
                                    removed TER1, TER2, TER3, adjusted array
                                    sizes.
                                  * Added terrain bit masks.
                                  * Removed MAXTERRAIN symbol.
                                  * Added reserve option bit masks.
4.0.0   93/12/22  Mark Nuiver     * Added Terrain[] to legion_struct.
                                  * Added terrain symbols.
                                  * Increased LINESIZE to 255.
4.0.0   93/12/21  Mark Nuiver     * Changed version.
                                  * Removed claymore and dart/shortsword as
                                    weapon classes.
                                  * Removed TAC symbol, which was never
                                    used and probably never will be.
                                  * Removed SPC symbol, which has been made
                                    obsolete in this version.
                                  * Added OVER symbol.
                                  * Added GWC, GWB, SWID, SWB, BWID symbols.
------- --------  --------------  ---------------------------------------
3.0.1   93/12/19  Mark Nuiver     * Added LONGWIDTH symbol.
                                  * Expanded most column widths.
                                  * Increased OUTLINESIZE to 132.
                                  * Removed CLASSSIZE symbol.
                                  * Changed all int to short, made Forts
                                    short.
------- --------  --------------  ---------------------------------------
3.0     93/12/12  Mark Nuiver     * Added DAM and INV.
3.0     93/12/11  Mark Nuiver     * Revised slot_struct and added
                                    legion_struct structure i/c/w changes
                                    for LBS.
------- --------  --------------  ---------------------------------------
2.1     This version was not released.
2.1     93/12/07  Mark Nuiver     * Changed column width of AF, MAF, CAF to
                                    six digits.
2.1     93/11/24  Mark Nuiver     * Changed header version number.
------- --------  --------------  ---------------------------------------
2.0     93/03/09  Mark Nuiver     * Changed header version number.
                                  * Added SAFB (Surprise Missile Attack
                                    Factor Bonus) symbol to lsc_symbol.
                                  * Deleted obsolete defines for item
                                    arrays; they haven't been used for a
                                    few versions.  Only the data for items
                                    being used is actually loaded.
                                  * Deleted ERROR_TOO_MUCH_DATA symbol;
                                    see above.
                                  * Added defines for weapon class character
                                    codes and bit masks and removed
                                    ItemClass char array from slot_struct.
*************************************************************************/
#ifndef LSC_H
#define LSC_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#define LINESIZE                  255     /* maximum length of input line */
#define DESCSIZE                  20      /* size of description fields */
#define MAXSLOTS                  9       /* number of legion slots */
#define MAXSSLOTS                 8       /* number of soldier slots */
#define MAXCSLOTS          MAXSLOTS       /* number of character slots */
#define MAXNOTES                  20      /* size of Notes array */
#define NOTESIZE                  127     /* length of Notes text */
#define OUTLINESIZE               132     /* length of output lines */

/* maximum/minimum AFB and MAFB */
#define MAXAFB  400
#define MINAFB  -80
#define MAXMAFB 500
#define MINMAFB -80

/* string size to hold maximum sized long integer + null */
#define LONGWIDTH                 13

/* the following defines are for the positions and widths of output */
#define SLTPOS                    0       /* slot position */
#define SLTWIDTH                  3       /* slot width */
#define AMTPOS    SLTPOS + SLTWIDTH + 1   /* amount position */
#define AMTWIDTH                  5       /* amount width */
#define DESCPOS   AMTPOS + AMTWIDTH + 1   /* description position */
#define DESCWIDTH          DESCSIZE       /* description width */
#define TEXTWIDTH   DESCPOS + DESCWIDTH   /* totals text */
#define CFPOS     DESCPOS + DESCWIDTH + 1 /* combat factor position */
#define CFWIDTH                   7       /* combat factor width */
#define DFPOS     CFPOS + CFWIDTH + 1     /* defense factor position */
#define DFWIDTH                   4       /* defense factor width */
#define AFPOS     DFPOS + DFWIDTH + 1     /* attack factor position */
#define AFWIDTH                   8       /* attack factor width */
#define MAFPOS    AFPOS + AFWIDTH + 1     /* missile af position */
#define MAFWIDTH                  8       /* missile af width */
#define CAFPOS    MAFPOS + MAFWIDTH + 1   /* charge af position */
#define CAFWIDTH                  8       /* charge af width */
#define MAVPOS    CAFPOS + CAFWIDTH + 1   /* magical attack value position */
#define MAVWIDTH                  4       /* magical attack value width */
#define SAVPOS    MAVPOS + MAVWIDTH + 1   /* special attack value position */
#define SAVWIDTH                  7       /* special attack value width */
#define MADPOS    SAVPOS + SAVWIDTH + 1   /* magical attack defense pos */
#define MADWIDTH                  3       /* magical attack defense width  */
#define SADPOS    MADPOS + MADWIDTH + 1   /* special attack defense pos */
#define SADWIDTH                  3       /* special attack defense width */
#define DAMPOS    SADPOS + SADWIDTH + 1   /* DAM position */
#define DAMWIDTH                  3       /* DAM width */
#define INVPOS    DAMPOS + DAMWIDTH + 1   /* INV position */
#define INVWIDTH                  3       /* INV width */

/* weapon class character codes */
#define W_SWORD             'S'           /* weapon is a Sword */
#define W_AXE               'A'           /* weapon is an Axe */
#define W_BOW               'B'           /* weapon is a Bow */
#define W_OTHER             'U'           /* weapon is 'Other' */
#define W_2HANDED           '2'           /* 2-handed weapon, no shield */
#define W_MISSILE           'R'           /* weapon has missile attack */
#define W_MOUNT             'M'           /* weapon usable with warmount */
#define W_MOUNT_ONLY        'O'           /* weapon requires warmount */

/* weapon class bit masks */
#define M_SWORD             0x0001         /* weapon is a Sword */
#define M_AXE               0x0002         /* weapon is an Axe */
#define M_BOW               0x0004         /* weapon is a Bow */
#define M_OTHER             0x0008          /* weapon is 'Other' */
#define M_2HANDED           0x0020         /* 2-handed weapon, no shield */
#define M_MISSILE           0x0040         /* weapon has missile attack */
#define M_MOUNT             0x0080         /* weapon usable with warmount */
#define M_MOUNT_ONLY        0x0100         /* weapon requires warmount */

/* terrain bit masks (1 << (terrain code - 1)) */
#define M_T_BASIC           0xE7FF        /* valid basic terrain entries */
#define M_T_WALLS           0x1800        /* valid walls terrain */
#define M_T_SPECIAL         0x0000        /* valid special terrain */

/* reserve option bit masks (1 << (reserve option - 1) */
#define M_R_NOFORTS         0x0703        /* RO that don't get forts bonus */
#define M_R_NODEFEND        0x2800        /* RO invalid defending forts */
#define M_R_NOATTACK        0x1703        /* RO invalid attacking forts */
#define M_R_NOLEFT          0x0462        /* RO invalid for Left Reserve */
#define M_R_NOCENTER        0x0047        /* RO invalid for Center Reserve */
#define M_R_NORIGHT         0x010D        /* RO invalid for Right Reserve */

/* the names of all the tables */
#define RACETABLE       "RACES.LSC"       /* Racial data file name */
#define TYPETABLE       "TYPES.LSC"       /* Training types data file */
#define STATUSTABLE     "STATUS.LSC"      /* Special statuses data file */
#define WEAPONTABLE     "WEAPONS.LSC"     /* Weapons data file name */
#define ARMORTABLE      "ARMOR.LSC"       /* Armor data file name */
#define SHIELDTABLE     "SHIELDS.LSC"     /* Shields data file name */
#define MOUNTTABLE      "MOUNTS.LSC"      /* Warmounts data file name */

enum table_type
  {
    /*
      This serves two purposes.  The symbols up to LASTTABLE enumerate
      the types of tables.  All of the symbols together define the fields
      that are input from the legion description file for Soldiers.
    */
    RACE,
    TYPE,
    STATUS,
    WEAPON,
    ARMOR,
    SHIELD,
    MOUNT,
    LASTTABLE,                        /* this symbol must follow all */
                                      /* the table type symbols */
    AMT,                              /* AMounT of soldiers in slot */
    TRL,                              /* soldiers's TRaining Level */
    MOR,                              /* soldiers's MORale */
    LASTSFIELD                        /* this symbol must be last! */
  };

enum lsc_symbols
  {
    /*
      These are all the things lsc manipulates to do its calculations.
    */
    ID,                               /* item ID */
    CF,                               /* Combat Factor */
    DF,                               /* Defense Factor */
    AF,                               /* Attack Factor */
    AFB,                              /* Attack Factor Bonus */
    MAF,                              /* Missile Attack Factor */
    MAFB,                             /* Missile Attack Factor Bonus */
    SAFB,                             /* Surprise Round MAFB */
    CAF,                              /* Charge Attack Factor */
    CAFB,                             /* Charge Attack Factor Bonus */
    RAFB,                             /* Rout Attack Factor Bonus */
    WAFB,                             /* Mounted (warmount) AFB */
    MAV,                              /* Magical Attack Value */
    SAV,                              /* Special Attack Value */
    MAD,                              /* Magical Attack Defense */
    SAD,                              /* Special Attack Defense */
    DAM,                              /* DAM rating */
    INV,                              /* INV rating */
    MORB,                             /* MORale Bonus */
    OVER,                             /* Overall modifiers */
    GWC,                              /* General Weapon Code */
    GWB,                              /* General Weapon Bonus */
    SWID,                             /* Specific Weapon ID */
    SWB,                              /* Specific Weapon Bonus */
    BWID,                             /* Base Weapon ID */
    DESC,                             /* DESCription */
    CLASS,                            /* weapon CLASS */
    LASTCFIELD,                       /* end of calculated fields */
    /* Terrain Item Modifiers, must be in correct order */
    TBEGIN,                           /* MUST precede terrain fields */
    TGR,                              /* Grassland */
    TFO,                              /* Forest */
    THF,                              /* Heavy Forest */
    TFH,                              /* Forest Hills */
    TFM,                              /* Forest Mountains */
    TBH,                              /* Barren Hills */
    TBM,                              /* Barren Mountains */
    TMO,                              /* Moors */
    TSW,                              /* Swamp */
    TDE,                              /* Desert */
    TSE,                              /* Sea */
    TDW,                              /* Defending Walls */
    TAW,                              /* Attacking Walls */
    TCI,                              /* City */
    TAI,                              /* Air */
    TCO,                              /* Confined */
    TEND,                             /* MUST follow terrain symbols */
    LASTFIELD                         /* this field must be last! */
  }; /* lsc_symbols */

enum lsc_errors
  {
    ERROR_NO_ERROR,
    ERROR_NO_FILE,
    ERROR_NO_DATA,
    ERROR_BAD_DATA
  };

enum terrain_symbols
  {
    T_BASIC,                          /* basic terrain */
    T_WALLS,                          /* walls terrain */
    T_SPECIAL,                        /* special terrain */
    LASTTERRAIN                       /* must be last! */
  };

enum forts_symbols
  {
    F_DF,                             /* fortifications DF bonus */
    F_MORB,                           /* fortifications morale bonus */
    F_AFB,                            /* fortifications AFB */
    F_OVER,                           /* fortifications overall modifier */
    LASTFORTS                         /* must be last! */
  };

enum reserve_options
  {
    RO_BEGIN,
    RO_FLANK_LEFT,
    RO_FLANK_RIGHT,
    RO_SUPPORT_LEFT_FLANK,
    RO_SUPPORT_LEFT_CENTER,
    RO_SUPPORT_CENTER,
    RO_SUPPORT_RIGHT_CENTER,
    RO_SUPPORT_RIGHT_FLANK,
    RO_TACTICAL_RESERVE,
    RO_CHARGE_LEFT,
    RO_CHARGE_CENTER,
    RO_CHARGE_RIGHT,
    RO_COUNTERCHARGE,
    RO_OPPORTUNITY_CHARGE,
    RO_STRATEGIC_RESERVE,
    RO_END
  };

enum reserve_symbols
  {
    R_LEFT,                           /* left reserve option */
    R_CENTER,                         /* center reserve option */
    R_RIGHT,                          /* right reserve option */
    LASTRESERVE                       /* must be last! */
  };

enum losses_symbols
  {
    L_LOSSES,                         /* percent acceptable losses */
    LASTLOSSES                        /* must be last! */
  };

struct slot_struct
  {
    short SoldierItems[LASTSFIELD]; /* soldier data from legion file */
    short Character[LASTCFIELD]; /* character data from legion file */
    char CharacterDesc[DESCSIZE + 1]; /* character description */
    short Item[LASTTABLE][LASTFIELD]; /* item data from data files */
    char ItemDesc[LASTTABLE][DESCSIZE + 1]; /* item description */
    long Total[LASTCFIELD]; /* slot totals (computed) */
  };

struct legion_struct
  {
    struct slot_struct Slot[MAXSLOTS + 1]; /* array of input slot data */
    short Forts[LASTFORTS]; /* force fortifications bonuses */
    short Terrain[LASTTERRAIN]; /* Legion terrain types in effect */
    short Reserve[LASTRESERVE]; /* Legion Reserve Options */
    short Losses[LASTLOSSES]; /* Legion Acceptable Losses */
  };

#endif LSC_H
