/*************************************************************************
Legends Battle Simulator
Copyright (c) 1994 by Mark R. Nuiver.  All rights reserved.

Header Name      => lbs.h
Version          => 2.0.0
Change Date      => 94/01/10
Programmer       => M.R. Nuiver
Operating System => AmigaDOS 3.00                  MS-DOS 6.0
Compiler         => SAS/C 5.10                     Power C 2.0.0

Revision Notes

Version Date      Programmer      Reason
------- --------  --------------  ---------------------------------------
2.0.0   94/01/10  Mark Nuiver     * Added EVENT_CHARGE_EVENTS.
2.0.0   94/01/01  Mark Nuiver     * Added ROUND symbols.
                                  * Added EVENT symbols.
2.0.0   93/12/28  Mark Nuiver     * Changed structures for 14 battlefield
                                    position system.
                                  * Added MAXBP and STATUS symbols.
2.0.0   93/12/21  Mark Nuiver     * Changed version.
------- --------  --------------  ---------------------------------------
1.0.1   93/12/19  Mark Nuiver     * Changed version.
*************************************************************************/
#ifndef LBS_H
#define LBS_H

#include "lsc.h"

#define ATTACKER     0
#define DEFENDER     1
#define MAXBP       14                        /* Battlefield Positions */

/* Soldier and Character END-OF-ROUND status */
#define STATUS_OK    0
#define STATUS_DEAD  1
#define STATUS_GONE  2

#define MAXROUNDS     13
#define ROUND_MAGIC   1
#define ROUND_SPECIAL (ROUND_MAGIC + 1)
#define ROUND_MISSILE (ROUND_SPECIAL + 1)
#define ROUND_CHARGE  (ROUND_MISSILE + 1)
#define ROUND_MELEE2  (ROUND_CHARGE + 1)

/* Slot events during the round (bit masks) */
#define EVENT_FLANK          0x0001         /* reserve flank move */
#define EVENT_CHARGE         0x0002         /* reserve charge move */
#define EVENT_REPLACE        0x0004         /* reserve tactical move */
#define EVENT_COUNTER        0x0008         /* reserve countercharge */
#define EVENT_OPPORTUNITY    0x0010         /* reserve opportunity charge */
#define EVENT_WITHDRAW       0x0020         /* slot withdraws */
#define EVENT_ROUT           0x0040         /* soldiers rout */
#define EVENT_CHARACTER_ROUT 0x0080         /* character routs */
#define EVENT_DIE            0x0100         /* soldiers die */
#define EVENT_CHARACTER_DIE  0x0200         /* character dies */
#define EVENT_STICKY         (EVENT_ROUT)
#define EVENT_CHARGE_EVENTS  (EVENT_CHARGE|EVENT_OPPORTUNITY|EVENT_COUNTER)

struct attack_struct
  {
    short Target[2];                        /* target slots for attack */
    long SoldierAttack[2];                  /* raw damage to target slots */
    long CharacterAttack[2];
    long SoldierDamage;                   /* accrued damage */
    long CharacterDamage;
    short SoldierStatus;
    short CharacterStatus;
    long Event;                             /* slot events */
  };

struct round_struct
  {
    struct attack_struct Slot[MAXSLOTS];
    short Battlefield[MAXBP + 1];             /* slot battlefield positions*/
  };

struct battle_struct
  {
    struct round_struct Round[MAXROUNDS + 1];
  };

#endif
