#!/bin/sh
###
###
### This is a script that uses SENDMAIL to mail reports out.  This is done
### to provide maximul flexability.  Your machine and version of SENDMAIL
### may require to you tweak the settings below.  Information regarding this
### will be provided as it becomes available.
###
###

## Settings!  Don't overlook!

#
# Option to include notice file for a particular turn:
#
# Put a file called "Game.1.notice" in the directory where this
# script is executed.  NOTE that "Game" must be capitalized.
#

NOTICEDIR=notices
BULLETIN=$NOTICEDIR/global.bulletin
INFO=$NOTICEDIR/$1.info
NOTICE=$NOTICEDIR/$1.$2.notice
GNOTICE=$NOTICEDIR/$2.notice

# Tempfile.  Make sure path is ok.

TEMPFILE=/tmp/galaxy.$1.$2.mail.temp

#
# Your sendmail command and the appropriate flags.
#  -ba = ARPANET header parsing
#  -t  = Parse To: header
#  -oi = Immediate processing.  This could be changed to queue or
#        background depending on how you want to do things.  
#

SENDMAIL="/usr/lib/sendmail -ba -t -oi"

# Info.  Lets not put any bogus stuff in here or someone won't be happy!

FROM="galaxy@acca.nmsu.edu (Galaxy Engine)"
REPLY_TO=galaxy@acca.nmsu.edu
SENDER=beast@acca.nmsu.edu

##
## Arguments to mail_reports:
##
## $1 - Name of the game to mail reports for.
## $2 - Turn Number
## $3 - Race Name
## $4 - Address
## 

SUBJECT="Galaxy Game $1 Turn $2 Report for $3"
BTITLE="Bulletins for Galaxy Game $1 Turn $2"

## Report comes through stdin.  Think of it as a birth canal.

rm -f $TEMPFILE

echo \
"To:" $4 "("$3")
From:" $FROM "
Reply-To:" $REPLY_TO "
Sender:" $SENDER "
Subject:" $SUBJECT "


		"$BTITLE"

" > $TEMPFILE

if test -r $NOTICE; then echo $1" NOTICE
" >>$TEMPFILE; \
   cat $NOTICE >> $TEMPFILE; \
   echo "
" >> $TEMPFILE;
fi
if test -r $GNOTICE; then  \
   cat $GNOTICE >> $TEMPFILE; \
   echo "
" >> $TEMPFILE;
fi
if test -r $BULLETIN; then echo "NOTES
" >>$TEMPFILE; \
   cat $BULLETIN >> $TEMPFILE; \
   echo "
" >> $TEMPFILE;
fi
if test -r $INFO; then echo $1" INFO
" >>$TEMPFILE; \
   cat $INFO >> $TEMPFILE; \
   echo "
" >> $TEMPFILE;
fi
cat $TEMPFILE - | $SENDMAIL

rm -f $TEMPFILE
