#include "galaxy.h"
#include "copyright.h"

/* This file contains savegame() and the support functions.
   Requires functions from util.c as well */

/* internal globals */

int             indent;
int             comma;

/* internal functions for savegame() */

void     docomma _PROTO((void));
void     wi _PROTO((int n));
void     wf _PROTO((double n));
void     ws _PROTO((char *s));
void     nl _PROTO((void));
void     cb _PROTO((void));



#ifdef __STDC__
void 
cb (void)
#else
void 
cb ()
#endif
{
   indent--;
   nl();
   ws("@");
}

#ifdef __STDC__
void 
docomma (void)
#else
void 
docomma ()
#endif
{
   if (comma)
      fputc(',', f);
   comma = 1;
}

#ifdef __STDC__
void 
wi (int n)
#else
void 
wi (n)
int n;
#endif
{
   docomma();
   if (n)
      fprintf(f, "%d", n);
}

#ifdef __STDC__
void 
wf (double n)
#else
void 
wf (n)
double n;
#endif
{
   docomma();
   sprintf(buf, "%lf", n);
   ftrunc3();
   if (strcmp(buf, "0"))
      fprintf(f, buf);
}

#ifdef __STDC__
void 
ws (char *s)
#else
void 
ws (s)
char *s;
#endif
{
   int             i;

   docomma();
   for (i = 0; s[i]; i++)
      if (s[i] == ' ')
         s[i] = '_';
   fprintf(f, "%s", s);
}

#ifdef __STDC__
void 
savegame (char *gamename)
#else
void 
savegame (gamename)
char 		  *gamename;
#endif
{
   int             i;
   planet         *p;
   player         *P;
   shiptype       *t;
   fleetname      *fl;
   alliance       *a;
   group          *g;
   battle         *b;
   participant    *r;
   bombing        *B;
   strlist        *s;


/* added a next_turn file for servers and such -RJS */

   sprintf(buf, "data/%s/next_turn",gamename);
   f = Fopen(buf, "w");
   fprintf(f,"%d",turn+1);
   fclose(f);

   sprintf(buf, "data/%s/%d", gamename, turn);
   f = Fopen(buf, "w");
/*   printf("Saving game %s turn %d...\n", gamename, turn); */

   wi(turn);
   wf(galaxysize);

   fputc('\n', f);
   for (s = messages; s; s = s->next)
      fprintf(f, "%s\n", s->s[0]);
   fputc('@', f);

   indent++;
   for (p = planets; p; p = p->next) {
      nl();
      ws(p->name);
      if (p->owner)
         ws(p->owner->name);
      else
         ws("");
      wf(p->x);
      wf(p->y);
      wf(p->size);
      wf(p->resources);
      wf(p->pop);
      wf(p->ind);
      wi(p->producing);
      if (p->producingshiptype)
         ws(p->producingshiptype->name);
      else
         ws("");
      wf(p->cap);
      wf(p->mat);
      wf(p->col);
      wf(p->inprogress);
      for (i = 0; i != MAXCARGO; i++)
         if (p->routes[i])
            ws(p->routes[i]->name);
         else
            ws("");
   }
   cb();

   indent++;
   for (P = players; P; P = P->next) {
      nl();
      ws(P->name);
      ws(P->addr);
      ws(P->pswd);
      wf(P->drive);
      wf(P->weapons);
      wf(P->shields);
      wf(P->cargo);
      wf(P->mx);
      wf(P->my);
      wf(P->msize);
      wi(P->prodtable);
      wi(P->autounload);
      wi(P->fleettables);
      wi(P->sortgroups);
      wi(P->underscores);
      wi(P->twocol);
      wi(P->namecase);
      wi(P->lastorders);

      indent++;
      for (t = P->shiptypes; t; t = t->next) {
         nl();
         ws(t->name);
         wf(t->drive);
         wi(t->attacks);
         wf(t->weapons);
         wf(t->shields);
         wf(t->cargo);
      }
      cb();

      indent++;
      for (fl = P->fleetnames; fl; fl=fl->next) {
	 nl ();
	 ws (fl->name);
      }
      cb ();

      indent++;
      for (a = P->allies; a; a = a->next) {
         nl();
         ws(a->who->name);
      }
      cb();

      indent++;
      for (g = P->groups; g; g = g->next) {
         nl();
         ws(g->type->name);
         wf(g->drive);
         wf(g->weapons);
         wf(g->shields);
         wf(g->cargo);
         wi(g->loadtype);
         wf(g->load);
         if (g->from)
            ws(g->from->name);
         else
            ws("");
         ws(g->where->name);
         wf(g->dist);
         wi(g->ships);
	 if (g->thefleet)
	    ws (g->thefleet->name);
         else
	    ws ("");
      }
      cb();

      fputc('\n', f);
      for (s = P->messages; s; s = s->next)
         fprintf(f, "%s\n", s->s[0]);
      fprintf(f, " @\n");
      for (s = P->mistakes; s; s = s->next) {
         if (getstr(s->s[0])[0] == '@')
            fputc('#', f);
         fprintf(f, "%s\n", s->s[0]);
      }
      fprintf(f, " @");
   }
   cb();

   indent++;
   for (b = battles; b; b = b->next) {
      nl();
      ws(b->where->name);

      indent++;
      for (r = b->participants; r; r = r->next) {
         nl();
         ws(r->who->name);

         indent++;
         for (g = r->groups; g; g = g->next) {
            nl();
            ws(g->type->name);
            wf(g->drive);
            wf(g->weapons);
            wf(g->shields);
            wf(g->cargo);
            wi(g->loadtype);
            wf(g->load);
            wi(g->ships);
            wi(g->left);
         }
         cb();
      }
      cb();
   }
   cb();

   indent++;
   for (B = bombings; B; B = B->next) {
      nl();
      ws(B->who->name);
      ws(B->name);
      ws(B->owner->name);
      wf(B->pop);
      wf(B->ind);
      wi(B->producing);
      if (B->producingshiptype)
         ws(B->producingshiptype->name);
      else
         ws("");
      wf(B->cap);
      wf(B->mat);
      wf(B->col);

      indent++;
      for (a = B->viewers; a; a = a->next) {
         nl();
         ws(a->who->name);
      }
      cb();
   }
   cb();

   nl();
   fclose(f);
}

