#include "copyright.h"
#include "galaxy.h"
#include "global.h"


#ifdef __STDC__
int
main(int argc,char **argv)
#else
int
main(argc,argv)
int argc;
char **argv;
#endif
{

   int i,go_process=0,tmp_file=0,game_index=0;
   char infile[81],*gamelist[MAXGAMES];

/* it's usually better to compare the index to argc I think -RJS */

   dfd = opendir(".");
   srand(0);
   for(i=0;i<MAXGAMES;i++)
      gamelist[i]=NULL;
   for(i=1;i<argc;i++){
   	switch(argv[i][0]){
	   case '-':
	      switch(argv[i][1]){
		   char inbuf[81];
		   FILE *tmp;
		   case 'f':
		   	if(++i <= argc && argv[i][0] != '-'){
			   strcpy(infile,argv[i]);
			   go_process=1;
			}
			else{
			   usage();
			   return(1);
			}
			break;
		   case 'g':
		      i++;
			while(i < argc && argv[i][0]!='-' ){
			   if(checkgame(argv[i])){
			      if((gamelist[game_index]=(char *)malloc(256*sizeof(char)))==NULL){
						printf("Malloc problem. Quitting\n");
						return(0);
					}
			      strcpy(gamelist[game_index++],argv[i]);
			   }
			   else
			      printf("Game %s not added. No such game\n",argv[i]);
			   i++;
			}
			break;
		   case '\0':

/* tmpnam() should be used here to get a temporary filename.  What if someone
   (for some odd reason) wants to run two concurrent galaxy engines in the
   same directory?  It's usually a better idea to use the established
   temporary filesystem anyway.   */

		   	if((tmp=fopen(TMPFILE,"w"))==NULL){
			   printf("Can't open temporary file\n");
			   return(1);
			}

/* my copystream() macro might come in handy here.   */

			while(fgets(inbuf,80,stdin)!=NULL)
			   fprintf(tmp,inbuf);
			fclose(tmp);
			go_process=1;
			strcpy(infile,TMPFILE);
			tmp_file=1;
			break;
		   default:
		      usage();
			return(1);
			break;
		}
	   break;
      default:
	   usage();
	   return(1);
	   break;
	}
   }
   if(go_process){
      printf("Galaxy v3.50    (E-Mail Version)\n");
      printf("Copyright 1991-1992 by Russell Wallace\n");
      printf("Copyright 1993      by the Galaxy PBeM Development Group\n");
      printf("Type ? for list of commands\n");
   	processturns(infile,gamelist);
	if(tmp_file)
	   unlink(TMPFILE);
	return(0);
   }
   else{
      randno = (unsigned long) rand();
      printf("Galaxy v3.50    (E-Mail Version)\n");
      printf("Copyright 1991-1992 by Russell Wallace\n");
      printf("Copyright 1993      by the Galaxy PBeM Development Group\n");
      printf("Type ? for list of commands\n");
	
      for (;;) {
         printf("> ");
         gets(buf);
         switch (tolower(buf[0])) {
	   case 'a':
	      addgame(gamelist);
		break;
         case 'c':
            creategame();
            break;
	   case 'd':
	      deletegame(gamelist);
		break;
         case 'g':
            giveposition();
            break;
	   case 'l':
	      listgames(gamelist);
		break;
         case 'p':
            processturns((char *)0,gamelist);
            break;
         case 'q':
            return 0;
         default:
            printf("C - Create New Game\n");
            printf("G - Give Position to New Player\n");
            printf("P - Process Game Turns\n");
				printf("Access list controls\n");
				printf("L - Show access list\n");
				printf("A - add game to list\n");
				printf("D - delete game from list\n");
            printf("Q - Quit\n");
         }
      }
   }
}
#ifdef __STDC__
void
usage(void)
#else
void
usage()
#endif
{
   printf("Usage : galaxy [-][[f filename]] [-g game1 game2 game3 ...]\n");
   printf("-\t\t: process turns from standard input\n");
   printf("-f filename\t: process turns from file filename\n");
   printf("-g game1 game2 game3 .... : Only read turns from given list\n");
}
#ifdef __STDC__
int
listgames(char *glist[MAXGAMES])
#else
int
listgames(glist)
char *glist[MAXGAMES];
#endif
{
   int i=0;
   if(glist[0]==NULL){
      printf("All games being used (no list)\n");
      return(0);
   }
   printf("\n");
   while(glist[i]){
      printf("\t%2d. %s\n",i,glist[i]);
	i++;
   }
   printf("%d entries.\n",i);
   return(i);
}
#ifdef __STDC__
void
addgame(char *glist[MAXGAMES])
#else
void
addgame(glist)
char *glist[MAXGAMES];
#endif
{
   int i;
   char str[81];
   i=listgames(glist);
   printf("Game name to add : ");
   fgets(str,80,stdin);
   if(checkgame(str)){
      if((glist[i]=(char *)malloc(256*sizeof(char)))==NULL){
         printf("Can't allocate memory\n");
	   return;
	}
      strcpy(glist[i],str);
      listgames(glist);
   }
   else{
      printf("No such game %s\n",str);
   }
}
#ifdef __STDC__
void
deletegame(char *glist[MAXGAMES])
#else
void
deletegame(glist)
char *glist[MAXGAMES];
#endif
{
   int i,d,n;
   char str[81];
   n=listgames(glist);
   printf("Number of game to delete : ");
   fgets(str,80,stdin);
   d=atoi(str);
   printf("Deleting %d. %s\n",d,glist[d]);
   for(i=d;i<MAXGAMES-1;i++){
   	if(glist[i]==NULL)break;
		if(glist[i+1]==NULL){
			i++;
			break;
		}
	strcpy(glist[i],glist[i+1]);
   }
   for(i--;i<MAXGAMES;i++)
      glist[i]=NULL;
}
#ifdef __STDC__
int
checkgame(char *str)
#else
int
checkgame(str)
char *str;
#endif
{
   char *F;
   int i=0;
   while((str[i]!='\n') && (str[i]!='\0'))
      i++;
   str[i]='\0';
   F = findfirst("data");
   while (F && F[0] == '.')
      F = findnext();
   do{
      if(!strcmp(str,F))
	   return(1);
   }while(F=findnext());
   return(0);
}
