
/*
 * Galaxy v3.41  -  UNIX Version
 *
 * Original code by Russell Wallace, ported to UNIX by Tim Myers.
 * Code reorganized, genericized, and otherwise modified by the
 * Galaxy PBeM Development Group (GPDG).
 *
 * Copyright (C) 1992 by Russell Wallace
 * Copyright (C) 1993 by the Galaxy PBeM Development Group,
 *		      All Rights Reserved
 *
 * Current Galaxy PBeM Development Group Programming contributers include:
 *
 *  - Russel Wallace, original code		(RWALLACE@vax1.tcd.ie)
 *  - Tim Myers, original UNIX port		(tmyers@unlinfo.unl.edu)
 *  - Robert Stone, GPDG Coordiantor,
 *    (some) code reorganization		(stone@athena.cs.uga.edu)
 *  - Mayan Moudgill, code reorganization,
 *    traditional C dialect conversion,
 *    ANSI prototypes, misc. cleaning		(moudgill@cs.cornell.edu)
 *  - Graeme Griffiths, argv parsing, bugs
 *    fixed.					(graeme@abekrd.co.uk)
 *  - Added fleet commands                      (k.pankhurst@ic.ac.uk)
 *    
 *
 * LICENSING NOTICE
 * 
 * This program may be freely distributed, and used to run free games over
 * electronic media. It may not be sold or used commercially without prior
 * written permission from the Galaxy PBeM Development Group (which
 * consists of all the contributers listed above.)
 * 
 */

/* 
   Copyright note:  ALL of the files in this distribution are copyrighted
   by the GPDG.  Just to make sure this is clear, and to satisify some
   silly laws in certain places, you may see the line

   #include <copyright.h>

   In all of the C files.  This is just to make it quite clear what the
   situation is so that no lawyers get any funny ideas.
*/

#include   <stdio.h>
#include   <stdlib.h>
#include   <string.h>
#include   <math.h>
#include   <fcntl.h>
#include   <dirent.h>
#include   <ctype.h>
#include   <assert.h>
#include   <memory.h>

#define   TMPFILE     "stdin.tmp"
#define MAX_PATH   1024
#define   NAMESIZE   21
#define   MAXPOP      1000.0
#define   POPPERCOL   8
#define   POPINC      .08
#define   INDPERSHIP   10
#define   INDPERCAP   5
#define   BATTLEMAGIC   3.107232506
#define   DRIVEMAGIC   20.0
#define   FIELDSPACE   2
#define   COLUMNSPACE   4
#define   PRINTWIDTH   80
#define   ADDRSIZE   61
#define   ORDERGAP   3
#define   MAPWIDTH   PRINTWIDTH
#define   MAPHEIGHT   40
#define   MAXGAMES   20

#define   addlist2(l,p)   (*l = p, l = &p->next)
#define   identify(a,b)   nametop(a,b)

enum {
   PR_CAP,
   PR_MAT,
   PR_SHIP,
   PR_DRIVE,
   PR_WEAPONS,
   PR_SHIELDS,
   PR_CARGO,
};

enum {
   CG_CAP,
   CG_MAT,
   CG_COL,
   CG_EMPTY,
   MAXCARGO
};

typedef struct list {
   struct list    *next;
}               list;

typedef struct strlist {
   struct strlist *next;
   char           *s[1];
}               strlist;

struct player;
typedef struct player player;

typedef struct fleetname {
        struct fleetname *next;
        char name[NAMESIZE];
        float fleetspeed;
}               fleetname;

typedef struct shiptype {
   struct shiptype *next;
   char            name[NAMESIZE];
   double          drive;
   int             attacks;
   double          weapons;
   double          shields;
   double          cargo;
   int             flag;
}               shiptype;

typedef struct planet {
   struct planet  *next;
   char            name[NAMESIZE];
   player         *owner;
   double          x, y;
   double          size;
   double          resources;
   double          pop;
   double          ind;
   int             producing;
   shiptype       *producingshiptype;
   double          cap;
   double          mat;
   double          col;
   double          inprogress;
   double          spent;
   struct planet  *routes[MAXCARGO];
}               planet;

typedef struct Aplanet {
   struct Aplanet *next;
   planet         *p;
   char            ownername[NAMESIZE];
   char            producingshiptypename[NAMESIZE];
   char            routenames[MAXCARGO][NAMESIZE];
}               Aplanet;

typedef struct group {
   struct group   *next;
   shiptype       *type;
   double          drive;
   double          weapons;
   double          shields;
   double          cargo;
   int             loadtype;
   double          load;
   planet         *from;
   planet         *where;
   double          dist;
   int             ships;
   int             left;
   fleetname	  *thefleet;
   struct group   *alias;
}               group;

typedef struct alliance {
   struct alliance *next;
   player         *who;
}               alliance;

typedef struct Aalliance {
   struct Aalliance *next;
   alliance       *a;
   char            whoname[NAMESIZE];
}               Aalliance;

typedef struct participant {
   struct participant *next;
   player         *who;
   group          *groups;
}               participant;

typedef struct battle {
   struct battle  *next;
   planet         *where;
   participant    *participants;
}               battle;

typedef struct bombing {
   struct bombing *next;
   char            name[NAMESIZE];
   player         *owner;
   double          pop;
   double          ind;
   int             producing;
   shiptype       *producingshiptype;
   double          cap;
   double          mat;
   double          col;
   player         *who;
   alliance       *viewers;
}               bombing;

struct player {
   player         *next;
   char            name[NAMESIZE];
   char            addr[ADDRSIZE];
   char            pswd[NAMESIZE];
   int             pswdstate;
   double          drive;
   double          weapons;
   double          shields;
   double          cargo;
   fleetname	  *fleetnames;
   shiptype       *shiptypes;
   alliance       *allies;
   group          *groups;
   double          mx, my, msize;
   int             fleettables;
   int             underscores;
   int             twocol;
   int             namecase;
   int             lastorders;
   strlist        *orders;
   strlist        *messages;
   strlist        *mistakes;
};

extern
struct dirent  *dp;
extern
DIR            *dfd;
extern
player         *players;
extern
planet         *planets;
extern
battle         *battles;
extern
bombing        *bombings;
extern
strlist        *messages;
extern
double          galaxysize;
extern
int             turn;
extern
unsigned long   randno;
extern
char            map[MAPWIDTH][MAPHEIGHT];
extern
char            buf[256];
extern
char            gamename[256];
extern
FILE           *f;
extern
double          x1, x2, tmpy1, y2;
extern
int             underscores;
extern
int             twocol;
extern
int             reportfileno;

extern
char           *productname[];

#ifdef __STDC__
/* this is for an ANSI-C compiler */
#define _PROTO(x) x
#else
/* this is for a non-ANSI compiler */
#define _PROTO(x) ()
#endif

#include "proto.h"

