/**************************************************************
 * PLANET.H                  Copyright (C) Damian Walker 1997 *
 *------------------------------------------------------------*
 * AstroWar 1.00 - Planet database library header file.       *
 *------------------------------------------------------------*
 * Author   Damian G Walker                                   *
 * Date     28-Apr-97                                         *
 **************************************************************/


#ifndef _PLANET_H_
#define _PLANET_H_


/* enumerated types *******************************************/


/* planet index */
typedef enum {
    P_NONE, /* read without index */
    P_NAME, /* planet name index */
    P_LAST  /* placeholder */
} pindex;


/* structures & prototypes ************************************/


#ifndef _PLANET_C_

typedef void planet; /* hidden join request */

/* planet_open() - open planet files */
result planet_open(char *path);

/* planet_create() - create planet files */
result planet_create(char *path);

/* planet_close() - close planet files */
result planet_close(void);

/* planet_new() - allocate memory for new planet record */
planet *planet_new(void);

/* planet_old() - free memory for new planet record */
void planet_old(planet *p);

/* planet_clear() - clear details from existing planet record */
void planet_clear(planet *p);

/* planet_setname() - set the planet name */
char *planet_setname(planet *p, char *name);

/* planet_getname() - return the planet name */
char *planet_getname(char *name, planet *p);

/* planet_setowner() - set the owner */
char *planet_setowner(planet *p, char *owner);

/* planet_getowner() - return the owner */
char *planet_getowner(char *owner, planet *p);

/* planet_setpos() - set planet position */
pos planet_setpos(planet *p, pos pp);

/* planet_getpos() - return the planet position */
pos planet_getpos(planet *p);

/* planet_setprod() - set the planet production */
short planet_setprod(planet *p, short prod);

/* planet_getprod() - return the planet production */
short planet_getprod(planet *p);

/* planet_setships() - set the ships in orbit */
long planet_setships(planet *p, long ships);

/* planet_getships() - return the ships in orbit */
long planet_getships(planet *p);

/* planet_setscouted() - set the scouted flag */
int planet_setscouted(planet *p, int scouted);

/* planet_getscouted() - return the scouted flag */
int planet_getscouted(planet *p);

/* planet_write() - write a record */
result planet_write(planet *p);

/* planet_first() - read the first record */
result planet_first(planet *p, pindex inum);

/* planet_next() - read the next record */
result planet_next(planet *p, pindex inum);

/* planet_prev() - read the previous record */
result planet_prev(planet *p, pindex inum);

/* planet_last() - read the last record */
result planet_last(planet *p, pindex inum);

/* planet_find() - find a record by trans or name */
result planet_find(planet *p, char *name);

/* planet_delete() - mark a record as deleted */
result planet_delete(planet *p);

/* planet_deleted() - return the deleted status of a record */
int planet_deleted(planet *p);

/* planet_pack() - pack a close data file */
result planet_pack(char *path);

#endif /*_PLANET_C_*/


/* end of include file ****************************************/


#endif /*_PLANET_H_*/
