/**************************************************************
 * ORDERS.H                  Copyright (C) Damian Walker 1997 *
 *------------------------------------------------------------*
 * AstroWar 1.00 play-by-mail space conquest game host.       *
 * Orders file access module.  Header file.                   *
 *------------------------------------------------------------*
 * Author   Damian G Walker                                   *
 * Date     30-Jan-97                                         *
 **************************************************************/


#ifndef _ORDERS_H_
#define _ORDERS_H_


/* structures *************************************************/


typedef void order;


/* function prototypes ****************************************/


/* orders_open() - open the order file */
result orders_open(char *path);

/* orders_create() - create a new order file */
result orders_create(char *path);

/* orders_first() - read the first order */
result orders_first(order *o);

/* orders_next() - read the next order */
result orders_next(order *o);

/* orders_write() - add or update an order */
result orders_write(order *o);

/* orders_new() - allocate memory for a new order */
order *orders_new();

/* orders_old() - free memory from an old order */
void orders_old(order *o);

/* orders_settrans() - set the transaction number */
void orders_settrans(order *o, long number);

/* orders_settype() - set the 'type' character */
void orders_settype(order *o, char type);

/* orders_setempire() - set the empire name */
void orders_setempire(order *o, char *name);

/* orders_setorigin() - set the origin for a send order */
void orders_setorigin(order *o, char *name);

/* orders_setdest() - set the destination for a send order */
void orders_setdest(order *o, char *name);

/* orders_setships() - set the ships in a send order */
void orders_setships(order *o, long ships);

/* orders_setcentre() - set the centre in a map order */
void orders_setcentre(order *o, char *name);

/* orders_setrecip() - set the recipient in a write order */
void orders_setrecip(order *o, char *name);

/* orders_settext() - set the message text in a write order */
void orders_settext(order *o, char *text);

/* orders_gettype() - return the order type */
char orders_gettype(order *o);

/* orders_gettrans() - return the transaction number */
long orders_gettrans(order *o);

/* orders_getempire() - return the empire name */
char *orders_getempire(char *name, order *o);

/* orders_getorigin() - return the origin planet in a send */
char *orders_getorigin(char *name, order *o);

/* orders_getdest() - return the destination planet in a send */
char *orders_getdest(char *name, order *o);

/* orders_getships() - return the number of ships in a send */
long orders_getships(order *o);

/* orders_getcentre() - return the centre planet of a map */
char *orders_getcentre(char *name, order *o);

/* orders_getrecip() - return the recipient of a written msg */
char *orders_getrecip(char *name, order *o);

/* orders_gettext() - return the text of a written msg */
char *orders_gettext(order *o);

/* orders_close() - close orders file/library */
void orders_close(void);


#endif
