/**************************************************************
 * LOG.H                     Copyright (C) Damian Walker 1996 *
 *------------------------------------------------------------*
 * Centurion Log File Handling Library, version 2.00.         *
 * Provides functions for creating and writing to log files   *
 * in the defacto standard format for Fidonet applications.   *
 * Here is the header file.                                   *
 *------------------------------------------------------------*
 * Author  Damian Walker                                      *
 * Date    16-Apr-96                                          *
 **************************************************************/


/* Defined Constants ******************************************/


#define LOGERROR   0x0001   /* Fatal error */
#define LOGWARNING 0x0010   /* Non-fatal warning */
#define LOGMAJOR   0x0100   /* Major status message */
#define LOGMINOR   0x1000   /* Minor status message */
#define LOGTRIVIAL 0x8000   /* Trivial messages */


/* Enumerated Types *******************************************/


enum logresult {LOGOK, LOGFILEERROR, LOGSTATUSERROR};


/* Function Prototypes ****************************************/


/* openlog() - open and initialise the log file */
short openlog(char *filename, char *program);

/* setlogstatus() - set the log status bits */
void setlogstatus(short logstatus);

/* setlogchars() - set the log characters */
short setlogchars(char *logchars);

/* writelog() - write a line to the log file */
short writelog(short logstatus, char *logline);

/* closelog() - close the log file */
short closelog(void);
