/**************************************************************
 * LOG.C                     Copyright (C) Damian Walker 1996 *
 *------------------------------------------------------------*
 * Centurion Log File Handling Library, version 2.00.         *
 * Provides functions for creating and writing to log files   *
 * in the defacto standard format for Fidonet applications.   *
 *------------------------------------------------------------*
 * Author  Damian Walker                                      *
 * Date    16-Apr-96                                          *
 **************************************************************/


/* Includes ***************************************************/


#include <stdio.h>
#include <time.h>
#include <string.h>
#include "log.h"


/* Global Variables *******************************************/


static
FILE   *logfile;   /* fopen() Log File variable */
short   status;	   /* Which status messages are to be output */
char    chars[17]; /* Chars for different status messages */


/* Function Implementation ************************************/


/* openlog() - open and initialise the log file */
short openlog(char *filename, char *program)
{
    enum logresult resultcode;
    time_t timer;
    char nicedate[10];

    /* open log file */
    logfile = fopen(filename, "a");
    if(logfile != NULL)
    {

        /* write log file header */
        time(&timer);
        strftime(nicedate, 20, "%d-%b-%y", localtime(&timer));
        fputs("\n----------  ", logfile);
        fprintf(logfile, "%s, %s\n", program, nicedate);

        /* initialise some variables */
        status = 0xFFFF;
        strcpy(chars, "!...?...*...+..-");
        resultcode = LOGOK;

    }
    else resultcode = LOGFILEERROR;

    return resultcode;
}


/* setlogstatus() - set the log status bits */
void setlogstatus(short logstatus)
{
    status = logstatus;
}


/* setlogchars() - set the log characters */
short setlogchars(char *logchars)
{
    enum logresult resultcode;

    /* set the log status characters only if correct length */
    if( strlen(logchars) == 16 )
    {
        strcpy(chars, logchars);
        resultcode = LOGOK;
    }
    else resultcode = LOGSTATUSERROR;

    return resultcode;
}


/* writelog() - write a line to the log file */
short writelog(short logstatus, char *logline)
{
    enum logresult resultcode;
    short statuslevel = 0, count;
    time_t timer;
    char nicetime[9];

    time(&timer);
    strftime( nicetime, 9, "%H:%M:%S", localtime(&timer) );

    for(count = 0; count <= 15; ++count)
        if( (1 << count) & logstatus )
            statuslevel = count;
    if( status & (1 << statuslevel) )
    {
        if( fprintf(logfile, "%c %s  %s\n",
            chars[statuslevel], nicetime, logline) != EOF )
            resultcode = LOGOK;
        else
            resultcode = LOGFILEERROR;
    }
    else
        resultcode = LOGOK;

    return resultcode;
}


/* closelog() - close the log file */
short closelog()
{
    enum logresult resultcode;

    if( fclose(logfile) == 0 )
        resultcode = LOGOK;
    else
        resultcode = LOGFILEERROR;

    return resultcode;
}
