/**************************************************************
 * EMPIRE.H                  Copyright (C) Damian Walker 1997 *
 *------------------------------------------------------------*
 * AstroWar 1.00 - Empire database library header file.       *
 *------------------------------------------------------------*
 * Author   Damian G Walker                                   *
 * Date     28-Apr-97                                         *
 **************************************************************/


#ifndef _EMPIRE_H_
#define _EMPIRE_H_


/* enumerated types *******************************************/


/* empire index */
typedef enum {
    E_NONE, /* read without index */
    E_NAME, /* empire name index */
    E_LAST  /* placeholder */
} eindex;


/* structures & prototypes ************************************/


#ifndef _EMPIRE_C_

typedef void empire; /* hidden join request */

/* empire_open() - open empire files */
result empire_open(char *path);

/* empire_create() - create empire files */
result empire_create(char *path);

/* empire_close() - close empire files */
result empire_close(void);

/* empire_new() - allocate memory for new empire record */
empire *empire_new(void);

/* empire_old() - free memory for new empire record */
void empire_old(empire *e);

/* empire_clear() - clear details from existing empire record */
void empire_clear(empire *e);

/* empire_setname() - set the empire name */
char *empire_setname(empire *e, char *name);

/* empire_getname() - return the empire name */
char *empire_getname(char *name, empire *e);

/* empire_sethomewld() - set the homeworld name */
char *empire_sethomewld(empire *e, char *homewld);

/* empire_gethomewld() - return the homeworld */
char *empire_gethomewld(char *homewld, empire *e);

/* empire_write() - write a record */
result empire_write(empire *e);

/* empire_first() - read the first record */
result empire_first(empire *e, eindex inum);

/* empire_next() - read the next record */
result empire_next(empire *e, eindex inum);

/* empire_prev() - read the previous record */
result empire_prev(empire *e, eindex inum);

/* empire_last() - read the last record */
result empire_last(empire *e, eindex inum);

/* empire_find() - find a record by trans or name */
result empire_find(empire *e, char *name);

/* empire_delete() - mark a record as deleted */
result empire_delete(empire *e);

/* empire_deleted() - return the deleted status of a record */
int empire_deleted(empire *e);

/* empire_pack() - pack a close data file */
result empire_pack(char *path);

#endif /*_EMPIRE_C_*/


/* end of include file ****************************************/


#endif /*_EMPIRE_H_*/
