/**************************************************************
 * DETAIL.H                  Copyright (C) Damian Walker 1997 *
 *------------------------------------------------------------*
 * AstroWar 1.00 play-by-mail space conquest game.            *
 * Game detail module.  Reads in the game detail from an      *
 * input file and returns the various fields.  Header file.   *
 *------------------------------------------------------------*
 * Author   Damian G Walker                                   *
 * Date     14-Feb-97                                         *
 **************************************************************/


#ifndef _DETAIL_H_
#define _DETAIL_H_


/* structures *************************************************/


typedef void detail; /* (hidden) detail record */


/* function prototypes ****************************************/


/* detail_open() - open and read detail file */
result detail_open(detail **outd, char *path);

/* detail_getname() - return the game name */
char *detail_getname(char *name, detail *d);

/* detail_getplanets() - return the number of planets */
long detail_getplanets(detail *d);

/* detail_getxmin() - return minimum X co-ordinate */
int detail_getxmin(detail *d);

/* detail_getxmax() - return maximum X co-ordinate */
int detail_getxmax(detail *d);

/* detail_getymin() - return minimum Y co-ordinate */
int detail_getymin(detail *d);

/* detail_getymax() - return maximum Y co-ordinate */
int detail_getymax(detail *d);

/* detail_getmaxdist() - return maximum distance */
int detail_getmaxdist(detail *d);

/* detail_getspeed() - return ship speed */
int detail_getspeed(detail *d);

/* detail_close() - close the detail file */
void detail_close(detail *d);

/* detail_getmoves() - return movement processing */
int detail_getmoves(detail *d);

/* detail_getprod() - return production processing */
int detail_getprod(detail *d);

/* detail_getvict() - return victory checking */
int detail_getvict(detail *d);

/* detail_getorders() - return orders processing */
int detail_getorders(detail *d);


#endif
