/**************************************************************
 * ASTROWAR.H                Copyright (C) Damian Walker 1997 *
 *------------------------------------------------------------*
 * AstroWar 1.00 play-by-mail space conquest game host.       *
 * Program-wide definitions.                                  *
 *------------------------------------------------------------*
 * Author   Damian G Walker                                   *
 * Date     29-Jan-97                                         *
 **************************************************************/


#ifndef _ASTROWAR_H_
#define _ASTROWAR_H_


/* platform.h *************************************************/


#include "platform.h"


/* common macros **********************************************/


/* read binary number fields */
#define FREADLONG(l,d)  {                          \
                        l = fgetc(d);              \
                        l += 0x100 * fgetc(d);     \
                        l += 0x10000 * fgetc(d);   \
                        l += 0x1000000 * fgetc(d); \
                        }
#define FREADLONGR(l,d) {                          \
                        l += 0x100 * fgetc(d);     \
                        l += 0x10000 * fgetc(d);   \
                        l += 0x1000000 * fgetc(d); \
                        }
#define FREADSHORT(s,d) {                          \
                        s = fgetc(d);              \
                        s += 0x100 * fgetc(d);     \
                        }

/* write binary number fields */
#define FWRITELONG(l,d)  {                                              \
                         fputc((unsigned long)l             & 0xff, d); \
			 fputc((unsigned long)l / 0x100     & 0xff, d); \
			 fputc((unsigned long)l / 0x10000   & 0xff, d); \
                         fputc((unsigned long)l / 0x1000000 & 0xff, d); \
                         }
#define FWRITELONGR(l,d) {                                              \
			 fputc((unsigned long)l / 0x100     & 0xff, d); \
			 fputc((unsigned long)l / 0x10000   & 0xff, d); \
                         fputc((unsigned long)l / 0x1000000 & 0xff, d); \
                         }
#define FWRITESHORT(s,d) {                                              \
                         fputc((unsigned short)s & 0xff,         d);    \
                         fputc((unsigned short)s / 0x100 & 0xff, d);    \
                         }


/* enumerated types *******************************************/


/* result codes */
typedef enum {
    R_OK,      /* everything went OK */
    R_SWAPS,   /* swap performed in sort pass */
    R_EOF,     /* end of file or list reached */
    R_FILE,    /* file access error */
    R_HEADER,  /* invalid header encountered */
    R_EXISTS,  /* file already exists exists */
    R_INDEX,   /* no such index */
    R_CORRUPT, /* possible corrupted index */
    R_DUPE,    /* attempt to write duplicate record to file */
    R_MEMORY,  /* memory allocation error */
    R_BADCMD,  /* bad command encountered */
    R_LAST     /* placeholder */
} result;


/* global structures ******************************************/


typedef struct {
    short x, /* x position */
          y; /* y position */
} pos;


/* end of include file ****************************************/


#endif
