/******************************************************************************
 *                                                                            *
 * File:   codepage.h         Version  1.10            Date: 15-OCT-1993      *
 *                                                                            *
 * Copyright (C) 1993 by Kosta Kostis - this is freeware!                     *
 * Written by kosta@blues.sub.de (Kosta Kostis)                               *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *    15-OCT-1993: KK V1.10                                                   *
 *        - see codepage.c                                                    *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************

	DOS software interrupt constants

******************************************************************************/

#define	DOS_GETVER		0x3000		/* get DOS version           */
#define	DOS_IOCTL		0x440C		/* IOCTL communication       */
#define	DOS_IOCTL_GETCP		0x6A		/* get Codepage              */

/******************************************************************************

	Function Parameters

******************************************************************************/

#define	CATEGORY_CON		0x03		/* device category is CON:   */
#define	HANDLE_CON		0x02		/* handle for stderr CON:    */

/******************************************************************************

	minimum DOS version needed to determine current Code Page

******************************************************************************/

#define	MIN_DOSVER		0x0330		/* DOS version 3.30          */

/******************************************************************************

	Default Code Page

******************************************************************************/

#define	DEF_CODEPAGE		437		/* default is U.S.A.         */

#define	CODEPAGE_UNKNOWN	0x0000
#define	CODEPAGE_INVALID	0xFFFF

/******************************************************************************

	Function Prototype

******************************************************************************/

extern	int	CodePage (void) ;

/******************************************************************************

	CODEPAGE Data Structure

******************************************************************************/

typedef	struct
{
	unsigned short	int	cpLength ;	// should always be 2
	unsigned short	int	cpId ;		// CodepageID
} CODEPAGE ;
