/* -*-C-*-
*******************************************************************************
*
* File:         tsl.h
* RCS:          $Header: tsl.h,v 1.2 89/09/14 20:34:18 chip Rel $
* Description:  Text Storage Library header file
* Author:       Chip Chapin, Hewlett Packard Company
* Created:      Jan 14 1989
* Modified:     Tue Sep  5 13:59:13 1989 (Chip Chapin) chip@hpcllcc
* Language:     C
* Package:      Bible Retrieval System
* Status:       Experimental (Do Not Distribute)
*
* $Log:	tsl.h,v $
 * Revision 1.2  89/09/14  20:34:18  20:34:18  chip (Chip Chapin)
 * Release 1-2.  Supports -f and -l options for formatting the output.
 * Updates primarily brl.c, bible.c, and bible.1.
 * 
 * Revision 1.1  89/09/05  17:49:50  17:49:50  chip (Chip Chapin)
 * Initial revision
 * 
*
*******************************************************************************
*/


#define	TSL_MAGIC1	'E'	/* Magic number: two ASCII chars EC */
#define	TSL_MAGIC2	'C'
#define TSL_FVERSION1	'0'	/* File structure version: '01' */
#define TSL_FVERSION2	'1'
#define TSL_BYTEFLAG	0x01020304	/* Flag for byte order */


extern int line_locator[];	/* Defined in "tsl-index.c" */


/*
  File includes a header section that identifies its nature, and an index
  (from the statistics provided by squish) to the starting location of
  every compression window.

Output File Layout:
   bytes  Contents
   0,1	  magic number
   2,3    file version
   4,83   description: null terminated ASCII string
   --- remaining fields assume the file has been compressed with windows ---
   84-87  byte sex flag: integer 0x01020304
   88-91  window size (bytes)
   92-95  number of windows
   96-99  starting location (byte in file) of window #0
  100-103 starting location (byte in file) of window #1
   ...    etc.
   xxxx   compressed data begins
   
*/
struct tsl_fileheader {
    char	magic[2];
    char	version[2];
    char	description[80];
    int		bytesexflag;
    int		wsize;
    int 	wnum;
};


