/* -*-C-*-
********************************************************************************
*
* File:         buildcmp.c
* RCS:          $Header: buildcmp.c,v 1.2 89/09/14 20:33:56 chip Rel $
* Description:  Build compressed data file
* Author:       Chip Chapin, Hewlett Packard Company
* Created:      Mon May 29 17:34:58 1989
* Modified:     Thu Sep 14 12:38:00 1989 (Chip Chapin) chip@hpcllcc
* Language:     C
* Package:      Bible Retrieval System
* Status:       Experimental (Do Not Distribute)
*
* $Log:	buildcmp.c,v $
 * Revision 1.2  89/09/14  20:33:56  20:33:56  chip (Chip Chapin)
 * Release 1-2.  Supports -f and -l options for formatting the output.
 * Updates primarily brl.c, bible.c, and bible.1.
 * 
 * Revision 1.1  89/09/05  17:49:23  17:49:23  chip (Chip Chapin)
 * Initial revision
 * 
*
********************************************************************************
*/

#include <stdio.h>
#include "tsl.h"

static char rcs_ident[]="@(#)$Header: buildcmp.c,v 1.2 89/09/14 20:33:56 chip Rel $";



struct tsl_fileheader fh;
FILE *sf, *df, *of;	/* stats file, data file, output file */

put_header()
{
    int  i, count, d;
    int headersize, tablesize;
    int *w_table, *winx;
    
    fh.magic[0] = TSL_MAGIC1;
    fh.magic[1] = TSL_MAGIC2;
    fh.version[0] = TSL_FVERSION1;
    fh.version[1] = TSL_FVERSION2;
    fh.bytesexflag = TSL_BYTEFLAG;		/* Flag for byte order */
    strcpy( fh.description, "Compressed Data File" );
    
    /* Process the squish statistics */
    fread( &d, sizeof(int), 1, sf );
    printf( "Window size (bytes): %d\n", d );
    fh.wsize = d;
    fread( &d, sizeof(int), 1, sf );
    printf( "Number of windows: %d\n", d );
    fh.wnum = count = d;

    fwrite( &fh, sizeof(fh), 1, of );

    tablesize = sizeof(int)*(count+1);		/* +1 for terminating entry */
    headersize = sizeof(fh) + tablesize;
    winx = w_table = malloc( tablesize );

    for (i=0; i <= count; i++) {
	fread( &d, sizeof(int), 1, sf );
	*winx++ = d + headersize;
	printf( "Window[%d] starts at %d\n", i, d+headersize );
    }
    fwrite( w_table, tablesize, 1, of );
}

put_data()
{
    int c;
    
    while ( (c = getc(df)) != EOF ) putc(c, of);
}

main(argc, argv)
int argc;
char **argv;
{
    
    sf = fopen( "squish.stats",  "r" );
    df = fopen( "squish.data",   "r" );
    of = fopen( "squish.output", "w" );

    put_header();
    put_data();

    fclose( sf );
    fclose( df );
    fclose( of );
}

