/* -*-C-*-
*******************************************************************************
*
* File:         brl-index.c
* RCS:          $Header: brl-index.c,v 1.2 89/09/14 20:33:40 chip Rel $
* Description:  BRL verse index tables
* Author:       Chip Chapin, Hewlett Packard Company
* Created:      Jan 21 1989
* Modified:     Thu Sep 14 12:36:11 1989 (Chip Chapin) chip@hpcllcc
* Language:     C
* Package:      Bible Retrieval System
* Status:       Experimental (Do Not Distribute)
*
* $Log:	brl-index.c,v $
 * Revision 1.2  89/09/14  20:33:40  20:33:40  chip (Chip Chapin)
 * Release 1-2.  Supports -f and -l options for formatting the output.
 * Updates primarily brl.c, bible.c, and bible.1.
 * 
 * Revision 1.1  89/09/05  17:49:09  17:49:09  chip (Chip Chapin)
 * Initial revision
 * 
*
*******************************************************************************
*/


/*----------------------------------------------------------------------
|   NAME:
|       brl-index.c
|
|   PURPOSE:
|       This file contains predefined tables that are used by the
|       Bible Retrieval Library to index the Bible text.  The
|       tables allow one to locate the absolute verse number (i.e.
|       counting from the start of the text) of a particular
|       Book/Chapter/Verse.  Another table (currently kept in
|       bsc-index.c) can then be used to determine the starting
|       byte location for that verse in the data file.
|       
|       Note that the tables are automatically generated using the
|       "mkvstruct" and "mkcstruct" scripts.
|
|   FUNCTIONS:
|       No functions.
|       
|       Two tables: "start_verse" and "start_chapter", described below.
|
|   HISTORY:
|       890121 cc Initial version.
|       890830 cc Revised so that the tables can be indexed by
|       	"n+1", i.e. start_chapter[Rev+1] and start_verse[Rev23].
|       	This is very useful for forcing chapter and verse
|       	into the correct range.
|
\*----------------------------------------------------------------------*/

static char rcs_ident[]="@(#)$Header: brl-index.c,v 1.2 89/09/14 20:33:40 chip Rel $";



/* 
    This table gives the number of verses occuring in the Bible BEFORE
    any particular chapter.  Gen 1 is "chapter 1", Gen 2 is "chapter 2"
    etc.  Since there are no verses prior to Gen 1, start_verse[1] == 0.
    start_verse[2] == 31 because there are 31 verses prior to Gen 2:1.
*/
short start_verse[]={ 0,
	0, 31, 56, 80, 106, 138, 160, 184, 206, 235, 
	267, 299, 319, 337, 361, 382, 398, 425, 458, 496, 
	514, 548, 572, 592, 659, 693, 728, 774, 796, 831, 
	874, 929, 961, 981, 1012, 1041, 1084, 1120, 1150, 1173, 
	1196, 1253, 1291, 1325, 1359, 1387, 1421, 1452, 1474, 1507, 
	1533, 1555, 1580, 1602, 1633, 1656, 1686, 1711, 1743, 1778, 
	1807, 1817, 1868, 1890, 1921, 1948, 1984, 2000, 2027, 2052, 
	2078, 2114, 2145, 2178, 2196, 2236, 2273, 2294, 2337, 2383, 
	2421, 2439, 2474, 2497, 2532, 2567, 2605, 2634, 2665, 2708, 
	2746, 2763, 2779, 2796, 2831, 2850, 2880, 2918, 2954, 2978, 
	2998, 3045, 3053, 3112, 3169, 3202, 3236, 3252, 3282, 3319, 
	3346, 3370, 3403, 3447, 3470, 3525, 3571, 3605, 3659, 3693, 
	3744, 3793, 3824, 3851, 3940, 3966, 3989, 4025, 4060, 4076, 
	4109, 4154, 4195, 4245, 4258, 4290, 4312, 4341, 4376, 4417, 
	4447, 4472, 4490, 4555, 4578, 4609, 4649, 4665, 4719, 4761, 
	4817, 4846, 4880, 4893, 4939, 4976, 5005, 5054, 5087, 5112, 
	5138, 5158, 5187, 5209, 5241, 5273, 5291, 5320, 5343, 5365, 
	5385, 5407, 5428, 5448, 5471, 5501, 5526, 5548, 5567, 5586, 
	5612, 5680, 5709, 5729, 5759, 5811, 5840, 5852, 5870, 5894, 
	5911, 5935, 5950, 5977, 6003, 6038, 6065, 6108, 6131, 6155, 
	6188, 6203, 6266, 6276, 6294, 6322, 6373, 6382, 6427, 6461, 
	6477, 6510, 6546, 6569, 6600, 6624, 6655, 6695, 6720, 6755, 
	6812, 6830, 6870, 6885, 6910, 6930, 6950, 6981, 6994, 7025, 
	7055, 7103, 7128, 7150, 7173, 7191, 7213, 7241, 7277, 7298, 
	7320, 7332, 7353, 7370, 7392, 7419, 7446, 7461, 7486, 7509, 
	7561, 7596, 7619, 7677, 7707, 7731, 7773, 7788, 7811, 7840, 
	7862, 7906, 7931, 7943, 7968, 7979, 8010, 8023, 8050, 8082, 
	8121, 8133, 8158, 8181, 8210, 8228, 8241, 8260, 8287, 8318, 
	8357, 8390, 8427, 8450, 8479, 8512, 8555, 8581, 8603, 8654, 
	8693, 8718, 8771, 8817, 8845, 8879, 8897, 8935, 8986, 9052, 
	9080, 9109, 9152, 9185, 9219, 9250, 9284, 9318, 9342, 9388, 
	9409, 9452, 9481, 9535, 9553, 9578, 9605, 9649, 9676, 9709, 
	9729, 9758, 9795, 9831, 9852, 9873, 9898, 9927, 9965, 9985, 
	10026, 10063, 10100, 10121, 10147, 10167, 10204, 10224, 10255, 10309, 
	10364, 10388, 10431, 10457, 10538, 10578, 10618, 10662, 10676, 10723, 
	10763, 10777, 10794, 10823, 10866, 10893, 10910, 10929, 10937, 10967, 
	10986, 11018, 11049, 11080, 11112, 11146, 11167, 11197, 11214, 11232, 
	11249, 11271, 11285, 11327, 11349, 11367, 11398, 11417, 11440, 11456, 
	11478, 11493, 11512, 11526, 11545, 11579, 11590, 11627, 11647, 11659, 
	11680, 11707, 11735, 11758, 11767, 11794, 11830, 11857, 11878, 11911, 
	11936, 11969, 11996, 12020, 12031, 12101, 12114, 12138, 12155, 12177, 
	12205, 12241, 12256, 12300, 12311, 12331, 12363, 12386, 12405, 12424, 
	12497, 12515, 12553, 12592, 12628, 12675, 12706, 12728, 12751, 12766, 
	12783, 12797, 12811, 12821, 12838, 12870, 12874, 12896, 12909, 12935, 
	12956, 12983, 13013, 13034, 13056, 13091, 13113, 13133, 13158, 13186, 
	13208, 13243, 13265, 13281, 13302, 13331, 13360, 13394, 13424, 13441, 
	13466, 13472, 13486, 13509, 13537, 13562, 13593, 13633, 13655, 13688, 
	13725, 13741, 13774, 13798, 13839, 13869, 13893, 13927, 13944, 13950, 
	13962, 13970, 13978, 13990, 14000, 14017, 14026, 14046, 14064, 14071, 
	14079, 14085, 14092, 14097, 14108, 14123, 14173, 14187, 14196, 14209, 
	14240, 14246, 14256, 14278, 14290, 14304, 14313, 14324, 14336, 14360, 
	14371, 14393, 14415, 14443, 14455, 14495, 14517, 14530, 14547, 14560, 
	14571, 14576, 14602, 14619, 14630, 14639, 14653, 14673, 14696, 14715, 
	14724, 14730, 14737, 14760, 14773, 14784, 14795, 14812, 14824, 14832, 
	14844, 14855, 14865, 14878, 14898, 14905, 14940, 14976, 14981, 15005, 
	15025, 15053, 15076, 15086, 15098, 15118, 15190, 15203, 15222, 15238, 
	15246, 15264, 15276, 15289, 15306, 15313, 15331, 15383, 15400, 15416, 
	15431, 15436, 15459, 15470, 15483, 15495, 15504, 15513, 15518, 15526, 
	15554, 15576, 15611, 15656, 15704, 15747, 15760, 15791, 15798, 15808, 
	15818, 15827, 15835, 15853, 15872, 15874, 15903, 16079, 16086, 16094, 
	16103, 16107, 16115, 16120, 16126, 16131, 16137, 16145, 16153, 16156, 
	16174, 16177, 16180, 16201, 16227, 16236, 16244, 16268, 16281, 16291, 
	16298, 16310, 16325, 16346, 16356, 16376, 16390, 16399, 16405, 16438, 
	16460, 16495, 16522, 16545, 16580, 16607, 16643, 16661, 16693, 16724, 
	16752, 16777, 16812, 16845, 16878, 16906, 16930, 16959, 16989, 17020, 
	17049, 17084, 17118, 17146, 17174, 17201, 17229, 17256, 17289, 17320, 
	17338, 17364, 17386, 17402, 17422, 17434, 17463, 17480, 17498, 17518, 
	17528, 17542, 17559, 17576, 17587, 17603, 17619, 17632, 17645, 17659, 
	17690, 17712, 17738, 17744, 17774, 17787, 17812, 17834, 17855, 17889, 
	17905, 17911, 17933, 17965, 17974, 17988, 18002, 18009, 18034, 18040, 
	18057, 18082, 18100, 18123, 18135, 18156, 18169, 18198, 18222, 18255, 
	18264, 18284, 18308, 18325, 18335, 18357, 18395, 18417, 18425, 18456, 
	18485, 18510, 18538, 18566, 18591, 18604, 18619, 18641, 18667, 18678, 
	18701, 18716, 18728, 18745, 18758, 18770, 18791, 18805, 18826, 18848, 
	18859, 18871, 18890, 18902, 18927, 18951, 18970, 19007, 19032, 19063, 
	19094, 19124, 19158, 19180, 19206, 19231, 19254, 19271, 19298, 19320, 
	19341, 19362, 19389, 19412, 19427, 19445, 19459, 19489, 19529, 19539, 
	19577, 19601, 19623, 19640, 19672, 19696, 19736, 19780, 19806, 19828, 
	19847, 19879, 19900, 19928, 19946, 19962, 19980, 20002, 20015, 20045, 
	20050, 20078, 20085, 20132, 20171, 20217, 20281, 20315, 20337, 20359, 
	20425, 20447, 20469, 20497, 20507, 20534, 20551, 20568, 20582, 20609, 
	20627, 20638, 20660, 20685, 20713, 20736, 20759, 20767, 20830, 20854, 
	20886, 20900, 20949, 20981, 21012, 21061, 21088, 21105, 21126, 21162, 
	21188, 21209, 21235, 21253, 21285, 21318, 21349, 21364, 21402, 21430, 
	21453, 21482, 21531, 21557, 21577, 21604, 21635, 21660, 21684, 21707, 
	21742, 21763, 21812, 21842, 21879, 21910, 21938, 21966, 21993, 22020, 
	22041, 22086, 22099, 22110, 22133, 22138, 22157, 22172, 22183, 22199, 
	22213, 22230, 22245, 22257, 22271, 22287, 22297, 22317, 22349, 22370, 
	22385, 22401, 22416, 22429, 22456, 22470, 22487, 22501, 22516, 22537, 
	22554, 22564, 22574, 22585, 22601, 22614, 22626, 22639, 22654, 22670, 
	22690, 22705, 22718, 22737, 22754, 22774, 22793, 22811, 22826, 22846, 
	22861, 22884, 22905, 22918, 22928, 22942, 22953, 22968, 22982, 23005, 
	23022, 23034, 23051, 23065, 23074, 23095, 23109, 23126, 23144, 23150, 
	23175, 23198, 23215, 23240, 23288, 23322, 23351, 23385, 23423, 23465, 
	23495, 23545, 23603, 23639, 23678, 23706, 23733, 23768, 23798, 23832, 
	23878, 23924, 23963, 24014, 24060, 24135, 24201, 24221, 24266, 24294, 
	24329, 24370, 24413, 24469, 24506, 24544, 24594, 24646, 24679, 24723, 
	24760, 24832, 24879, 24899, 24979, 25031, 25069, 25113, 25152, 25201, 
	25251, 25307, 25369, 25411, 25465, 25524, 25559, 25594, 25626, 25657, 
	25694, 25737, 25785, 25832, 25870, 25941, 25997, 26050, 26101, 26126, 
	26162, 26216, 26263, 26334, 26387, 26446, 26487, 26529, 26586, 26636, 
	26674, 26705, 26732, 26765, 26791, 26831, 26873, 26904, 26929, 26955, 
	27002, 27028, 27065, 27107, 27122, 27182, 27222, 27265, 27313, 27343, 
	27368, 27420, 27448, 27489, 27529, 27563, 27591, 27632, 27670, 27710, 
	27740, 27775, 27802, 27829, 27861, 27905, 27936, 27968, 27997, 28028, 
	28053, 28074, 28097, 28122, 28161, 28194, 28215, 28251, 28272, 28286, 
	28309, 28342, 28369, 28400, 28416, 28439, 28460, 28473, 28493, 28533, 
	28546, 28573, 28606, 28640, 28671, 28684, 28724, 28782, 28806, 28830, 
	28847, 28865, 28883, 28904, 28922, 28938, 28962, 28977, 28995, 29028, 
	29049, 29063, 29087, 29108, 29137, 29168, 29194, 29212, 29235, 29257, 
	29278, 29310, 29343, 29367, 29397, 29427, 29448, 29471, 29500, 29523, 
	29548, 29566, 29576, 29596, 29609, 29627, 29655, 29667, 29684, 29702, 
	29722, 29737, 29753, 29769, 29794, 29815, 29833, 29859, 29876, 29898, 
	29914, 29929, 29944, 29969, 29983, 30001, 30020, 30036, 30050, 30070, 
	30098, 30111, 30139, 30178, 30218, 30247, 30272, 30299, 30325, 30343, 
	30360, 30380, 30405, 30430, 30452, 30471, 30485, 30506, 30528, 30546, 
	30556, 30585, 30609, 30630, 30651, 30664, 30678, 30703, 30723, 30752, 
	30774, 30785, 30799, 30816, 30833, 30846, 30867, 30878, 30897, 30914, 
	30932, 30952, 30960, 30981, 30999, 31023, 31044, 31059, 31086, 31107
	};

/*
    The start_chapter table is indexed by Bible BOOK (0..65) and
    gives the number of CHAPTERS in the whole Bible that precede that
    particular book.  Thus given the BOOK, CHAPTER, and VERSE for a
    reference, we can easily compute an absolute verse number for that
    reference as follows:

	abs_verse = start_verse[ start_chapter[BOOK] + CHAPTER ] + VERSE
*/
short start_chapter[]={
	0, 50, 90, 117, 153, 187, 211, 232, 236, 267, 
	291, 313, 338, 367, 403, 413, 426, 436, 478, 628, 
	659, 671, 679, 745, 797, 802, 850, 862, 876, 879, 
	888, 889, 893, 900, 903, 906, 909, 911, 925, 929, 
	957, 973, 997, 1018, 1046, 1062, 1078, 1091, 1097, 1103, 
	1107, 1111, 1116, 1119, 1125, 1129, 1132, 1133, 1146, 1151, 
	1156, 1159, 1164, 1165, 1166, 1167, 1189
	};

