/*
 * Copyright (c) 1991 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
#ifndef lint
char copyright[] =
    "@(#) Copyright (c) 1991 The Regents of the University of California.\nAll rights reserved.\n";
static  char rcsid[] =
    "@(#)$Header: blocktest.c,v 1.3 91/03/04 16:03:15 leres Exp $ (LBL)";
#endif

/*
 * blocktest - test filesystem blocksize assumptions
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifdef SYSV
#include <strings.h>
#else
#include <string.h>
#define rindex strrchr
#endif
#include <errno.h>

static char *prog;

extern int errno;

main(argc, argv)
	int argc;
	char **argv;
{
	register int i, fd, b, c, frag;
	register char *cp;
	char file[132];
	struct stat sbuf;
	char ch;

	if (cp = rindex(argv[0], '/'))
		prog = cp + 1;
	else
		prog = argv[0];

	/* Need a temporary file */
	(void)mktemp(strcpy(file, "/tmp/blocktest.XXXXX"));

	/* Better not already exist */
	if (unlink(file) >= 0) {
		fprintf(stderr, "%s: %s already existed!\n", file, prog);
		exit(1);
		/* NOTREACHED */
	}
	if (errno != ENOENT) {
		fprintf(stderr, "%s: Unexpected error: ", prog);
		perror(file);
		exit(1);
		/* NOTREACHED */
	}

	/* Create the file */
	fd = creat(file, 0644);
	if (fd < 0) {
		fprintf(stderr, "%s: creat(): ", prog);
		perror(file);
		exit(1);
		/* NOTREACHED */
	}

	/* Remove now so we don't have to later */
	(void)unlink(file);

	/* Slowly ramp up the size and see if anything unexpected happens */
	frag = 0;
	for (i = 0; i <= 10 * 1024; ++i) {
		if (fstat(fd, &sbuf) < 0) {
			fprintf(stderr, "%s: fstat(): ", prog);
			perror(file);
			exit(1);
			/* NOTREACHED */
		}

		/* Size better agree */
		if (sbuf.st_size != i) {
			fprintf(stderr, "%s: Size wrong (%d != %d)\n",
			    prog, sbuf.st_size, i);
			exit(1);
			/* NOTREACHED */
		}

		/* Calculate number of 512 byte blocks */
		b = (i + 511) / 512;

		/* Try to determine file system frag size */
		if (i == 1)
			frag = sbuf.st_blocks;

		/* Calculate number of frag blocks */
		if (frag)
			c = ((b + frag - 1) / frag) * frag;
		else
			c = -1;

		if (b != sbuf.st_blocks && c != sbuf.st_blocks) {
			fprintf(stderr, "%s: Not 512 byte blocks!\n",
			    prog);
			exit(1);
			/* NOTREACHED */
		}

		/* Write one byte of random data */
		ch = i % 0xff;
		if (write(fd, &ch, 1) != 1) {
			fprintf(stderr, "%s: write(): ", prog);
			perror(file);
			exit(1);
			/* NOTREACHED */
		}
#ifdef notdef
		if (fsync(fd) < 0) {
			fprintf(stderr, "%s: fsync(): ", prog);
			perror(file);
			exit(1);
			/* NOTREACHED */
		
#endif
	}

	printf("%s: Success: This machine appears to use 512 byte blocks\n",
	    prog);
	(void)close(fd);
	exit(0);
	/* NOTREACHED */
}
