#
#  Trumpet Winsock 2.1 Login.cmd
#
#  Copyright (C) 1994,1995 Peter R. Tattam & 
#  Trumpet Software International Pty Ltd (TSI)
#  All rights reserved.
#
#  Unless TSI has given prior written consent to such use, 
#  no permission is granted to distribute or otherwise make available 
#  to the public modified versions of this script for commercial purposes.  
#  Any permitted distribution of modified versions of the script must
#  retain the copyright notice at the start of this file and must clearly 
#  identify those parts of the file which have been modified.
#
#trace on
#
# set up some strings for dialling up
#
if ![load $number]
  if [query $number "Enter your dial up phone number"]
    save $number
  end
end
if ![load $username]
  if [username "Enter your login username"]
    save $username
  end
end
if ![load $password]
  if [password "Enter your login password"]
    save $password
  end
end
$modemsetup = "&c1&k3"
$prompt = ">"
$userprompt = "sername:"
$passprompt = "assword:"
$slipcmd = "slip"
$addrtarg = "our address is"
$pppcmd = "ppp"
$pppready = "PPP."
%attempts = 10

###############################################
# timeouts for various sections of the script #
###############################################
#
# timeout for busy tone... adjust this until the BUSY string is detected.
#
%busytimeout = 10
#
# time between successive busy attempts.
#
%busywait = 30
#
# time to wait for a CONNECT string to be received
#
%connecttimeout = 60
#
# time to wait until DCD is detected
#
%onlinetimeout = 60
#
# time to wait for username & password prompts
#
%logintimeout = 60
#
# time to wait for server prompt to appear
#
%prompttimeout = 30
#
# time to wait for a SLIP address to be parsed
#
%addresstimeout = 30
#
#
#
#
#----------------------------------------------------------
#
# initialize modem
#
status "Initializing modem..."
output "atz"\13
if ! [input 5 OK\n]
  message "Modem is not responding"
  abort
end
#
# setup our modem commands
#
output "at"$modemsetup\13
if ! [input 10 OK\n]
  message "Modem is not responding"
  abort
end
#
# send phone number
#
%n = 0
repeat
  %n = %n + 1
  if %n > %attempts
    message "Too many dial attempts"
    abort
  end
  status Dialling $number...(attempt %n)
  output "atdt"$number\13
  %busy = [input %busytimeout BUSY]
  if %busy
    status "The line is busy...pausing for a while"
    sleep %busywait
    %ok = 0
  else
    %ok = [input %connecttimeout CONNECT]
  end
until %ok
input 10 \n
#
#  wait till it's safe to send because some modem's hang up
#  if you transmit during the connection phase
#
wait %onlinetimeout dcd
status Connected.  Now logging in as $username...
#
# now prod the terminal server
#
#output \13
#
#  wait for the username prompt
#
input %logintimeout $userprompt
output $username\13
#
# and the password
#
input %logintimeout $passprompt
output $password\13
#
# we are now logged in
#
status "Logged in. Now switching to Internet..."
input %prompttimeout $prompt
if %ppp
  #
  # jump into ppp mode
  #
  output $pppcmd\13
  #
  # wait for PPP prompt.
  input %prompttimeout $pppready
  #
  display \n\n"PPP mode selected.  Will try to negotiate IP address."\n
  status "PPP mode selected.  Will try to negotiate IP address."
  sleep 1
  #
else
  #
  # jump into slip mode
  #
  output $slipcmd\13
  #
  # wait for the address string
  #
  input %addresstimeout $addrtarg
  #
  # parse address
  #
  address 30
  input %addresstimeout \n
  #
  # we are now connected, logged in and in slip mode.
  #
  display \n
  display Connected.  Your IP address is \i.\n
  status Connected.  Your IP address is \i.
  sleep 1
end
#
# now we are finished.
#
