


GUP(1)                    User Commands                    GUP(1)



NAME
     gup - A Group Update Program that accepts commands  by  mail
     to  edit a newsgroup subscription file for subsequent use by
     news systems such as INN and C-News.

SYNTAX
     gup [-hvP] -a active_path [-d home_directory] [-l log_path]
           [-m reply_headers] [-n newsgroups_path]
           [-s sites_directory] [-M Mail_command]

DESCRIPTION
     The sole purpose of gup is to automate the  tedious  process
     of editing group selection patterns defined in the news con-
     figuration files (eg:  ``newsfeeds'' for INN and ``sys'' for
     C-News).

     Gup is of use to news administrators who spend an inordinate
     amount of time editing their news config files at the behest
     of the sites they feed.  In fact, once gup is installed,  it
     is  quite  likely that manual edits of your ``newsfeeds'' or
     ``sys'' file will become a thing of the past.

     Gup is designed to be installed as a  mail - server  program
     that  is  fed  an  inbound  mail  via stdin.  Gup is usually
     invoked from a .forward file. Eg:

          "|/.../bin/gup -options...."

     Each site has an entry in  the  ``config''  file  containing
     password and mail address details and a group selection file
     called ``groups'', see CONFIG, and GROUPS for more details.

     The news administrator of each site mails commands  to  gup.
     There  are  commands  to include and exclude group patterns,
     list the current patterns for that site and list the  avail-
     able newsgroups; see COMMANDS, for more details.

     The results are normally mailed back to the  site's  config-
     ured  administrator.   However under some circumstances, the
     results are mailed to the originator or the  local  adminis-
     trator; see PROCESSING, for further details.

     Gup does not directly change the news system's control files
     (eg, ``newsfeeds'' for INN).  Instead a trivial shell script
     must be run to concatenate all  of  the  changed  ``groups''
     files together into an appropriately formatted file for your
     particular news system. (One is provided in the  source  kit
     for INN).

     Since each site has to be specifically configured  in  gup's
     ``config'' file, access can be restricted to administrator's
     capable of managing their own group patterns.



SunOS 5.4           Last change: 25 July 1993                   1






GUP(1)                    User Commands                    GUP(1)



OPTIONS
     Options can appear in any order on  the  command  line.  The
     most  important  point  to note is that all of the paths and
     directories defined will normally be absolute  paths  unless
     you  are  intimately  familiar  with  the  way  in which gup
     changes directories as it processes  a  mail  (the  possible
     exception here is the Sites_directory).

     -a active_path
          The path of the  active  file  for  your  news  system.
          Before accepting any newsgroup identified in a command,
          gup validates the group against the  active  file.  The
          command is rejected if no match is found.

     -d home_directory
          Defines gup's home  directory.   Gup  changes  to  this
          directory  as  soon  as  possible after starting up. If
          this option is not present, the  current  directory  is
          used.   Gup  looks for the ``config'' file in it's home
          directory.

     -h    Print out a help  message  showing  the  command  line
          options, then exit.

     -l log_path
          A record of all significant  requests  are  written  to
          this  file.  If  the  path is relative, then it will be
          relative to gup's home directory; see the - d  option).
          Gup  must  be  able  to  write to this file.  If the -l
          option is not used, then gup uses stderr. This is  use-
          ful  for testing purposes, but is unlikely to be of use
          in a .forward file.

     -m reply_headers
          When gup generates a mail response  it  only  generates
          the ``TO: '' header line.  This option defines the path
          of a file that contains other RFC882 conformant  header
          lines  that  are  piped to the mail program (see the -M
          option).  In fact, if this file contains a body follow-
          ing  the  headers, then that will precede any text gen-
          erated by gup. If this path is not  an  absolute  path,
          then  it  will  be  treated  as  relative to gup's home
          directory (see the -d option).

     -M Mail_command
          Gup pipes the rfc822 headers and the body of  the  mail
          to  the  nominated mail program. Normally, this is con-
          figured when gup is installed, but it can be over- rid-
          den  with this option. The mail command must be able to
          determine  the  recipient  addresses  from  the  rfc822
          headers.




SunOS 5.4           Last change: 25 July 1993                   2






GUP(1)                    User Commands                    GUP(1)



     -n newsgroups_path
          If present, the newsgroups file is used to try and find
          a matching description of newsgroup when listed.

     -P    Do  not  prune  superfluous  patterns  from  a  site's
          ``groups''  file. Before writing the updated ``groups''
          file, gup applies a fairly rigorous test  to  the  pat-
          terns,  pruning  any  nonsensical  or un-necessary pat-
          terns. This pruning process can be quite  CP  intensive
          to  the extent that it may have a deleterious effect on
          your system - thus the ability to disable it.

     -s Sites_directory
          Each site's ``groups'' and ``exclude'' file are located
          in  a unique directory for each site. These site direc-
          tories are located in the directory defined  with  this
          option.  If  this  is  given as a relative path then it
          will be relative to gup's home directory (see  the  - d
          option).   Gup will try and create this directory if it
          does not exist.

     -v    Print out the version number and various compile- time
          variables, then exit.

COMMANDS
     Gup scans the body of the mail for commands. Blank lines are
     ignored and any data after the ``#'' character is considered
     a comment. No continuation is allowed. Many of the  commands
     accept  a pattern as a parameter.  This pattern is identical
     to the format of the wildmat() pattern; see wildmat  (3)  ).
     In  fact, Gup purposely uses the wildmat routine from INN to
     ensure that the pattern matching characteristics are identi-
     cal.

     Valid commands are:

     site sitename password
          This must be the first command in the  mail.   sitename
          and  password  must  match  an  entry in the ``config''
          file.  Only one  site  command  is  allowed  per  mail.
          Aliases: "open" and "host".

     quit This command stops gup from processing the rest of  the
          mail.  This  is useful if your mail User Agent tends to
          automatically append a signature  file  to  your  mail.
          Alias: "q".

     include pattern
          The pattern is checked against the active file.  If  it
          matches  at  least one newsgroup, the pattern is placed
          at the end of the site's ``group'' file as  an  include
          entry.    Only  one  pattern  per  include  command  is



SunOS 5.4           Last change: 25 July 1993                   3






GUP(1)                    User Commands                    GUP(1)



          allowed. If the pattern matches anything in the  site's
          exclusion  list  (see EXCLUSIONS) then the include will
          fail.  Aliases: "+" and "inc".

     exclude pattern
          The pattern is checked against the active file.  If  it
          matches  at  least one newsgroup, the pattern is placed
          at the end of the site's ``group'' file as  an  exclude
          entry.    Only  one  pattern  per  exclude  command  is
          allowed.  Aliases: "-" and "exc".

     help Generate a small help message  that  briefly  describes
          each  command.   There is an implied quit with the help
          command so there is no point in placing commands  after
          the help command.  Alias: "h".

     list list all of the current include and exclude patterns in
          the  sites  ``groups'' file.  The output is in a format
          suitable for feeding back into gup at a later stage  if
          need be.  Alias: "l".

     delete pattern
          Delete all include and exclude patterns in  the  site's
          ``groups'' file that match the pattern. ``delete *'' is
          an effective way of clearing all current patterns.

     newsgroups pattern
          This command lists out all  available  newsgroups  from
          the  active  file  that  match  the  pattern.  The list
          includes the description from the  newsgroups  file  as
          well  as  an  indication  if the site is currently sub-
          scribed to that group.  Only one pattern per newsgroups
          command is allowed.  Alias: "news".

PROCESSING
     Gup has a number of processing  stages.  The  initialization
     stage consists of changing to the home directory (see the -d
     option) and opening the logfile (see the -l option). At this
     time,  gup  sets  the tentative reply-to mail address to the
     ``backstop'' mail address  defined  when  gup  was  compiled
     (typically the local news administrator).

     The next stage consists of scanning the inbound mail, noting
     interesting  mail  headers.  The  most  interesting ones are
     "TO:" and "REPLY-TO:".  When a  "TO:"  header  is  found  it
     becomes  the  tentative  reply-to mail address. If a "REPLY-
     TO:" header is found it over- rides  any  "TO:"  address  to
     become  the new tentative reply-to mail address.  A few oth-
     ers are noted and logged to help track changes.

     After all the headers have been processed, the body  of  the
     mail is examined for commands. The first command must be the



SunOS 5.4           Last change: 25 July 1993                   4






GUP(1)                    User Commands                    GUP(1)



     site command. Any other data results in an error  mail  sent
     to the tentative reply-to mail address.  If the site command
     contains a name that matches  an  entry  in  the  ``config''
     file,  then  the tentative reply-to mail address is replaced
     with the mail address in the ``config'' file.

     The reason for these contortions with  tentative  reply - to
     mail addresses is simply to deal with the problem of working
     out who to send a mail to in the event of an error.  Ideally
     they  should  all  go back to the mail address in the ``con-
     fig'' file, but that information is not known  for  quite  a
     significant part of gup's initial processing.

     Once a valid site command has been accepted, gup changes  to
     that site's directory in Sites_directory (see the -s option)
     making the Sites_directory and site's  directory  as  neces-
     sary.  The  site's  directory name is the same as the site's
     name. In the absence of the -s option this will be:

          $HOME/sites/$site

     Where $HOME is gup's home directory and $site is the name of
     the site being processed.  Gup locks the site then loads the
     site's current ``groups'' file  and  any  xclusion  list  if
     present (see EXCLUSIONS for more details).

     From this point on gup accepts  any  command  in  any  order
     until either the end of the mail, a quit command a help com-
     mand or a serious error during processing.  After  all  com-
     mands   have   been   processed,  gup  update's  the  site's
     ``groups'' file if changes  have  been  made.   This  update
     includes  pruning  any  superfluous  patterns (unless the -P
     option  is  used).   Gup  writes   the   new   patterns   to
     ``groups.new''.  It then renames ``groups'' to ``group.old''
     and  finally  renames  ``groups.new''  to  ``groups''.   The
     result of all this processing is mailed to the site adminis-
     trator defined in the ``config'' file.

CONFIG
     Access to gup is controlled by the ``config'' file in  gup's
     home  directory (see the -d option).  This file contains one
     line  per  site.  Each  line  contains   three   white-space
     separated tokens. The site's name, password and mail address
     of the administrator.  Blank lines are allowed and  comments
     follow  the  ``#'' character.  Gup uses a very simple token-
     izer, thus no quoting or continuation is allow in this file.

     The site name and password are used to check an inbound site
     command. The password is in plain-text so permissions should
     be carefully set to restrict access. Here's an example of  a
     ``config'' file.




SunOS 5.4           Last change: 25 July 1993                   5






GUP(1)                    User Commands                    GUP(1)



          werple    Fert5566a__$1  andrew@werple.apana.org.au
          torps     34fkr_&&11)Zz  zaph@torps.apana.org.au
          uunet     R_S_1@@*(A-\   news@uunet.uu.net
          .test     flapper        markd

     Hopefully this is intuitively obvious...

GROUPS
     Each site has it's own file of patterns. This file is called
     ``groups''  and is located in the site's own directory below
     the Sites_directory (see the -s option).  This file contains
     one pattern per line. Exclusion lists have a preceding ``!''
     character. Here's an example:

     apana.*
     !apana.lists.*
     !apana.fido.*
     !apana.vortex.*
     alt.bbs.waffle
     alt.cult-movies
     alt.galactic-guide
     alt.sport.bowling
     aus.*
     !aus.ai
     !aus.religion
     !aus.radio
     !aus.stats.s

     Normally this file should only be changed by gup, but assum-
     ing you cater for locking, there is no reason why some other
     process cannot change it too.  Whenever  gup  has  to  apply
     changes, it renames this file to ``groups.old'' prior to re-
     writing the ``groups'' file. This gives you some measure  of
     recovery.

EXCLUSIONS
     For whatever reason, you  may  wish  to  exclude  particular
     groups  from  a  site's  selection  list. You can do this by
     creating the file ``exclude'' in the site's directory.  This
     file  contains  newsgroup  patterns,  one per line, that are
     used to filter the ``active'' file when verifying group pat-
     terns.  The  effect  of  this is that gup believes that such
     groups do not really exist, therefore a site cannot possibly
     include them.

DIAGNOSTICS
     All error conditions are record in the log file and possibly
     the resultant mail - depending on the nature of the error. A
     particular problem that is hard to detect is when the  .for-
     ward  file invokes gup incorrectly. If is not invoked due to
     such an error, then notification depends on the mailer. This
     should  only  be  a  problem  to  watch  out  for when first



SunOS 5.4           Last change: 25 July 1993                   6






GUP(1)                    User Commands                    GUP(1)



     installing gup.

RESTRICTIONS
     Gup does not understand ``Distribution patterns''. Any  such
     patterns  must  be generated and maintained independently of
     gup.

BUGS
     Gup does not know when the popen(1) fails when  Mail_command
     is  invoked.  This  is  a  limitation  of  popen(1).  If the
     Mail_command is bogus, then the error will be pretty obscure
     and  dependent  on  your mailer. stderr is redirected to the
     logfile prior to  invoking  the  Mail_Command  so  hopefully
     /bin/sh  (used  by  popen) has generated an appropriate mes-
     sage.

HISTORY
     Gup Version 0.3, dated 26 July, 1993.

     Initially        created        by        Mark        Delany
     <markd@bushwire.apana.org.au>.

     Numerous enhancements and optimizations  by  Andrew  Herbert
     <andrew@werple.apana.org.au>.

     The wildmat.c is taken directly from the INN sources,  writ-
     ten by Rich Salz <rsalz@osf.org>.

     The rfc822.[ch] parsing routines are taken directly from the
     newsgates    sources,    also    written    by   Rich   Salz
     <rsalz@osf.org>.

SEE ALSO
     newsfeeds(5), sendmail(8)





















SunOS 5.4           Last change: 25 July 1993                   7



