/* Copyright (C) 1999-2013 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <http://www.gnu.org/licenses/>.  */

#include <pwd.h>

static void
check (uid_t uid)
{
  char buf[1024];

  (void) getpw (uid, buf);
}

int
main (void)
{
  uid_t uid;

  /* Just call it a different number of times the range should be
     large enough to find some existing and some non existing uids.  */

  for (uid = 0; uid < 2000; ++uid)
    check (uid);

  return 0;
}
