# ASUS P8Z77-M

This page describes how to run coreboot on the [ASUS P8Z77-M].

## Flashing coreboot

```eval_rst
+---------------------+----------------+
| Type                | Value          |
+=====================+================+
| Model               | W25Q64FVA1Q    |
+---------------------+----------------+
| Size                | 8 MiB          |
+---------------------+----------------+
| Package             | DIP-8          |
+---------------------+----------------+
| Socketed            | yes            |
+---------------------+----------------+
| Write protection    | yes            |
+---------------------+----------------+
| Dual BIOS feature   | no             |
+---------------------+----------------+
| Internal flashing   | yes            |
+---------------------+----------------+
```

The flash chip is located between the blue SATA ports.

The main SPI flash cannot be written internally because Asus disables BIOSWE and
enables ``BLE/SMM_BWP`` flags in ``BIOS_CNTL`` for their latest bioses.
To install coreboot for the first time, the flash chip must be removed and
flashed with an external programmer; flashing in-circuit doesn't work.
The flash chip is socketed, so it's easy to remove and reflash.

## Working

- All USB2 ports (mouse, keyboard and thumb drive)
- USB3 ports on rear (Boots SystemRescue 6.0.3 off a Kingston DataTraveler G4 8GB)
- Gigabit Ethernet (RTL8111F)
- SATA3, SATA2 (all ports, hot-swap not tested)
       (Blue SATA2)  (Blue SATA2)  (White SATA3)
        port 5        port 3        port 1
        port 6        port 4        port 2

- CPU Temp sensors and hardware monitor (some values don't make sense)
- Native and MRC memory initialization
  (please see [Native raminit compatibility] and [MRC memory compatibility])

- Integrated graphics with both libgfxinit and the Intel Video BIOS OpROM
  (VGA/DVI-D/HDMI tested and working)
- 16x PCIe GPU in PCIe-16x/4x slots (tested using nVidia Quadro 600 under SystemRescue 6.0.3
  (Arch based))
- Serial port
- PCI slot
  Rockwell HSF 56k PCI modem, Sound Blaster Live! CT4780 (cards detected, not function tested)
  Promise SATA150 TX2plus (R/W OK to connected IDE hard drive, OpRom loaded, cannot boot from
  SeaBIOS)
- S3 suspend from Linux
- 2-channel analog audio (WAV playback by mplayer via back panel line out port)
- Windows 10 with libgfxinit high resolution framebuffer and VBT

## Known issues

- If you use MRC raminit, the NVRAM variable gfx_uma_size may be ignored as IGP's UMA could
  be reconfigured by the blob.

- If SeaBIOS is used for payload with libgfxinit, it must be brought in via coreboot's config.
  Otherwise integrated graphics would fail with a black screen.

- PCI POST card is not functional because the PCI bridge early init is not yet done.

- The black PCIEX16_2 slot, although can physically fit an x16, only has physical contacts for
  an x8, and is electrically an x4 only.

## Untested

- Wake-on-LAN
- USB3 on header
- TPM header
- EHCI debugging (Debug port is on the 5-pin side of USB2_910 header)
- HDMI and S/PDIF audio out

## Not working

- PS/2 keyboard or mouse
- 4 and 6 channel analog audio out: Rear left and right audio is a muted
  copy of front left and right audio, and the other two channels are silent.

## Native (and MRC) raminit compatibility

- OCZ OCZ3G1600LVAM 2x2GB kit works at DDR3-1066 instead of DDR3-1600.

- GSkill F3-1600C9D-16GRSL 2x8GB SODIMM kit on adapter boots, but is highly unstable
  with obvious pattern of bit errors during memtest86+ runs.

- Samsung PC3-10600U 2x2GB kit works at full rated speed.

- Kingston KTH9600B-4G 2x4GB kit works at full rated speed.

## Extra onboard buttons

The board has two onboard buttons, and each has a related LED nearby.
What controls the LEDs and what the buttons control are unknown,
therefore they currently do nothing under coreboot.

- BIOS_FLBK
  OEM firmware uses this button to facilitate a simple update mechanism
  via a USB drive plugged into the bottom USB port of the USB/LAN stack.

- MemOK!
  OEM firmware uses this button for memory tuning related to overclocking.

## Technology

```eval_rst
+------------------+--------------------------------------------------+
| Northbridge      | :doc:`../../northbridge/intel/sandybridge/index` |
+------------------+--------------------------------------------------+
| Southbridge      | bd82x6x                                          |
+------------------+--------------------------------------------------+
| CPU              | model_206ax                                      |
+------------------+--------------------------------------------------+
| Super I/O        | Nuvoton NCT6779D                                 |
+------------------+--------------------------------------------------+
| EC               | None                                             |
+------------------+--------------------------------------------------+
| Coprocessor      | Intel Management Engine                          |
+------------------+--------------------------------------------------+
```

## Extra resources

- [Flash chip datasheet][W25Q64FVA1Q]

[ASUS P8Z77-M]: https://www.asus.com/Motherboards/P8Z77M/
[W25Q64FVA1Q]: https://www.winbond.com/resource-files/w25q64fv%20revs%2007182017.pdf
[flashrom]: https://flashrom.org/Flashrom
