/*
 * Electric(tm) VLSI Design System
 *
 * File: usrtrack.h
 * User interface aid: cursor tracking headers
 * Written by: Steven M. Rubin, Static Free Software
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
extern "C"
{
#endif

void us_distanceinit(void);
void us_distancebegin(void);
INTSML us_distancedown(INTBIG, INTBIG);
INTSML us_distancechar(INTBIG x, INTBIG y, INTSML chr);
void us_distanceup(void);
INTSML us_distanceaborted(void);
void us_textmoveinit(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, GEOM*);
void us_textmovebegin(void);
INTSML us_textmovedown(INTBIG, INTBIG);
void us_textgrabinit(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, GEOM*);
void us_textgrabbegin(void);
INTSML us_textgrabdown(INTBIG, INTBIG);
void us_sizeainit(ARCINST*);
void us_sizeabegin(void);
INTSML us_sizeadown(INTBIG, INTBIG);
void us_sizeinit(NODEINST*);
INTBIG us_sizeterm(void);
void us_sizebegin(void);
INTSML us_sizecdown(INTBIG, INTBIG);
INTSML us_sizedown(INTBIG, INTBIG);
void us_rotateinit(NODEINST*);
void us_rotatebegin(void);
INTSML us_rotatedown(INTBIG, INTBIG);
void us_tracebegin(void);
INTSML us_tracedown(INTBIG, INTBIG);
void us_traceup(void);
void us_pointbegin(void);
INTSML us_addpdown(INTBIG, INTBIG);
void us_createinit(INTBIG, INTBIG, NODEPROTO*, INTSML, INTSML);
INTSML us_ignoreup(INTBIG, INTBIG);
void us_createbegin(void);
INTSML us_dragdown(INTBIG, INTBIG);
INTSML us_stoponchar(INTBIG, INTBIG, INTSML);
INTSML us_stopandpoponchar(INTBIG, INTBIG, INTSML);
void us_dragup(void);
void us_invertdragup(void);
void us_createabegin(void);
INTSML us_createadown(INTBIG, INTBIG);
void us_createaup(void);
void us_createajoinedobject(GEOM**, PORTPROTO**);
void us_createinsinit(ARCINST*, NODEPROTO*);
INTSML us_createinsdown(INTBIG, INTBIG);
void us_multidraginit(INTBIG, INTBIG, GEOM**, NODEINST**, INTBIG, INTSML);
void us_multidragbegin(void);
INTSML us_multidragdown(INTBIG, INTBIG);
void us_multidragup(void);
void us_pointinit(NODEINST*, INTSML);
void us_findpointbegin(void);
INTSML us_movepdown(INTBIG, INTBIG);
void us_findiinit(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void us_findibegin(void);
INTSML us_findidown(INTBIG, INTBIG);
void us_findiup(void);
void us_findcibegin(void);
void us_findinit(INTBIG, INTBIG);
void us_findmbegin(void);
void us_findsbegin(void);
INTSML us_stretchdown(INTBIG, INTBIG);
void us_finddbegin(void);
void us_finddterm(INTBIG*, INTBIG*);
void us_hthumbbegin(INTBIG x, WINDOWPART *w, INTBIG ly, INTBIG lx, INTBIG hx);
INTSML us_hthumbdown(INTBIG x, INTBIG y);
void us_hthumbdone(void);
void us_vthumbbegin(INTBIG y, WINDOWPART *w, INTBIG hx, INTBIG ly, INTBIG hy,
		INTBIG totallines, INTSML onleft);
void us_evthumbdone(void);
INTBIG us_evthumbend(void);
void us_svthumbdone(void);
void us_shthumbdone(void);
void us_ehthumbdone(void);
INTBIG us_ehthumbend(void);
INTSML us_vthumbdown(INTBIG x, INTBIG y);
void us_vthumbdone(void);
INTBIG us_svthumbend(void);
float us_shthumbend(void);
void us_hpartdividerbegin(INTBIG y, INTBIG lx, INTBIG hx, WINDOWFRAME *wf);
INTSML us_hpartdividerdown(INTBIG x, INTBIG y);
void us_hpartdividerdone(void);
void us_vpartdividerbegin(INTBIG y, INTBIG lx, INTBIG hx, WINDOWFRAME *wf);
INTSML us_vpartdividerdown(INTBIG x, INTBIG y);
void us_vpartdividerdone(void);
void us_arrowclickbegin(WINDOWPART *w, INTBIG lx, INTBIG hx, INTBIG ly, INTBIG hy, INTBIG amount);
INTSML us_varrowdown(INTBIG x, INTBIG y);
INTSML us_harrowdown(INTBIG x, INTBIG y);
INTSML us_nullup(INTBIG, INTBIG);
void us_nullvoid(void);
INTSML us_nullchar(INTBIG x, INTBIG y, INTSML ch);

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
}
#endif
