#ifndef DH_H
#define DH_H

#include "integer.h"

class DH : public KeyAgreementProtocol
{
public:
    DH(const Integer &p, const Integer &g);
    DH(RandomNumberGenerator &rng, unsigned int pbits);
    DH(RandomNumberGenerator &rng, unsigned int pbits, unsigned qbits);

    DH(BufferedTransformation &bt);
    void DEREncode(BufferedTransformation &bt) const;

    unsigned int PublicValueLength() const {return p.ByteCount();}
    unsigned int AgreedKeyLength() const {return p.ByteCount();}
	// for compatibility with version 1
    unsigned int OutputLength() const {return p.ByteCount();}

    void Setup(RandomNumberGenerator &rng, byte *publicValue);
    void Agree(const byte *otherPublicValue, byte *agreedKey) const;

private:
    Integer p, g, x;
};

#endif

