// dh.cpp - written and placed in the public domain by Wei Dai

#include "nbtheory.h"
#include "asn.h"
#include "dh.h"

DH::DH(const Integer &p, const Integer &g)
    : p(p), g(g)
{
}

DH::DH(RandomNumberGenerator &rng, unsigned int pbits)
{
    PrimeAndGenerator pg(rng, pbits);
    p = pg.Prime();
    g = pg.Generator();
}

DH::DH(RandomNumberGenerator &rng, unsigned int pbits, unsigned qbits)
{
    PrimeAndGenerator pg(rng, pbits, qbits);
    p = pg.Prime();
    g = pg.Generator();
}

DH::DH(BufferedTransformation &bt)
{
    BERSequenceDecoder seq(bt);
    p.BERDecode(seq);
    g.BERDecode(seq);
}

void DH::DEREncode(BufferedTransformation &bt) const
{
    DERSequenceEncoder seq(bt);
    p.DEREncode(seq);
    g.DEREncode(seq);
}

void DH::Setup(RandomNumberGenerator &rng, byte *publicValue)
{
    x.Randomize(rng, 2*DiscreteLogWorkFactor(p.BitCount()));
    Integer y = a_exp_b_mod_c(g, x, p);
    y.Encode(publicValue, OutputLength());
}

void DH::Agree(const byte *otherPublicValue, byte *out) const
{
    Integer otherPub(otherPublicValue, OutputLength());
    Integer agreedKey = a_exp_b_mod_c(otherPub, x, p);
    agreedKey.Encode(out, OutputLength());
}

