#include "Pilot.h"
#include "ssh.h"
#include "idea.h"

typedef struct {
    IDEA_KEY_SCHEDULE ks;
    unsigned char ivec[8];
} idea_state;

void ssh_idea_encrypt(unsigned char *in, unsigned char *out, long len,
    void *encryptstate_)
{
    idea_state *encryptstate = encryptstate_;
    int num = 0;

    idea_cfb64_encrypt(in, out, len, &(encryptstate->ks), encryptstate->ivec,
	&num, IDEA_ENCRYPT);
}

void ssh_idea_decrypt(unsigned char *in, unsigned char *out, long len,
    void *decryptstate_)
{
    idea_state *decryptstate = decryptstate_;
    int num = 0;

    idea_cfb64_encrypt(in, out, len, &(decryptstate->ks), decryptstate->ivec,
	&num, IDEA_DECRYPT);
}

void ssh_idea_clean(ssh_state *state)
{
    MemPtrFree(state->encryptstate);
    MemPtrFree(state->decryptstate);
    state->encrypt = NULL;
    state->decrypt = NULL;
    state->cryptclean = NULL;
}

void *ssh_idea_encryptstate(ssh_state *state, Erf erf, void *erfp)
{
    idea_state *encryptstate = MemPtrNew(sizeof(idea_state));
    if (!encryptstate) {
	ssh_fatal("Out of mem");
	return NULL;
    }
    idea_set_encrypt_key(state->sesskey, &(encryptstate->ks));
    MemSet(encryptstate->ivec, 8, 0);

    return encryptstate;
}

void *ssh_idea_decryptstate(ssh_state *state, Erf erf, void *erfp)
{
    return ssh_idea_encryptstate(state, erf, erfp);
}
