/**
   SSLServerSocket.java

   Copyright (C) 1999, Claymore Systems, Inc.
   All Rights Reserved.

   ekr@rtfm.com  Wed Jun  9 14:07:56 1999

   This package is a SSLv3/TLS implementation written by Eric Rescorla
   <ekr@rtfm.com> and licensed by Claymore Systems, Inc.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:
   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
   3. All advertising materials mentioning features or use of this software
      must display the following acknowledgement:
      This product includes software developed by Claymore Systems, Inc.
   4. Neither the name of Claymore Systems, Inc. nor the name of Eric
      Rescorla may be used to endorse or promote products derived from this
      software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
   FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
   OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
   OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
   SUCH DAMAGE.

   $Id: SSLServerSocket.java,v 1.3 1999/06/22 06:24:58 ekr Exp $

*/


package COM.claymoresystems.sslg.openssl;

import COM.claymoresystems.sslg.*;
import java.io.*;
import java.net.*;

public class SSLServerSocket extends java.net.ServerSocket {
     private long _ptr;
     private int localPort;
     private byte[] bindAddr=null;
     private SSLContext ctx;
     
     public SSLServerSocket(SSLContext ctx,int port, int backlog, InetAddress bindAddr)
       throws java.io.IOException {
       // Revolting hack because we must call the parent constructor
       super(port+1);
       super.close();

       this.ctx=ctx;
       localPort=port;
       if(bindAddr!=null)
	 this.bindAddr=bindAddr.getAddress();
       if((_ptr=nativeSSLServerSocket(ctx,port,backlog,this.bindAddr))==0)
	 throw new IOException("Couldn't make socket");
     }
     
     public SSLServerSocket(SSLContext ctx,int port)
       throws IOException {
       this(ctx,port,50);
     }

     public SSLServerSocket(SSLContext ctx,int port,int backlog)
       throws IOException {
       this(ctx,port,backlog,(InetAddress) null);
     }

     public String toString(){
       return "OpenSSL Socket: port "+localPort + "on address " +
	 ((bindAddr!=null)? bindAddr.toString() : "INADDR_ANY");
     }

     public Socket accept()
       throws IOException {
       long sock_ptr=nativeAccept();

       if(sock_ptr==0){
	 throw new IOException("Accept failure");
       }
	 
       return new SSLSocket(ctx,sock_ptr);
     }
     
     public native void close();
     public native void setSoTimeout(int timeout);
     public native int getSoTimeout();

     private native long nativeSSLServerSocket(SSLContext ctx,int port,
       int backlog,byte[] bindAddr);
     private native long nativeAccept();
     // Test code
     public static void main(String[] args)
       throws IOException {
       SSLPolicyInt policy=new SSLPolicyInt();
       policy.requireClientAuth(true);
       SSLContext ctx=new SSLContext();
       ctx.setPolicy(policy);
       ctx.loadRootCertificates("root.b64");
       ctx.loadEAYKeyFile("bookdsa.pem","password");
       SSLServerSocket sock=new SSLServerSocket(ctx,2311);

       for(;;){
       
	 Socket s=sock.accept();

	 InputStreamReader ir=new InputStreamReader(s.getInputStream());
	 BufferedReader br=new BufferedReader(ir);
	 
	 OutputStreamWriter or=new OutputStreamWriter(s.getOutputStream());
	 BufferedWriter bw=new BufferedWriter(or);

	 String req=br.readLine();

	 System.out.println(req);

	 String rsp="Server stuff";
	 bw.write(rsp,0,rsp.length());
	 bw.flush();
	 s.close();
	 System.out.println("Success");
       }

//       sock.close();
     }
     
}


