/**
   RSATest.java

   Copyright (C) 1999, Claymore Systems, Inc.
   All Rights Reserved.

   ekr@rtfm.com  Sun Jun 20 19:47:01 1999

   This package is a SSLv3/TLS implementation written by Eric Rescorla
   <ekr@rtfm.com> and licensed by Claymore Systems, Inc.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:
   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
   3. All advertising materials mentioning features or use of this software
      must display the following acknowledgement:
      This product includes software developed by Claymore Systems, Inc.
   4. Neither the name of Claymore Systems, Inc. nor the name of Eric
      Rescorla may be used to endorse or promote products derived from this
      software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
   FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
   OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
   OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
   SUCH DAMAGE.

   $Id:$

*/



package COM.claymoresystems.provider.test;

import java.io.*;
import java.security.*;

class RSATest {
     private static final byte[] testString={0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,
				0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,
				0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,
				0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,
				0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08
     };

    public static void main(String[] args) {
        /* Test generating and verifying a RSA signature */
        try {
            /* generate a key pair */

            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            Signature rsaSign = Signature.getInstance("RawRSA");
            Signature rsaVerify = Signature.getInstance("RawRSA");	    

            keyGen.initialize(1024, new SecureRandom(testString));
            KeyPair pair = keyGen.generateKeyPair();

	    PrivateKey priv=pair.getPrivate();
	    rsaSign.initSign(priv);

	    rsaSign.update(testString);

	    byte[] sig=rsaSign.sign();
	    COM.claymoresystems.util.Util.xdump("signature",sig);	    

	    PublicKey pub=pair.getPublic();
	    rsaVerify.initVerify(pub);
	    rsaVerify.update(testString);
	    boolean verifies=rsaVerify.verify(sig);
	    System.out.println("Verified: "+verifies);
        } catch (Exception e) {
            System.err.println("Caught exception " + e.toString());
	    e.printStackTrace(System.out);
	}
    }
}
