//aux disk reader sector loader for use from application, via DeviceIOControl(..)
//RING 0 code executiom

int unlockdrive(cryptvol* cv)
{

PDCB dcb=cv->filehostdcb ;// physdevDCB;
PIOP myiop;
PIOR myior;
USHORT offset;
USHORT size;
   if(!dcb) return -1;
    
     offset = (USHORT) (dcb->DCB_cmn.DCB_expansion_length+FIELDOFFSET(IOP,IOP_ior));
     size= offset+sizeof(IOR)+dcb->DCB_max_sg_elements*sizeof(SGD);
   	 myiop=IspCreateIop(size,offset,ISP_M_FL_MUST_SUCCEED|ISP_M_FL_SMART_ALLOC|ISP_M_FL_INTERRUPT_TIME|ISP_M_FL_PERSISTENT_IOP ); 
   	 myior=&myiop->IOP_ior;
	 myior->IOR_private_client=offset;
	 lockdrive(dcb,myiop,0);  //unlock it!
	 IspDeallocMem((PVOID) ((DWORD) myior-myior->IOR_private_client));

}


int lockdrive(PDCB mydcb,PIOP myiop,int lockmode)
{
PIOR myior;
int rstatus;
int iorop; 
if(!mydcb) return -1;
  
	if (lockmode) iorop=IOR_LOCK_MEDIA;
	else iorop=IOR_UNLOCK_MEDIA;


	if ((mydcb->DCB_cmn.DCB_device_flags&DCB_DEV_REMOVABLE) ==0)  
					return -1;

	
	myior=&myiop->IOP_ior;
	myiop->IOP_original_dcb=(ULONG) mydcb;
	myiop->IOP_physical_dcb=(ULONG) mydcb->DCB_cmn.DCB_physical_dcb;
	myior->IOR_next=0;
	myior->IOR_start_addr[1]=0;
	myior->IOR_flags=IORF_VERSION_002;
	myior->IOR_req_vol_handle=mydcb->DCB_cmn.DCB_vrp_ptr;
	myior->IOR_vol_designtr=mydcb->DCB_cmn.DCB_unit_number;
	myior->IOR_func=iorop; 
	myior->IOR_flags|=IORF_BYPASS_VOLTRK|IORF_HIGH_PRIORITY|IORF_SYNC_COMMAND;
	myior->IOR_start_addr[0]=0;//sector;
	myior->IOR_xfer_count=0; //numsectors;
	myior->IOR_buffer_ptr=(ULONG)appaccessbuffer;
	rstatus=myior->IOR_status;
	myiop->IOP_timer=40;
	myiop->IOP_timer_orig=40;

	if (IlbIntIoCriteria(myiop) ) 
			myior->IOR_flags|=IORF_DOUBLE_BUFFER;
 
	IlbInternalRequest(myiop,mydcb,0); 
	rstatus=myior->IOR_status;
	return rstatus;
}



int DiskRead(PDCB mydcb,PIOP myiop,unsigned int sector,unsigned int numsectors,char * buffr,USHORT iorop)

{

int rstatus=0;  //status return value.... 
PIOR myior; 
_BlockDev_Scatter_Gather* sgd;
 
	myior=&myiop->IOP_ior;
	myiop->IOP_original_dcb=(ULONG) mydcb;
	myiop->IOP_physical_dcb=(ULONG) mydcb->DCB_cmn.DCB_physical_dcb;
	myior->IOR_next=0;
	myior->IOR_start_addr[1]=0;
	myior->IOR_flags=IORF_VERSION_002;
	myior->IOR_req_vol_handle=mydcb->DCB_cmn.DCB_vrp_ptr;
	myior->IOR_sgd_lin_phys=(ULONG) (myior+1);
	myior->IOR_num_sgds=0;
	myior->IOR_vol_designtr=mydcb->DCB_cmn.DCB_unit_number;
	myior->IOR_func=iorop; 
	myior->IOR_flags|=IORF_BYPASS_VOLTRK|IORF_HIGH_PRIORITY|IORF_SCATTER_GATHER|IORF_SYNC_COMMAND;
	if (iorop==IOR_READ) 
				myior->IOR_flags|=IORF_DATA_IN;
	if (iorop==IOR_WRITE) 
				myior->IOR_flags|=IORF_DATA_OUT;
	myior->IOR_start_addr[0]=sector;
	myior->IOR_xfer_count=numsectors;
	myior->IOR_buffer_ptr=(ULONG) buffr;
  
	sgd=(_BlockDev_Scatter_Gather *) myior->IOR_sgd_lin_phys; //scatter gather array...
	sgd->BD_SG_Buffer_Ptr=(ULONG) buffr;  //Buffer in LOCKED ram, below 16mbyte, 4K boundary..
	sgd->BD_SG_Count=numsectors;
	myior->IOR_buffer_ptr=(ULONG) sgd;  //Implement as Scatter gather, with One block
	sgd++;
	sgd->BD_SG_Buffer_Ptr=NULL;
	sgd->BD_SG_Count=0;

	sgd++;
	myior->IOR_sgd_lin_phys=(ULONG) sgd;
	rstatus=myior->IOR_status;

     
	myiop->IOP_timer=40;
	myiop->IOP_timer_orig=40;

	if (mydcb->DCB_cmn.DCB_Sstor_Host==FALSE)


		{
		if (IlbIntIoCriteria(myiop) ) 
					myior->IOR_flags|=IORF_DOUBLE_BUFFER;
		IlbInternalRequest(myiop,mydcb,0); 
		rstatus=myior->IOR_status;
		return rstatus;
		}
 
 return 0;


}


int Try_All_Keys(PIOP iop, cryptvol *cv,char *extcritical)
{
int c;
int k;
char *thispass;
char *thisdigest;
k=pwnum&7;  //always use last key posted first!

 thispass=passes[k];
 thisdigest=digests[k];

	if (extcritical) // critical data posted in from key disk.....
		{
		if (decodeintialkeys(iop,cv,thispass,thisdigest,extcritical)!=0)   //reading boot sector ? 
				return 1;
		return 0;

		}

	for (c=0;c<8;c++)
	   {
	       thispass=passes[k];//8 passwordds
		   thisdigest=digests[k];
	       if (decodeintialkeys(iop,cv,thispass,thisdigest,NULL)!=0) return 1;   //reading boot sector ? 
	   
		   k++;
		   k&=7;
		} 
     
return 0;
}







 #pragma VxD_LOCKED_CODE_SEG

struct cryptvol * checkpartition(PIOP iop,partitionrec* pr)

{

 cryptvol * flag=0; 
 cryptvol *cv;
 PDCB dcb = (PDCB) iop->IOP_physical_dcb;

 char * peek= (char *) &pr->system;

   if (pr->system==0x74) // temp......

	 {
	  if (cv=addcryptedpartition(iop,peek))   
	    { 
	        flag=cv;
		}
	 }


 
return flag;

}


void tryvol(PDCB dcb,PIOP myiop,partitionrec *pr,char *extcritical)
{
cryptvol *cv;


   if (cv=checkpartition(myiop,pr))
			       {
	                if (cv->booted==0)
		     			if (Try_All_Keys (myiop,cv,extcritical)) 
						
							{
							Add_Drive(dcb,cv);
							cv->filehostdcb=dcb;
							lockdrive(cv->filehostdcb,myiop,1);
			                newpartitionmounted=1;
							}
						 else  
							{
							   memset(cv,0,sizeof(cryptvol));
								cv->cryptsectorfirst=0x7fffffff;
							   
							}  
				     } 

}



void UsePartitionInfo(PDCB dcb,PIOP myiop, char * diskbuffer,unsigned int relative,int recursed,char * extcritical)
{
// Not that this is recursive.....
partitionrec * pr;
char * c;
char * ndb;
c=diskbuffer;
ndb=c+512;  // next disk buffer
c+=0x1be;


	pr=(partitionrec *) c;  

	if (pr->system==5) 

		{
		if (!recursed) 
				relative=pr->StartSector;
		else 
			pr->StartSector+=relative;
		DiskRead(dcb,myiop,pr->StartSector,1,ndb,IOR_READ);
		UsePartitionInfo(dcb,myiop,ndb,relative,pr->StartSector,extcritical); //recursed, and also offset	
		}


	else 
		{

		if (recursed) 
			pr->StartSector+=recursed;
		tryvol(dcb,myiop,pr,extcritical); // partition 1


		}

	pr++;



	if (pr->system==5) 

		{
		if (!recursed) 
				relative=pr->StartSector;
		else 
				pr->StartSector+=relative;
		DiskRead(dcb,myiop,pr->StartSector,1,ndb,IOR_READ);
		UsePartitionInfo(dcb,myiop,ndb,relative,pr->StartSector,extcritical); //recursed, and also offset	
		}


	else 
		if(!recursed) 
		              tryvol(dcb,myiop,pr,extcritical); //partition 2


	if (recursed) return;


	pr++;
	tryvol(dcb,myiop,pr,extcritical);      //partition 3

	pr++;
	tryvol(dcb,myiop,pr,extcritical);     //partition 4

	}







void readallpartitions(char *extcritical) // go round every drive reading all the partitions....
{
int c=0;
PDCB dcb;
USHORT offset;
USHORT size;
PIOP myiop;
PIOR myior;


if (extcritical)
{
memcpy ( extcritdata,extcritical,2048);
extcritical=extcritdata;
}


while(dcb=dcblist[c+1])
	
  {
  
     if ( (dcb->DCB_cmn.DCB_device_type==0)&&(dcb->DCB_cmn.DCB_apparent_blk_shift==9) )
		{
        
		offset = (USHORT) (dcb->DCB_cmn.DCB_expansion_length+FIELDOFFSET(IOP,IOP_ior));
		size= offset+sizeof(IOR)+dcb->DCB_max_sg_elements*sizeof(SGD);
		myiop=IspCreateIop(size,offset,ISP_M_FL_MUST_SUCCEED|ISP_M_FL_SMART_ALLOC|ISP_M_FL_INTERRUPT_TIME|ISP_M_FL_PERSISTENT_IOP ); 
		myior=&myiop->IOP_ior;
		myior->IOR_private_client=offset;
		initiop.IOP_physical_dcb=(ULONG) dcb;
		DiskRead(dcb,myiop,0,1,partitiontestbuffer,IOR_READ);        //;single read in case of media change...
	 
		if (!DiskRead(dcb,myiop,0,1,partitiontestbuffer,IOR_READ))    //+32768 
	        {
		    UsePartitionInfo(dcb,myiop,partitiontestbuffer,0,0,extcritical); //+32768
		    }
		  
		IspDeallocMem((PVOID) ((DWORD) myior-myior->IOR_private_client));

		}

  c++;
  }

}



// the ring 0 code to allow 'diskscram.exe' access to the sectors...
int AppAccessBlockDevice(unsigned int devicenum,unsigned int sectorstart,unsigned int sectorlen,char *buffer, int mode)
{
PDCB dcb;
USHORT offset;
USHORT size;
PIOP myiop;
PIOR myior;
int status;
USHORT diskop;


if (mode==0) diskop=IOR_READ;
   else diskop=IOR_WRITE;		

     if (devicenum<128)
	 dcb=dcblist[devicenum+1];
	      else dcb=(PDCB) devicenum;


	 offset = (USHORT) (dcb->DCB_cmn.DCB_expansion_length+FIELDOFFSET(IOP,IOP_ior));
     size= offset+sizeof(IOR)+dcb->DCB_max_sg_elements*sizeof(SGD);
	 myiop=IspCreateIop(size,offset,ISP_M_FL_MUST_SUCCEED|ISP_M_FL_SMART_ALLOC|ISP_M_FL_INTERRUPT_TIME|ISP_M_FL_PERSISTENT_IOP );  
	 myior=&myiop->IOP_ior;
	 myior->IOR_private_client=offset;

	 DeviceNoCheckRM=1;    // removeable media test, read of partition map.....

	 if (diskop==IOR_WRITE) memcpy (appaccessbuffer,buffer,sectorlen*512);

     status=DiskRead(dcb,myiop,sectorstart,sectorlen,appaccessbuffer,diskop);  //mode later......

	 if (diskop==IOR_READ) memcpy (buffer,appaccessbuffer,sectorlen*512);

	 DeviceNoCheckRM=0;  

     IspDeallocMem((PVOID) ((DWORD) myior-myior->IOR_private_client));


	 return status;
}




int trymountfile(PDCB dcb,cryptvol *cv,char *extcritical)

{


USHORT offset;
USHORT size;
PIOP myiop;
PIOR myior;
int mounted=0;


   if (dcb->DCB_cmn.DCB_device_type==0)
	 {
        
	 offset = (USHORT) (dcb->DCB_cmn.DCB_expansion_length+FIELDOFFSET(IOP,IOP_ior));
     size= offset+sizeof(IOR)+dcb->DCB_max_sg_elements*sizeof(SGD);
   	 myiop=IspCreateIop(size,offset,ISP_M_FL_MUST_SUCCEED|ISP_M_FL_SMART_ALLOC|ISP_M_FL_INTERRUPT_TIME|ISP_M_FL_PERSISTENT_IOP ); 
   	 myior=&myiop->IOP_ior;
	 myior->IOR_private_client=offset;
	 initiop.IOP_physical_dcb=(ULONG) dcb;
    
	// put back for direct access
	 
	 //DiskRead(dcb,myiop,cv->cryptsectorfirst,1,appaccessbuffer,IOR_READ); //dummy read.....
	
	 if (Try_All_Keys (myiop,cv,extcritical)) 

	   {
         Add_Drive(dcb,cv);
		 mounted=1;
         lockdrive(cv->filehostdcb,myiop,1);

	   }
	 else 
        {
		  memset(cv,0,sizeof(cryptvol));
		  cv->cryptsectorfirst=0x7fffffff;
          mounted=0; 
	    }


	 IspDeallocMem((PVOID) ((DWORD) myior-myior->IOR_private_client));
     return mounted;
	 }



}

readnullfilesize (int hand)

{

	int bytes;
	char buffer [512];
	R0_ReadFile(FALSE,hand ,0,0, buffer,&bytes);					
}

void mountdiskfileR0(mountfilestruct * mf)
{

DWORD hfile;
DWORD action;
int code;
char *extcritical;
cryptvol *cv;
int c;
int writeable=1;
PDCB dcb;
int flag=0;
unsigned char  openflag=0x81;
dcb=mf->dcb;
installhook(); // only installs if not done already...




	for (c=0;c<4;c++)
		{
        cv=cryptvols[c];
		if (strcmp(mf->fname,(char *)&cv->mounted_file_name)==0)
		
			{
			mf->mountresult=3;  //already present 
			return;
			}


		}




		     
	if (mf->dcb)
	{
		if (!(mf->dcb->DCB_cmn.DCB_device_flags&DCB_DEV_WRITEABLE))

			writeable=0;

	}


	if (writeable)

	
		{
	
	 
		code=R0_OpenCreateFile(FALSE,ACCESS_READWRITE|SHARE_DENYREADWRITE,
			0,ACTION_OPENEXISTING,0x81,mf->fname,&hfile,&action); //R0_NO_CACHE(UBYTE) ((R0_NO_CACHE)>>8)
      

		if (code!=0)
			{
	   
			writeable=0;  
         	code=R0_OpenCreateFile(FALSE,ACCESS_READONLY|SHARE_DENYREAD,
				0,ACTION_OPENEXISTING,0x81,mf->fname,&hfile,&action); //R0_NO_CACHE(UBYTE) ((R0_NO_CACHE)>>8)
			}


		if (code==0)	 
				readnullfilesize(hfile);

		}
	else

		{
	 
	code=R0_OpenCreateFile(FALSE,ACCESS_READONLY|SHARE_DENYREAD,
		0,ACTION_OPENEXISTING,0x81,mf->fname,&hfile,&action); //R0_NO_CACHE(UBYTE) ((R0_NO_CACHE)>>8)
	  
	  if (code==0) 
			readnullfilesize(hfile);
	}
	



	if (code!=0)
		{
		mf->mountresult=1;
		return;
	    }
			


	for (c=0;c<4;c++)
	{
        cv=cryptvols[c];

		if (  (cv->booted==0) && (cv->physdevDCB==0)  )
		{		
			cv->filehostdcb=mf->dcb;
			cv->mountfilehandle=hfile;
			cv->physdevDCB=&cv->logicaldcb;
			cv->cryptsectorfirst=0x00000000;  
			cv->cryptsectorlast=0x7ffffff0; 			
			dcb=(PDCB)cv->physdevDCB;
			flag=1;
			dcb->DCB_cmn.DCB_device_flags=DCB_DEV_WRITEABLE;


		     if (mf->dcb)
				{
					if   (! (mf->dcb->DCB_cmn.DCB_device_flags&DCB_DEV_WRITEABLE)) 
							dcb->DCB_cmn.DCB_device_flags=0;

				}

			  cv->wavoffset=mf->wavoffset;
			
				if (mf->critical)
				{
				 memcpy ( extcritdata,mf->critical,2048);
				 extcritical=extcritdata;
				}
				else extcritical=NULL;



              if (trymountfile(dcb,cv,extcritical))  //clears cv set above if failed....
			      {
                    _asm cli
				    flag=3;
					mf->mountslot=c;
					mf->mountdrive=cv->drive;			
					mf->mountresult=flag;
					cv->devicetype|=256;
					cv->booted=2;
					strcpy((char *) &cv->mounted_file_name,mf->fname);
					return;
				   } //trymountfile
			      
          }//if cv->....
       if (flag) break; // out of for loop
      }
	mf->mountresult=flag;  // return status 0 no slots 1 won't mount, 2 mounted.
    R0_CloseFile(hfile);

} //mountdiskfiler0




int readblock3(int slot, char *buffer,int mode)

{
// used to read infoblock.......

USHORT offset;
USHORT size;
PIOP myiop;
PIOR myior;
PDCB dcb;
cryptvol*cv=cryptvols[slot];

   if ((dcb=cv->physdevDCB)&&(cv->booted))
	 {
       offset = (USHORT) (dcb->DCB_cmn.DCB_expansion_length+FIELDOFFSET(IOP,IOP_ior));
       size= offset+sizeof(IOR)+dcb->DCB_max_sg_elements*sizeof(SGD);
   	   myiop=IspCreateIop(size,offset,ISP_M_FL_MUST_SUCCEED|ISP_M_FL_SMART_ALLOC|ISP_M_FL_INTERRUPT_TIME|ISP_M_FL_PERSISTENT_IOP ); 
   	   myior=&myiop->IOP_ior;
	   myior->IOR_private_client=offset;
	   initiop.IOP_physical_dcb=(ULONG) dcb;
       

#if R0FILES

	   if (!cv->mountfilehandle) // remove for direct disk access......
#endif
	   DiskRead(dcb,myiop,cv->cryptsectorfirst,1,appaccessbuffer,IOR_READ); //dummy read.....
	
	   if (mode==0)
	     {
		 readlogical (myiop,3,1,appaccessbuffer,cv);
         memcpy(buffer,appaccessbuffer,512);  
	     }
	   else 
  
	     {
	     memcpy(appaccessbuffer,buffer,512);
	     writelogical (myiop,3,1,appaccessbuffer,cv);
	     }
		IspDeallocMem((PVOID) ((DWORD) myior-myior->IOR_private_client));
		return 1;
	  }

}

 


void appaccessrzero(file_r0 * f)
{

	DWORD hfile;
	DWORD action;
	int bytes;

	if (f->mode==0)
	{
		if (f->drivenum<0x100)
		{
			_VolFlush(f->drivenum,VOL_DISCARD_CACHE);
		}

      f->status=R0_OpenCreateFile(FALSE,ACCESS_READONLY|SHARE_DENYREADWRITE,
						0,ACTION_OPENEXISTING,1,f->fname,&hfile,&action);
	  f->handle=hfile;
	
	  return;
	
    }

	if (f->mode==1)	//read

		{
		_VolFlush(f->drivenum,VOL_DISCARD_CACHE);
		f->status=R0_ReadFile(FALSE, f->handle,f->size,f->filepos, f->buffer,&bytes);
		f->bytes=bytes;
		return;
		}

	 if (f->mode==2)
		{
		f->status=R0_CloseFile(f->handle);
		return;
		}


}

int filerecursed=0;


typedef struct msfr
{

	ULONG ns;
	ULONG s;
	cryptvol *cv;
	char * bu;

}msfr;


int rfx;

int rf(msfr* r)
{
	int bytes;
	rfx= R0_ReadFile(FALSE, r->cv->mountfilehandle,r->ns<<9,r->s<<9, r->bu,&bytes);				
		
}

char numberstr[32];
char wpstr[]=
{
"Logical scrambled disk drive  :\n\n" //don't alter this line!
"Scramdisk has detected new write protection on a formerly writeable\n"
"physical disk drive, storing a file it is using to host a scrambled\n"
"logical disk.\n\n"
"Write protection will remain active,on this disk until the volume is\n" 
"dismounted.\n\n"
"You must remove the host disk's write protection, dismount and\n"
"remount the scrambled disk volume file, in order to write to it once\n"
"again."

};

void makehex(char * str,unsigned int num)

{

char hv;
char hex[]=
	{
	"0123456789ABCDEF"
	};
int c;

for (c=0;c<4;c++)
  {
   hv=num&15;
   hv=hex[hv];
   num=num>>4;
   str [3-c]=hv;
  }

str [4]=0;


}



int testr0=0;

int syx=0;

#define MBYTE32 32768 //4
#define WAVPAGESIZE 129
	int WAV_Readfile(cryptvol *cv,int numsectors,int sector, char * buffer, int *bytes, int oldp)
	{
		int res; 
		int bytes2=0;
		int x;
		if (wavbufferptr==NULL)
		wavbufferptr= (char *)	_PageAllocate(WAVPAGESIZE,PG_SYS,NULL,0,0,MBYTE32,NULL,PAGEZEROINIT|PAGEFIXED|PAGECONTIG|PAGEUSEALIGN);
		if (wavbufferptr==NULL)
				return 0;  // NO BUFFER NO CAN DO....
		
		

	
			if ((cv->wavoffset&0x80000000)==0)
				{
				res= R0_ReadFile(FALSE,cv->mountfilehandle ,numsectors*1024,(sector*1024)+( (cv->wavoffset&0x7fffffff) ), wavbufferptr,&bytes2);				
				for (x=0;x<(numsectors*512);x++)
					buffer[x]=wavbufferptr[x<<1];

				}

			else
				{
				res= R0_ReadFile(FALSE,cv->mountfilehandle ,numsectors*2048,(sector*2048)+( (cv->wavoffset&0x7fffffff) ), wavbufferptr,&bytes2);				
				for (x=0;x<(numsectors*512);x++)
					{
						_asm
						{
							mov ecx,[x]
							mov ebx,[wavbufferptr]
							mov al,[ebx+ecx*4]
							and al,0xf
							mov ah,[2+ebx+ecx*4]
							and ah,0xf
							shl ah,4
							or al,ah
							mov edx,[buffer]
							mov [edx+ecx],al


						}
					 }

			
				}

		return res;
	}






	int WAV_Writefile2(cryptvol *cv,int numsectors,int sector, char * buffer, int *bytes, int oldp)
	{

		// 4 bit write....
		int res,res2;
		int bytes2=0;
		int x,smalloffset,dataend,wrsector;

		
	
		if (wavbufferptr==NULL)
		           wavbufferptr= (char *)	_PageAllocate(64,PG_SYS,NULL,0,0,MBYTE32,NULL,PAGEZEROINIT|PAGEFIXED|PAGECONTIG|PAGEUSEALIGN);
		if (wavbufferptr==NULL)
		{
		
			return 0;		
		}
		
		numsectors*=512;      //  # bytes
		dataend=numsectors;   // end of bytes
 	
		smalloffset=cv->wavoffset&511; // offset of data in file....

		if (smalloffset) numsectors+=512; // allow another loaded .... block...
		
		
		wrsector=sector*2048; ////1024;             // base address of sector...

		wrsector+=((cv->wavoffset&0x7fffffff)/512);    // if  a big offset....

	
	 
		numsectors=numsectors<<2; //<<1

       res= R0_ReadFile(FALSE,cv->mountfilehandle,numsectors,wrsector,wavbufferptr,&bytes2);				

	  
	   for (x=0;x<dataend;x++) 
	   {
		  
			_asm
			{

			mov ecx,[x]
			mov edx,[buffer]
			mov ebx,[wavbufferptr]
			add ebx,[smalloffset]
			mov al,[edx+ecx]
			mov ah,al
			and al,15;
			and [ebx+ecx*4],0xf0
			or  [ebx+ecx*4],al
			shr ah,4
			and [2+ebx+ecx*4],0xf0
			or  [2+ebx+ecx*4],ah

			}
		  

	   }



	 

	  res2=R0_WriteFile(FALSE,cv->mountfilehandle,numsectors,wrsector,wavbufferptr,&bytes2);					

	return res2;
	}








	int WAV_Writefile(cryptvol *cv,int numsectors,int sector, char * buffer, int *bytes, int oldp)
	{
	
		int res,res2;
		int bytes2=0;
		int x,smalloffset,dataend,wrsector;

		
		if ((cv->wavoffset&0x80000000)!=0) 
			{
			return (WAV_Writefile2(cv,numsectors,sector,buffer,bytes,oldp));
			}
		
		if (wavbufferptr==NULL)
		           wavbufferptr= (char *)	_PageAllocate(64,PG_SYS,NULL,0,0,MBYTE32,NULL,PAGEZEROINIT|PAGEFIXED|PAGECONTIG|PAGEUSEALIGN);
		if (wavbufferptr==NULL)
		{
		
			return 0;		
		}
		
		numsectors*=512;      //  # bytes
		dataend=numsectors;   // end of bytes
 	
		smalloffset=cv->wavoffset&511; // offset of data in file....

		if (smalloffset) numsectors+=512; // allow another loaded .... block...
		
		
		wrsector=sector*1024;             // base address of sector...

		wrsector+=((cv->wavoffset&0x7fffffff)/512);    // if  a big offset....

	
	 
		numsectors=numsectors<<1;

       res= R0_ReadFile(FALSE,cv->mountfilehandle,numsectors,wrsector,wavbufferptr,&bytes2);				
 	  
	   for (x=0;x<dataend;x++) 
	   {
		   wavbufferptr[(x<<1)+smalloffset]=buffer[x];
			
	   }


	 


	  res2=R0_WriteFile(FALSE,cv->mountfilehandle,numsectors,wrsector,wavbufferptr,&bytes2);					
	  
	return res2;
	}












int doR0fileio(int sector,int numsectors,char * buffer,cryptvol * cv,int iorop)
{

CLIENT_STRUCT sregs; //static
PVRP v;

    

	
	int res;
    int bytes;		//static

	int oldp;  // snap of p


		
	if (iorop==IOR_READ)
	{		
		
		if (numsectors)
		  {
		 
			SaveClientState( (CLIENT_STRUCT *) &sregs); 
		

			
			if (cv->wavoffset==0)

			
				res= R0_ReadFile(FALSE,cv->mountfilehandle ,numsectors<<9,sector<<9, buffer,&bytes);				
			

			
			
			else
				res=WAV_Readfile(cv,numsectors,sector,buffer,&bytes,oldp);

			
			RestoreClientState((CLIENT_STRUCT *) &sregs); 
		
		  }//num sectors

	
		 
		  return res;  //r

}//IOR read

	res=0;
	if (iorop==IOR_WRITE);
	{
	 if (numsectors)
	
     	  {
			SaveClientState( (CLIENT_STRUCT *) &sregs); 
			
	
			
		 if (cv->wavoffset==0)
		
		   {
		   res= R0_WriteFile(FALSE,cv->mountfilehandle,numsectors*512,sector*512,buffer,&bytes);
	 
		   }
	
		 else   res=WAV_Writefile(cv,numsectors,sector,buffer,&bytes,oldp);		 
		 
		 RestoreClientState((CLIENT_STRUCT *) &sregs); 
	     
	       }

	   if (res) 
	    {
		 
		//   makehex (numberstr,(unsigned int) res); 	
		// makehex (numberstr,(unsigned int) sector);
		// strcat (numberstr," Error! ");
		// ShellMessageNCB(0,numberstr,"Scramdisk: Mounted file error");
		 
		 
	
		 if (res==5) res=0x13;  // WHY ARE WE GETTING ACCESS DENIED 005 ON CD RATHER THAN WP ?
		 
		 
		 
		 if (res==0x13) 
		    {
		
			 if (cv->booted>=2)  
				
			{
			   v=(PVRP) cv->ldcb->DCB_cmn.DCB_vrp_ptr;
		       if (v) 
					{
				     if ((v->VRP_event_flags&VRP_ef_write_protected)==0)
					    {
						    v->VRP_event_flags|=VRP_ef_write_protected|VRP_ef_media_uncertain; 		 
							wpstr[29]=cv->drive+'A';
							ShellMessageNCB(0,wpstr,"Scramdisk: Write protect error");
					     }
					 
			         }
		
		       }//cv->booted
	        	   
			  else initialiseWPerror=1;
		 
		   }//res=13

	   } //res= something

	  
	
	   return res; //r
	} //IOR write

	return 0;
}


void SDDelete(char *name)

{
	R0_DeleteFile(name,0);
}


int MapDosError(int error)
{

	
int e;

	if (error==0x13) return(IORS_WRITE_PROTECT);
	
	e=IORS_NOT_READY; //IORS_HW_FAILURE; 	
	return e;		  // OH SOD IT....

	switch ( error )
	{


	case 1:
	case 12:
	e=IORS_INVALID_COMMAND; 	//Command not supported or invalid. 
	break;


	case 11:
	e=IORS_INVALID_PARM; 	//Invalid parameter. 
	break;

	case 23:
	e=IORS_MEDIA_ERROR; 	//Media failure. 
	break;
	
	case 21:
	e=IORS_NO_MEDIA; 	//Media removed from device. 
	break;


	case 39:
	e=IORS_OUT_OF_SPACE; 	//No space on media. 
	break;
	case 19:
	e=IORS_WRITE_PROTECT; 	//Write protect error. 
	break;

	case 17:
	e=IORS_WRONG_MEDIA; 	//Wrong media in drive. 
	break;

	default:

	e=IORS_UNREC_ERROR; 	

	}

	return e;

}
