#define _POSIX_SOURCE
#include <sys/types.h>	/* pid_t */
#include <unistd.h>	/* write getpid */
#include <stdio.h>
#include <string.h>	/* memset memcmp */
#include <ctype.h>	/* isspace */
#include <stdlib.h>	/* exit free (after ctype.h for BSDI BSD/386) */
#include <time.h>
#include <fcntl.h>
#include <ndbm.h>
#include "deslogin.h"
#include "dlg2dbm.h"

char* progName;
int debug = 0;
int verbose = 0;
extern int optind;
extern char* optarg;

typedef struct {
   char     iv[DES_BLOCKSIZE];
   unsigned ivlen;
   keyType  key;
   int 	    mode;
} cipherState;

cipherKey mkCipherKey(key, mode)
   keyType key;
   int mode;
{
   cipherState *cs =(cipherState *)malloc(sizeof (cipherState));

   if (cs != (cipherState *) 0) {
      memset(cs->iv, '\0', DES_BLOCKSIZE);
      cs->ivlen = DES_BLOCKSIZE;
      cs->key   = key;
      cs->mode  = mode;
   }
   return (cipherKey) cs;
}

void destroyCipherKey(c)
   cipherKey *c;
{
   register cipherState *cs = * (cipherState **) c;

   if (cs != (cipherState *) 0) {
      memset(cs->iv, '\0', DES_BLOCKSIZE);
      cs->ivlen = 0;
      cs->key   = (keyType) 0;
      cs->mode  = 0;
      free(cs);
      *c = (cipherKey) 0;
   }
}

void cipherData(dst, src, size, c)
   char *dst, *src;
   unsigned size;
   cipherKey c;
{
   register cipherState *cs = (cipherState *) c;

   if (cs->key != (keyType) 0) {
      cs->ivlen = desCFB(dst, src, size, cs->iv, cs->ivlen, cs->key, cs->mode);
   } else {
      memcpy(dst, src, size);
   }
}

/*
 * Convert a string of bytes to their hex representation
 */
char *hexData(dst, src, size)
   register char *dst, *src;
   register unsigned size;
{
   register char *chp = dst;
   if (size != 0) do {
      sprintf(chp, "%.2x", * (unsigned char *) src++);
      chp += 2;
   } while (--size != 0);
   return dst;
}

/*
 * Create a key from a keyString
 *
 * Mode: 0 = encrypt, 1 = decrypt
 */
keyType mkKey(keyString) 		
   char *keyString;
{
   char 	keybits[DES_BLOCKSIZE];
   keyType key = (keyType) 0;

   desKey(keybits, keyString, ' ');		/* hash string into 64-bits */
   desMakeKey(&key, keybits, DES_BLOCKSIZE, 0);	/* always encrypt for CFB */
   memset(keybits, '\0', DES_BLOCKSIZE);
   return key;
}

/*
 * Perform one DES encryption(decryption if mode nonzero) (ECB mode)
 *
 * Dst and src must be exactly DES_BLOCKSIZE bytes long.
 */
void cipherKeyString(dst, src, keyString, mode)
   char *dst, *src, *keyString;
   int mode;			/* 0 = encipher, 1 = decipher */
{
   char 	keybits[DES_BLOCKSIZE];
   keyType key = (keyType) 0;

   desKey(keybits, keyString, ' ');		/* hash string into 64-bits */

   desMakeKey(&key, keybits, DES_BLOCKSIZE, mode);
   memset(keybits, '\0', DES_BLOCKSIZE);

   des(dst, src, key);
   desDestroyKey(&key);
}

int main(argc,argv)
int argc;
char *argv[];
{
 char userFile[128],userFilePhrase[PHRASE_SIZE+1];
 char dbmFile[128],dbmFilePhrase[PHRASE_SIZE+1];
 char username[32+1],userpassphrase[PHRASE_SIZE+1];  
 keyType userFileKey = 0;
 keyType dbmFileKey = 0;
 int res,state = 0;
 FILE *f;
 char dbmdata[PHRASE_SIZE+1],dbmkey[32+1];
 char tempdata[PHRASE_SIZE+1],tempkey[32+1];
 int c,size,i,chopt;
 char *chp;
 char ch,cipherChar;
 char dbmc,dbmcc,*dbmchp;
 cipherKey ck = (cipherKey) 0;
 DBM* dbmf;
 datum k,d;
 int uf = 0, df = 0;

 while ((chopt = getopt(argc, argv, "ho:i:")) != EOF) switch (chopt) {
   case 'i':
      strcpy(userFile,optarg);
      uf = 1;
      break;
   case 'o':
      strcpy(dbmFile,optarg);
      df = 1;
      break;
   case 'h':
      fprintf(stderr,"Usage: dlg2dbm -i userfile -o dbmfile\n");
      exit(0);
   }

 if ( !uf)
 {
  fprintf(stderr,"Insert userfile name: ");
  gets(userFile);
 }
 res = askTty("Insert userfile passphrase: ",userFilePhrase,PHRASE_SIZE-1,0);
 if (res)
 {
  userFileKey = mkKey(userFilePhrase);
  memset(userFilePhrase,'\0',strlen(userFilePhrase));
  if (userFileKey == (keyType) 0)
  {
   fprintf(stderr,"Userfile key error.\n");
   return(-1);
  }
 }
 else
  fprintf(stderr,"Plain userfile.\n");
 
 if ( !df)
 {
  fprintf(stderr,"Insert NDBM file name: ");
  gets(dbmFile);
 }
 res = askTty("Insert NDBM file passphrase: ",dbmFilePhrase,PHRASE_SIZE-1,0);
 if (res)
 {
  dbmFileKey = mkKey(dbmFilePhrase);
  memset(dbmFilePhrase,'\0',strlen(dbmFilePhrase));
  if (dbmFileKey == (keyType) 0)
  {
   fprintf(stderr,"NDBM key error.\n");
   return(-1);
  }
 }
 else
  fprintf(stderr,"Plain NDBM file.\n");

 f = fopen (userFile,"r");
 if (f == NULL)
 {
  fprintf(stderr,"ERROR: can't open userfile.\n");
  return(-1);
 } 
 
 dbmf = dbm_open(dbmFile,O_RDWR,0600);
 if (dbmf == (DBM*) NULL)
 {
  fprintf(stderr,"ERROR: can't open NDBM file.\n");
  fclose(f);
  return(-1);
 } 

 ck = mkCipherKey(userFileKey,1);

 while ((c = getc(f)) != EOF) 
 {
  cipherChar = (char) c;
  cipherData (&ch,&cipherChar,1,ck);
  
  switch(state)
  {
      case 0:
	 if (ch == '#') { 
	    state = 1;
	    break;
	 } 
	 chp = username;
         for (i = 0; i <= 32; i++)
          username[i] = 0;
	 state = 2;			/* fall through */
      case 2:				/* user field leading whitespace */
         if (ch == '\n') state = 0;
	 if (ch == '#') {
	    state = 1;
	    break;
	 }
	 if (isspace(ch)) break;	/* newline is also whitespace */
	 state = 3;			/* fall through */
      case 3:				/* user field */
         if (!isspace(ch)) 
  	 {
	  *chp++ = ch;
	 } 
         else 
         {
	  *chp = '\0'; 		/* match? */
	  state = 4;
	 }
	 break;
      case 1:				/* skip remainder of line */
         if (ch == '\n') state = 0;
	 break;
      case 4:				/* passphrase leading whitespace */
	 if (isspace(ch)) break;
	 state = 5;			/* fall through */
	 chp = userpassphrase;
         for (i = 0; i <= PHRASE_SIZE; i++)
          userpassphrase[i] = 0;
         size = PHRASE_SIZE;
      case 5:				/* passphrase */
	 if (ch == '\n') {
	    if (size != 0) *chp = '\0';
	    state = 0;
            ndbm_cipherstring(dbmkey,username,32,dbmFileKey,0);
            ndbm_cipherstring(dbmdata,userpassphrase,PHRASE_SIZE,dbmFileKey,0);
            k.dptr = dbmkey;
            k.dsize = 32;
            d.dptr = dbmdata;
            d.dsize = PHRASE_SIZE;
            res = dbm_store(dbmf,k,d,DBM_INSERT);
            if (res < 0)
            {
             printf("Database error.\n");
             fclose(f);
             dbm_close(dbmf);
             return(-1);
            }
            if (res == 1)
            {
             fprintf(stderr,"Warning duplicated entry : %s\n",username);
            }
	 }  else {
	    if (size != 0) {
	       *chp++ = ch;
	       --size;
	    }
	 }
	 break;
  }
 }
 
 destroyCipherKey(&ck);
 dbm_close(dbmf);
 fclose(f);
}


int ndbm_cipherstring(dest, src, len, key, mode)
   char *dest;
   char *src;
   int len;
   keyType key;
   int mode;
{
 cipherKey ck;

 ck = mkCipherKey(key,mode);
 cipherData(dest,src,len,ck);
 destroyCipherKey(&ck);
}
