/* pkcrack - stage2.c
 *
 * (C) by Peter Conrad <conrad@unix-ag.uni-kl.de>
 *
 * $Id: stage2.c,v 1.7 1996/08/21 18:06:16 conrad Release1_2 $
 *
 * $Log: stage2.c,v $
 * Revision 1.7  1996/08/21 18:06:16  conrad
 * Some cleanups to suppress some warnings...
 *
 * Revision 1.6  1996/08/15 10:22:44  conrad
 * changed meaning of i in buildkey0list() a little
 * reduced chances for double hits in buildkey1list() and recursion1()
 *
 * Revision 1.5  1996/08/13 13:22:18  conrad
 * Removed call to findPwd
 * More plaintext used to determine correctness of key (after receiving reports
 * of false hits).
 * Some changes to support offset (-o)
 * Changed one line because of a bug in VisualC++ optimizer.
 *
 * Revision 1.4  1996/06/23 10:38:32  lucifer
 * stage2 can now be called with key2i values for any i in the plaintext.
 * This is for improved efficiency (see main.c)
 *
 * Revision 1.3  1996/06/12  09:47:24  conrad
 * Release version
 *
 * Revision 1.2  1996/06/11 10:28:53  conrad
 * moved fflush() a couple of lines to the front, so key[012] values
 * get printed as soon as they are found.
 *
 * Revision 1.1  1996/06/10 18:04:36  conrad
 * Initial revision
 *
 */

static char RCSID[]="$Id: stage2.c,v 1.7 1996/08/21 18:06:16 conrad Release1_2 $";

#include <stdio.h>
#include "pkcrack.h"
#include "crc.h"
#include "mktmptbl.h"
#include "keystuff.h"

#define	CONST		0x08088405	/* 134775813 */
#define	INVCONST	0xd94fa8cd	/* CONST^{-1} */

#define	MULT(x)		((mulTab[((x)>>24)&0xff]<<24) + \
			 (mulTab[((x)>>16)&0xff]<<16) + \
			 (mulTab[((x)>> 8)&0xff]<< 8) + \
			 (mulTab[((x)    )&0xff]    ))

static uword	mulTab[256];
static byte	mTab2[256][16];
static int	mTab2Counter[256];

static uword key2list[13], key1list[13], key0list[13];
static int   numTestBytes, minimalOffset;

uword	loesung0=0, loesung1=0, loesung2=0;

static void buildkey0list( )
/* From 4 consecutive LSBs of key0 build a complete key0 value.
 * See section 3.4 of the Biham/Kocher paper.
 */
{
int	i;
uword	temp;

    temp = key0 = key0list[4];
    updateKeys( plaintext[4+bestOffset-12] );
    temp ^= ((key0^key0list[5])&0xff)<<8;
    key0 = temp;
    updateKeys( plaintext[4+bestOffset-12] );

    temp = key0;
    updateKeys( plaintext[5+bestOffset-12] );
    temp ^= ((key0^key0list[6])&0xff)<<8;
    key0 = temp;
    updateKeys( plaintext[5+bestOffset-12] );

    temp = key0;
    updateKeys( plaintext[6+bestOffset-12] );
    temp ^= ((key0^key0list[7])&0xff)<<8;
    key0 = temp;
    updateKeys( plaintext[6+bestOffset-12] );

    temp = key0;
    updateKeys( plaintext[7+bestOffset-12] );
    temp ^= ((key0^key0list[8])&0xff)<<8;
    key0 = temp;

    /* Now we have the full value of key0_7 */
    /* Check if it is valid by computing key0_{[8..12]} and comparing to
     * the known LSBs */
    i = 7;
    key1 = key1list[i];
    key2 = key2list[i];
    do{
	updateKeys( plaintext[i+bestOffset-12] );
	i++;
    } while( i < 13 && (key0&0xff) == (key0list[i]&0xff) );

    i -= 12;
    /* Do some more checking if we have more testbytes available. */
    while( i < numTestBytes && 
	   (ciphertext[i+bestOffset]^key3) == plaintext[i+bestOffset] )
    {
	updateKeys( plaintext[i+bestOffset] );
	i++;
    }

    if( i == numTestBytes )
    { /* Got it! Now calculate backwards 'til key0_0... */
	i += bestOffset;
	do{
	    key2 = INVCRC32(key2,(key1>>24)&0xff);
	    temp = (key2 & 0xffff)|3;
	    key3 = ((temp*(temp^1))>>8)&0xff;
	    if( i <= minimalOffset )
		plaintext[i-1] = ciphertext[i-1]^key3;
	    key1 = MULT(key1-1)-(key0&0xff);
	    key0 = INVCRC32(key0,plaintext[i-1]);
	    /*printf( "%2d %8x %8x %8x\n", i-1, key0, key1, key2 );*/
	    i--;
	}while( i > 0 && plaintext[i] == (ciphertext[i]^key3) );

	if( i == 0 )
	{
	    loesung0 = key0;
	    loesung1 = key1;
	    loesung2 = key2;
	    printf( "Ta-daaaaa! key0=%8x, key1=%8x, key2=%8x\007\n", key0, key1, key2 );
	    printf( "Probabilistic test succeeded for %d bytes.\n", numTestBytes+12-8 );
	    fflush( stdout );
	}
    }
    else if( i >= 1 )
    {
	fprintf( stderr, "Strange... had a false hit.\n" );
	fflush( stderr );
    }
}

static void recursion1( int i )
/* given a value for key1_i, compute all possible values of key1_{i-1} that
 * fit the MSB of key1_{i-2} */
{
int	k, hadit=0;
uword	MSBiminus1, MSBiminus2, lsbkey0, lsbkey0pluskey1iminus1, test, temp2;
uword	oldval;
byte	diff;

    if( i == 3 )
    {
	buildkey0list( );
	return;
    }

    MSBiminus1 = key1list[i-1]&0xff000000;
    MSBiminus2 = key1list[i-2]&0xff000000;
    lsbkey0pluskey1iminus1 = MULT(key1list[i]-1);
    temp2 = MULT(lsbkey0pluskey1iminus1-1);
    diff = (((temp2&0xff000000)-MSBiminus2)>>24)&0xff;
    for( k = 0; k < mTab2Counter[diff]; k++ )
    {
	test = temp2 - mulTab[mTab2[diff][k]];
	if( test >= MSBiminus2 && test <= MSBiminus2 + 0x010000fe )
	{
	    lsbkey0 = mTab2[diff][k];
	    key1list[i-1] = lsbkey0pluskey1iminus1-lsbkey0;
	    key0list[i]   = lsbkey0;
	    if( !hadit || key1list[i-1] != oldval )
	    {
		oldval = key1list[i-1];
		hadit = 1;
		recursion1( i-1 );
	    }
	}
    }
    diff--;
    for( k = 0; k < mTab2Counter[diff]; k++ )
    {
	test = temp2 - mulTab[mTab2[diff][k]];
	if( test >= MSBiminus2 && test <= MSBiminus2 + 0x010000fe )
	{
	    lsbkey0 = mTab2[diff][k];
	    key1list[i-1] = lsbkey0pluskey1iminus1-lsbkey0;
	    key0list[i]   = lsbkey0;
	    if( !hadit || key1list[i-1] != oldval )
	    {
		oldval = key1list[i-1];
		hadit = 1;
		recursion1( i-1 );
	    }
	}
    }
    key1list[i-1] = MSBiminus1;
}

static void buildkey1list( )
/* Find all values for key1_12 that produce the correct MSB for key_11
 * See section 3.3 of the Biham-Kocher paper. */
{
uword	i, j, k, hadit=0;
uword	test, MSBi, MSBiminus1, temp, temp2, oldval;
byte	diff;

    MSBi = key1list[12] & 0xff000000;
    MSBiminus1 = key1list[11] & 0xff000000;
    test = (MSBi-1)*INVCONST;
    if( test >= MSBiminus1 && test <= MSBiminus1 + 0x010000fe )
    {
	key1list[12] = MSBi;
	recursion1( 12 );
	oldval = MSBi;
	hadit = 1;
    }

    /* There's 2^24 possible values for key1_12, given its MSB.
     * We check them all, substitution multiplications by table-lookup and add
     * to save time */
    temp = mulTab[(MSBi>>24)&0xff]<<24;
    for( i = 0; i < 256; i++ )
	for( j = 0; j < 256; j++ )
	{
	    temp2 = temp + (mulTab[i]<<16) + (mulTab[j]<<8);
	    diff = ((MSBiminus1 - (temp2&0xff000000))>>24)&0xff;
	    for( k = 0; k < mTab2Counter[diff]; k++ )
	    {
		test = temp2 + mulTab[mTab2[diff][k]];
		if( test >= MSBiminus1 && test <= MSBiminus1 + 0x010000fe )
		{
		    key1list[12] = MSBi + (i<<16) + (j<<8) + mTab2[diff][k] + 1;
		    if( !hadit || oldval != key1list[12] )
		    {
			oldval = key1list[12];
			recursion1( 12 );
			hadit = 1;
		    }
		}
	    }
	    diff--;
	    for( k = 0; k < mTab2Counter[diff]; k++ )
	    {
		test = temp2 + mulTab[mTab2[diff][k]];
		if( test >= MSBiminus1 && test <= MSBiminus1 + 0x010000fe )
		{
		    key1list[12] = MSBi + (i<<16) + (j<<8) + mTab2[diff][k] + 1;
		    if( !hadit || oldval != key1list[12] )
		    {
			oldval = key1list[12];
			recursion1( 12 );
			hadit = 1;
		    }
		}
	    }
	}
    key1list[12] = MSBi;
}

static void recursion2( int i )
/* Calculate key2_{i-1} from key2_i, key3_{i-1} and key3_{i-2},
 * calculate MSB of key1_i */
{
int	k, l;
byte	key3iminus1, key3iminus2, hadIt=0;
uword	key2j, key2iminus1, key2iminus2, newKey, oldValue;

    if( i == 1 )
    {
	buildkey1list( );
	return;
    }

    key3iminus1 = KEY3(i+bestOffset-12-1);
    key3iminus2 = KEY3(i+bestOffset-12-2);
    /* This works exactly like reduceKey2s in stage 1 */
    key2j = key2list[i];
    key2iminus1 = INVCRC32(key2j,0)&0xffffff00;
    for( k = 0; k < 64; k++ )
	if( (tempTable[key3iminus1][k]&0xff00) == (key2iminus1&0xff00) )
	{
	    newKey = key2iminus1|tempTable[key3iminus1][k]; /* b) */
	    key2iminus2 = INVCRC32(newKey,0)&0xfc00;
	    for( l = 0; l < 64; l++ )
		if( (tempTable[key3iminus2][l]&0xfc00) == key2iminus2 )
		{
		    newKey = key2iminus1|(((tempTable[key3iminus2][l]^crcinvtab[(key2iminus1>>24)&0xff])>>8)&0xff); /* c) (and b) */
		    if( !hadIt || oldValue != newKey )
		    {
			key2list[i-1] = newKey;
/* The following line was changed because VisualC++ has a bug in its
 * Optimizer...
 *			key1list[i] = (((key2j<<8)^crcinvtab[(key2j>>24)&0xff]^newKey)&0xff)<<24;*/
			key1list[i] = (crcinvtab[key2j>>24]^newKey)<<24;
			recursion2( i-1 );
			oldValue = newKey;
			hadIt = 1;
		    }
		}
	}
}

void buildKey2Lists( uword aKey2_13, int testBytes, int minOffset )
{
    numTestBytes = testBytes;
    minimalOffset = minOffset;
    key2list[12] = aKey2_13;
    recursion2( 12 );
}

void initMulTab( )
{
uword	i, prod;
byte	j;

    for( i = 0; i < 256; i++ )
    {
	mTab2Counter[i] = 0;
	mTab2[i][0] = 0;
    }

    for( i = 0; i < 256; i++ )
    {
	prod = i*INVCONST;
	mulTab[i] = prod;
	j = (prod>>24)&0xff;
	mTab2[j][mTab2Counter[j]++] = i;
	mTab2[j][mTab2Counter[j]] = 0;
	if( mTab2Counter[j] > 14 )
	    fprintf( stderr, "Error! Inverse mTab too small!\n" );
    }
}
